/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.dialog;

import java.util.Collection;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.FilterParser;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.filter.filters.GroupFilter;
import net.querz.mcaselector.filter.filters.InhabitedTimeFilter;
import net.querz.mcaselector.filter.filters.ScriptFilter;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.ui.UIFactory;
import net.querz.mcaselector.ui.component.CodeEditor;
import net.querz.mcaselector.ui.component.PersistentDialogProperties;
import net.querz.mcaselector.ui.component.filter.GroupFilterBox;
import net.querz.mcaselector.util.exception.ParseException;
import net.querz.mcaselector.util.validation.BeforeAfterCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilterChunksDialog
extends Dialog<Result>
implements PersistentDialogProperties {
    private static final Logger LOGGER = LogManager.getLogger(FilterChunksDialog.class);
    private static GroupFilter gf = new GroupFilter();
    private static final String initScript = "import net.querz.mcaselector.io.mca.ChunkData;\nimport net.querz.nbt.*;\n\nvoid before() {\n\t\n}\n\nboolean filter(ChunkData data) {\n\t\n}\n\nvoid after() {\n\t\n}";
    private GroupFilter value = gf;
    private final TabPane tabs = new TabPane();
    private final TextField filterQuery = new TextField();
    private final GroupFilterBox groupFilterBox = new GroupFilterBox(null, this.value, true);
    private final RadioButton select = UIFactory.radio(Translation.DIALOG_FILTER_CHUNKS_SELECT);
    private final RadioButton export = UIFactory.radio(Translation.DIALOG_FILTER_CHUNKS_EXPORT);
    private final RadioButton delete = UIFactory.radio(Translation.DIALOG_FILTER_CHUNKS_DELETE);
    private final Label selectionOnlyLabel = UIFactory.label(Translation.DIALOG_FILTER_CHUNKS_SELECTION_ONLY);
    private final Label overwriteSelectionLabel = UIFactory.label(Translation.DIALOG_FILTER_CHUNKS_OVERWRITE_SELECTION);
    private final Label selectionRadiusLabel = UIFactory.label(Translation.DIALOG_FILTER_CHUNKS_SELECTION_RADIUS);
    private final CheckBox selectionOnly = new CheckBox();
    private final CheckBox overwriteSelection = new CheckBox();
    private final TextField selectionRadius = new TextField();
    private static final CodeEditor codeEditor;
    private static int lastSelectedTab;
    private static int radius;
    private static boolean applyToSelectionOnly;
    private static boolean applyOverwriteSelection;

    public FilterChunksDialog(Stage primaryStage) {
        this.titleProperty().bind((ObservableValue)Translation.DIALOG_FILTER_CHUNKS_TITLE.getProperty());
        this.initStyle(StageStyle.UTILITY);
        this.getDialogPane().getStyleClass().add((Object)"filter-dialog-pane");
        this.setResultConverter(p -> {
            GroupFilter filter;
            ConfigProvider.GLOBAL.setFilterScript(codeEditor.getSource());
            if (p != ButtonType.OK) {
                return null;
            }
            ScriptFilter scriptFilter = null;
            if (this.tabs.getSelectionModel().isSelected(0)) {
                filter = this.value;
            } else {
                filter = new GroupFilter();
                scriptFilter = new ScriptFilter();
                scriptFilter.setFilterValue(codeEditor.getText());
                filter.addFilter(scriptFilter);
            }
            return new Result(filter, this.getHandleType(), applyToSelectionOnly, applyOverwriteSelection, radius, scriptFilter);
        });
        this.getDialogPane().getScene().getStylesheets().addAll((Collection)primaryStage.getScene().getStylesheets());
        this.getDialogPane().getScene().getStylesheets().add((Object)Objects.requireNonNull(FilterChunksDialog.class.getClassLoader().getResource("style/component/filter-chunks-dialog.css")).toExternalForm());
        codeEditor.setOwner(this.getDialogPane().getScene().getWindow());
        codeEditor.setRecentFiles(ConfigProvider.GLOBAL.getRecentFilterScripts());
        codeEditor.setSource(ConfigProvider.GLOBAL.getFilterScript());
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.select.setTooltip(UIFactory.tooltip(Translation.DIALOG_FILTER_CHUNKS_SELECT_TOOLTIP));
        this.export.setTooltip(UIFactory.tooltip(Translation.DIALOG_FILTER_CHUNKS_EXPORT_TOOLTIP));
        this.delete.setTooltip(UIFactory.tooltip(Translation.DIALOG_FILTER_CHUNKS_DELETE_TOOLTIP));
        ToggleGroup toggleGroup = new ToggleGroup();
        toggleGroup.getToggles().addAll((Object[])new Toggle[]{this.select, this.export, this.delete});
        this.select.fire();
        this.selectionOnly.setSelected(applyToSelectionOnly);
        this.selectionOnly.setOnAction(e -> {
            applyToSelectionOnly = this.selectionOnly.isSelected();
        });
        this.overwriteSelection.setSelected(applyOverwriteSelection);
        this.overwriteSelection.setOnAction(e -> {
            applyOverwriteSelection = this.overwriteSelection.isSelected();
        });
        EventHandler selectEnable = e -> {
            this.selectionRadius.setDisable(!this.select.isSelected());
            this.overwriteSelection.setDisable(!this.select.isSelected());
        };
        this.select.setOnAction(selectEnable);
        this.export.setOnAction(selectEnable);
        this.delete.setOnAction(selectEnable);
        this.setResizable(true);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)this.groupFilterBox);
        this.groupFilterBox.prefWidthProperty().bind((ObservableValue)scrollPane.prefWidthProperty());
        this.groupFilterBox.setOnUpdate(f -> {
            this.getDialogPane().lookupButton(ButtonType.OK).setDisable(!this.value.isValid());
            if (this.value.isValid()) {
                this.filterQuery.setText(this.value.toString());
            }
            if (this.value.selectionOnly()) {
                if (this.delete.isSelected()) {
                    this.select.fire();
                }
                this.delete.setDisable(true);
            } else {
                this.delete.setDisable(false);
            }
        });
        this.filterQuery.setText(gf.toString());
        this.filterQuery.setOnAction(e -> {
            FilterParser fp = new FilterParser(this.filterQuery.getText());
            try {
                gf = fp.parse();
                gf = FilterParser.unwrap(gf);
                LOGGER.debug("parsed filter query from: {}, to: {}", (Object)this.filterQuery.getText(), (Object)gf);
                this.value = gf;
                this.groupFilterBox.setFilter(gf);
            }
            catch (ParseException ex) {
                LOGGER.warn("failed to parse filter query from: {}, error: {}", (Object)this.filterQuery.getText(), (Object)ex.getMessage());
            }
        });
        this.selectionRadius.setText((String)(radius == 0 ? "" : "" + radius));
        this.selectionRadius.textProperty().addListener((a, o, n) -> this.onSelectionRadiusInput((String)o, (String)n));
        VBox actionBox = new VBox();
        actionBox.getChildren().addAll((Object[])new Node[]{this.select, this.export, this.delete});
        GridPane optionBox = new GridPane();
        optionBox.getStyleClass().add((Object)"filter-dialog-option-box");
        optionBox.add((Node)this.selectionOnlyLabel, 0, 0, 1, 1);
        optionBox.add((Node)this.withStackPane((Node)this.selectionOnly), 1, 0, 1, 1);
        optionBox.add((Node)this.overwriteSelectionLabel, 0, 1, 1, 1);
        optionBox.add((Node)this.withStackPane((Node)this.overwriteSelection), 1, 1, 1, 1);
        optionBox.add((Node)this.selectionRadiusLabel, 0, 2, 1, 1);
        optionBox.add((Node)this.withStackPane((Node)this.selectionRadius), 1, 2, 1, 1);
        HBox selectionBox = new HBox();
        selectionBox.getChildren().addAll((Object[])new Node[]{actionBox, optionBox});
        VBox mainBox = new VBox();
        mainBox.getChildren().addAll((Object[])new Node[]{scrollPane, new Separator(), this.filterQuery});
        Tab mainTab = UIFactory.tab(Translation.DIALOG_FILTER_CHUNKS_TAB_QUERY);
        mainTab.setContent((Node)mainBox);
        Tab scriptTab = UIFactory.tab(Translation.DIALOG_FILTER_CHUNKS_TAB_SCRIPT);
        scriptTab.setContent((Node)codeEditor);
        this.tabs.getTabs().addAll((Object[])new Tab[]{mainTab, scriptTab});
        VBox panelBox = new VBox();
        panelBox.getChildren().addAll((Object[])new Node[]{this.tabs, new Separator(), selectionBox});
        this.getDialogPane().setContent((Node)panelBox);
        this.setOnCloseRequest(e -> {
            this.initPersistentLocationOnClose(this);
            lastSelectedTab = this.tabs.getSelectionModel().getSelectedIndex();
        });
        this.initPersistentLocationOnOpen(this);
        Platform.runLater(() -> this.tabs.getSelectionModel().select(lastSelectedTab));
    }

    private StackPane withStackPane(Node n) {
        StackPane stack = new StackPane();
        stack.getStyleClass().add((Object)"filter-dialog-stack-pane");
        stack.getChildren().add((Object)n);
        StackPane.setAlignment((Node)n, (Pos)Pos.CENTER);
        return stack;
    }

    private void onSelectionRadiusInput(String oldValue, String newValue) {
        if (newValue.isEmpty()) {
            radius = 0;
        } else {
            if (!newValue.matches("[0-9]+")) {
                this.selectionRadius.setText(oldValue);
                return;
            }
            radius = Integer.parseInt(newValue);
        }
    }

    private HandleType getHandleType() {
        if (this.select.isSelected()) {
            return HandleType.SELECT;
        }
        if (this.export.isSelected()) {
            return HandleType.EXPORT;
        }
        if (this.delete.isSelected()) {
            return HandleType.DELETE;
        }
        return null;
    }

    static {
        InhabitedTimeFilter fiveMins = new InhabitedTimeFilter(Operator.AND, Comparator.SMALLER, 6000L);
        fiveMins.setFilterValue("5 minutes");
        gf.addFilter(fiveMins);
        codeEditor = new CodeEditor(initScript);
        applyOverwriteSelection = true;
    }

    public static enum HandleType {
        SELECT,
        EXPORT,
        DELETE;

    }

    public record Result(GroupFilter filter, HandleType type, boolean selectionOnly, boolean overwriteSelection, int radius, ScriptFilter script) implements BeforeAfterCallback
    {
        @Override
        public void before() {
            this.script.before();
        }

        @Override
        public void after() {
            this.script.after();
        }

        @Override
        public boolean valid() {
            return this.script != null;
        }
    }
}

