/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.dialog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import net.querz.mcaselector.changer.ChangeParser;
import net.querz.mcaselector.changer.Field;
import net.querz.mcaselector.changer.FieldType;
import net.querz.mcaselector.changer.fields.ScriptField;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.io.mca.RegionChunk;
import net.querz.mcaselector.io.mca.RegionMCAFile;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.tile.TileMap;
import net.querz.mcaselector.ui.UIFactory;
import net.querz.mcaselector.ui.component.CodeEditor;
import net.querz.mcaselector.ui.component.PersistentDialogProperties;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.property.DataProperty;
import net.querz.mcaselector.util.validation.BeforeAfterCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChangeNBTDialog
extends Dialog<Result>
implements PersistentDialogProperties {
    private static final Logger LOGGER = LogManager.getLogger(ChangeNBTDialog.class);
    private static final String initScript = "import net.querz.mcaselector.io.mca.ChunkData;\nimport net.querz.nbt.*;\n\nvoid before() {\n\t\n}\n\nvoid apply(ChunkData data) {\n\t\n}\n\nvoid after() {\n\t\n}";
    private final List<Field<?>> fields = new ArrayList();
    private final TabPane tabs = new TabPane();
    private final TextField changeQuery = new TextField();
    private final RadioButton change = UIFactory.radio(Translation.DIALOG_CHANGE_NBT_CHANGE);
    private final RadioButton force = UIFactory.radio(Translation.DIALOG_CHANGE_NBT_FORCE);
    private final CheckBox selectionOnly = UIFactory.checkbox(Translation.DIALOG_CHANGE_NBT_SELECTION_ONLY);
    private static final CodeEditor codeEditor = new CodeEditor("import net.querz.mcaselector.io.mca.ChunkData;\nimport net.querz.nbt.*;\n\nvoid before() {\n\t\n}\n\nvoid apply(ChunkData data) {\n\t\n}\n\nvoid after() {\n\t\n}");
    private static int lastSelectedTab;

    public ChangeNBTDialog(TileMap tileMap, Stage primaryStage) {
        this.titleProperty().bind((ObservableValue)Translation.DIALOG_CHANGE_NBT_TITLE.getProperty());
        this.initStyle(StageStyle.UTILITY);
        this.setResizable(true);
        this.getDialogPane().getStyleClass().add((Object)"change-nbt-dialog-pane");
        this.setResultConverter(p -> {
            ConfigProvider.GLOBAL.setChangeScript(codeEditor.getSource());
            if (p != ButtonType.OK) {
                return null;
            }
            if (this.tabs.getSelectionModel().isSelected(0)) {
                for (int i = 0; i < this.fields.size(); ++i) {
                    if (this.fields.get(i).needsChange()) continue;
                    this.fields.remove(i);
                    --i;
                }
                if (this.fields.isEmpty()) {
                    return null;
                }
                return new Result(this.fields, this.force.isSelected(), this.selectionOnly.isSelected(), null);
            }
            ScriptField scriptField = new ScriptField();
            scriptField.parseNewValue(codeEditor.getText());
            if (!scriptField.needsChange()) {
                return null;
            }
            return new Result(Collections.singletonList(scriptField), this.force.isSelected(), this.selectionOnly.isSelected(), scriptField);
        });
        this.getDialogPane().getScene().getStylesheets().addAll((Collection)primaryStage.getScene().getStylesheets());
        this.getDialogPane().getScene().getStylesheets().add((Object)Objects.requireNonNull(ChangeNBTDialog.class.getClassLoader().getResource("style/component/change-nbt-dialog.css")).toExternalForm());
        codeEditor.setOwner(this.getDialogPane().getScene().getWindow());
        codeEditor.setRecentFiles(ConfigProvider.GLOBAL.getRecentChangeScripts());
        codeEditor.setSource(ConfigProvider.GLOBAL.getChangeScript());
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        FieldView fieldView = new FieldView();
        for (FieldType fieldType : FieldType.uiValues()) {
            Field<?> field = fieldType.newInstance();
            fieldView.addField(field);
            this.fields.add(field);
        }
        if (tileMap.getSelectedChunks() == 1) {
            this.readSingleChunkAsync(tileMap, fieldView);
        }
        ToggleGroup toggleGroup = new ToggleGroup();
        toggleGroup.getToggles().addAll((Object[])new Toggle[]{this.change, this.force});
        this.change.fire();
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)fieldView);
        fieldView.prefWidthProperty().bind((ObservableValue)scrollPane.widthProperty());
        VBox actionBox = new VBox();
        this.change.setTooltip(UIFactory.tooltip(Translation.DIALOG_CHANGE_NBT_CHANGE_TOOLTIP));
        this.force.setTooltip(UIFactory.tooltip(Translation.DIALOG_CHANGE_NBT_FORCE_TOOLTIP));
        actionBox.getChildren().addAll((Object[])new Node[]{this.change, this.force});
        VBox optionBox = new VBox();
        this.selectionOnly.setTooltip(UIFactory.tooltip(Translation.DIALOG_CHANGE_NBT_SELECTION_ONLY_TOOLTIP));
        this.selectionOnly.setSelected(true);
        optionBox.getChildren().add((Object)this.selectionOnly);
        this.changeQuery.setOnAction(e -> {
            String text = this.changeQuery.getText();
            int caret = this.changeQuery.getCaretPosition();
            ChangeParser cp = new ChangeParser(text);
            try {
                List<Field<?>> f = cp.parse();
                fieldView.updateFields(f);
            }
            catch (Exception ex) {
                LOGGER.warn("failed to parse change query from: {}, error: {}", (Object)this.changeQuery.getText(), (Object)ex.getMessage());
                fieldView.updateFields(Collections.emptyList());
            }
            this.changeQuery.setText(text);
            this.changeQuery.positionCaret(caret);
        });
        HBox selectionBox = new HBox();
        selectionBox.getChildren().addAll((Object[])new Node[]{actionBox, optionBox});
        VBox mainBox = new VBox();
        mainBox.getChildren().addAll((Object[])new Node[]{scrollPane, new Separator(), this.changeQuery});
        Tab mainTab = UIFactory.tab(Translation.DIALOG_CHANGE_NBT_TAB_QUERY);
        mainTab.setContent((Node)mainBox);
        Tab scriptTab = UIFactory.tab(Translation.DIALOG_CHANGE_NBT_TAB_SCRIPT);
        scriptTab.setContent((Node)codeEditor);
        this.tabs.getTabs().addAll((Object[])new Tab[]{mainTab, scriptTab});
        VBox panelBox = new VBox();
        panelBox.getChildren().addAll((Object[])new Node[]{this.tabs, new Separator(), selectionBox});
        this.getDialogPane().setContent((Node)panelBox);
        this.setOnCloseRequest(e -> {
            this.initPersistentLocationOnClose(this);
            lastSelectedTab = this.tabs.getSelectionModel().getSelectedIndex();
        });
        this.initPersistentLocationOnOpen(this);
        Platform.runLater(() -> this.tabs.getSelectionModel().select(lastSelectedTab));
    }

    private void readSingleChunkAsync(TileMap tileMap, FieldView fieldView) {
        new Thread(() -> {
            Selection selection = tileMap.getSelection();
            DataProperty region = new DataProperty();
            DataProperty chunk = new DataProperty();
            selection.forEach(e -> {
                region.set(new Point2i(e.getLongKey()));
                ((ChunkSet)e.getValue()).forEach(c -> chunk.set(new Point2i(c)));
            });
            File file = FileHelper.createMCAFilePath((Point2i)region.get());
            LOGGER.debug("attempting to read single chunk from file: {}", chunk.get());
            if (file.exists()) {
                try {
                    RegionChunk regionChunk = (RegionChunk)new RegionMCAFile(file).loadSingleChunk((Point2i)chunk.get());
                    ChunkData chunkData = new ChunkData(regionChunk, null, null, true);
                    fieldView.getChildren().forEach(child -> {
                        FieldCell cell = (FieldCell)((Object)((Object)child));
                        Object oldValue = cell.value.getOldValue(chunkData);
                        String promptText = oldValue == null ? "" : oldValue.toString();
                        Platform.runLater(() -> cell.textField.setPromptText(promptText));
                    });
                }
                catch (IOException ex) {
                    LOGGER.warn("failed to load single chunk", (Throwable)ex);
                }
            }
        }).start();
    }

    private class FieldView
    extends VBox {
        public FieldView() {
            this.getStyleClass().add((Object)"field-view");
        }

        public void addField(Field<?> field) {
            FieldCell fieldCell = new FieldCell(field, this.getChildren().size());
            fieldCell.prefWidthProperty().bind((ObservableValue)this.widthProperty());
            this.getChildren().add((Object)fieldCell);
        }

        public void updateFields(List<Field<?>> fields) {
            block0: for (Node child : this.getChildren()) {
                if (!(child instanceof FieldCell)) continue;
                FieldCell fieldCell = (FieldCell)child;
                for (Field<?> newField : fields) {
                    if (newField.getType() != fieldCell.value.getType()) continue;
                    fieldCell.value.setNewValueRaw(newField.getNewValue());
                    fieldCell.textField.setText(newField.valueToString());
                    fieldCell.textField.positionCaret(fieldCell.textField.getText().length());
                    continue block0;
                }
                fieldCell.textField.setText("");
            }
        }
    }

    private class FieldCell
    extends HBox {
        private final Field<?> value;
        private final TextField textField;
        private static final PseudoClass valid = PseudoClass.getPseudoClass((String)"valid");
        private static final PseudoClass even = PseudoClass.getPseudoClass((String)"even");
        private static final PseudoClass odd = PseudoClass.getPseudoClass((String)"odd");

        public FieldCell(Field<?> value, int index) {
            this.getStyleClass().add((Object)"field-cell");
            if (index % 2 == 0) {
                this.pseudoClassStateChanged(even, true);
            } else {
                this.pseudoClassStateChanged(odd, true);
            }
            this.value = value;
            this.textField = new TextField();
            this.textField.getStyleClass().add((Object)"field-cell-text");
            this.getChildren().addAll((Object[])new Node[]{new Label(value.getType().toString()), this.textField});
            this.textField.textProperty().addListener((a, o, n) -> this.onInput((String)n));
            this.textField.setAlignment(Pos.CENTER);
            this.textField.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
        }

        private void onInput(String newValue) {
            boolean result = this.value.parseNewValue(newValue);
            this.textField.pseudoClassStateChanged(valid, result);
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Field<?> field : ChangeNBTDialog.this.fields) {
                if (!field.needsChange()) continue;
                sb.append(first ? "" : ", ").append(field);
                first = false;
            }
            if (!sb.isEmpty()) {
                if (result) {
                    LOGGER.debug(sb);
                }
                ChangeNBTDialog.this.changeQuery.setText(sb.toString());
            } else {
                ChangeNBTDialog.this.changeQuery.setText(null);
            }
        }
    }

    public record Result(List<Field<?>> fields, boolean force, boolean selectionOnly, ScriptField script) implements BeforeAfterCallback
    {
        public boolean requiresClearCache() {
            for (Field<?> field : this.fields) {
                if (!field.getType().requiresClearCache()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void before() {
            this.script.before();
        }

        @Override
        public void after() {
            this.script.after();
        }

        @Override
        public boolean valid() {
            return this.script != null;
        }
    }
}

