/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component.filter;

import java.io.File;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import net.querz.mcaselector.filter.TextFilter;
import net.querz.mcaselector.ui.component.filter.FilterBox;
import net.querz.mcaselector.ui.component.filter.TextFilterBox;

public class FileFilterBox
extends TextFilterBox {
    public FileFilterBox(FilterBox parent, TextFilter<?> filter, boolean root) {
        super(parent, filter, root);
        this.input.setOnDragOver(this::onDragOver);
        this.input.setOnDragDropped(this::onDragDropped);
    }

    private void onDragDropped(DragEvent event) {
        Dragboard db = event.getDragboard();
        if (db.hasFiles()) {
            for (File file : db.getFiles()) {
                if (!file.exists()) continue;
                this.setText(file.getAbsolutePath());
                break;
            }
            event.setDropCompleted(true);
        }
        event.consume();
    }

    private void onDragOver(DragEvent event) {
        Dragboard db;
        if (event.getGestureSource() != this && event.getDragboard().hasFiles() && (db = event.getDragboard()).hasFiles()) {
            for (File file : db.getFiles()) {
                if (!file.exists()) continue;
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                event.consume();
                break;
            }
        }
    }
}

