/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component;

import java.util.Collection;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class TransparentStage
extends Stage {
    private final StackPane content;
    private final int shadowSize = 10;
    private double xOffset = 0.0;
    private double yOffset = 0.0;

    public TransparentStage(Window parent) {
        this.initStyle(StageStyle.TRANSPARENT);
        this.setResizable(false);
        this.initModality(Modality.APPLICATION_MODAL);
        this.initOwner(parent);
        Pane shadow = new Pane();
        shadow.getStyleClass().add((Object)"transparent-stage-shadow");
        Rectangle innerRect = new Rectangle();
        Rectangle outerRect = new Rectangle();
        shadow.layoutBoundsProperty().addListener((observable, oldBounds, newBounds) -> {
            innerRect.relocate(newBounds.getMinX() + 10.0, newBounds.getMinY() + 10.0);
            innerRect.setWidth(newBounds.getWidth() - 20.0);
            innerRect.setHeight(newBounds.getHeight() - 20.0);
            outerRect.setWidth(newBounds.getWidth());
            outerRect.setHeight(newBounds.getHeight());
            Shape clip = Shape.subtract((Shape)outerRect, (Shape)innerRect);
            shadow.setClip((Node)clip);
        });
        this.content = new StackPane(new Node[]{shadow});
        this.content.getStyleClass().add((Object)"transparent-stage-content-root");
        this.content.setOnMousePressed(e -> {
            this.xOffset = e.getSceneX();
            this.yOffset = e.getSceneY();
        });
        this.content.setOnMouseDragged(e -> {
            this.setX(e.getScreenX() - this.xOffset);
            this.setY(e.getScreenY() - this.yOffset);
        });
        Scene scene = new Scene((Parent)this.content);
        scene.setFill((Paint)Color.TRANSPARENT);
        scene.getStylesheets().addAll((Collection)parent.getScene().getStylesheets());
        this.setScene(scene);
        scene.getStylesheets().add((Object)Objects.requireNonNull(TransparentStage.class.getClassLoader().getResource("style/component/transparent-stage.css")).toExternalForm());
    }

    public void setContent(Node node) {
        node.getStyleClass().add((Object)"transparent-stage-content");
        this.content.getChildren().add((Object)node);
    }
}

