/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component;

import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.overlay.Overlay;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.tile.TileMap;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.property.DataProperty;
import net.querz.mcaselector.util.validation.ShutdownHooks;

public class StatusBar
extends StackPane {
    private static final int LOADING_ANIM_UPDATE_MILLIS = 500;
    private final GridPane grid = new GridPane();
    private final Label selectedChunks = new Label(String.valueOf((Object)Translation.STATUS_SELECTED) + ": 0");
    private final Label hoveredRegion = new Label(String.valueOf((Object)Translation.STATUS_REGION) + ": -, -");
    private final Label hoveredChunk = new Label(String.valueOf((Object)Translation.STATUS_CHUNK) + ": -, -");
    private final Label hoveredBlock = new Label(String.valueOf((Object)Translation.STATUS_BLOCK) + ": -, -");
    private final Label totalRegions = new Label(String.valueOf((Object)Translation.STATUS_TOTAL) + ": 0");
    private final Label queuedJobs = new Label(String.valueOf((Object)Translation.STATUS_QUEUE) + ": 0");
    private final Label overlay = new Label(String.valueOf((Object)Translation.STATUS_OVERLAY) + ": -");
    ImageView loadIcon = new ImageView(FileHelper.getIconFromResources("img/load"));
    BorderPane bp = new BorderPane();
    RotateTransition rt;

    public StatusBar(TileMap tileMap) {
        this.getStyleClass().add((Object)"status-bar");
        this.getStylesheets().add((Object)Objects.requireNonNull(StatusBar.class.getClassLoader().getResource("style/component/status-bar.css")).toExternalForm());
        this.grid.getStyleClass().add((Object)"status-bar-grid");
        tileMap.setOnUpdate(this::update);
        tileMap.setOnHover(this::update);
        for (int i = 0; i < 6; ++i) {
            ColumnConstraints constraints = new ColumnConstraints();
            constraints.setMinWidth(140.0);
            constraints.setFillWidth(true);
            this.grid.getColumnConstraints().add((Object)constraints);
        }
        this.grid.add((Node)this.hoveredBlock, 0, 0, 1, 1);
        this.grid.add((Node)this.hoveredChunk, 1, 0, 1, 1);
        this.grid.add((Node)this.hoveredRegion, 2, 0, 1, 1);
        this.grid.add((Node)this.selectedChunks, 3, 0, 1, 1);
        this.grid.add((Node)this.totalRegions, 4, 0, 1, 1);
        this.grid.add((Node)this.queuedJobs, 5, 0, 1, 1);
        this.grid.add((Node)this.overlay, 6, 0, 1, 1);
        StackPane.setAlignment((Node)this.grid, (Pos)Pos.CENTER_LEFT);
        this.getChildren().add((Object)this.grid);
        this.rt = new RotateTransition(Duration.millis((double)1000.0), (Node)this.loadIcon);
        this.rt.setByAngle(360.0);
        this.rt.setCycleCount(-1);
        this.rt.setInterpolator(Interpolator.LINEAR);
        StackPane.setAlignment((Node)this.bp, (Pos)Pos.CENTER_LEFT);
        this.getChildren().add((Object)this.bp);
        DataProperty<Boolean> b = new DataProperty<Boolean>(true);
        DataProperty<Integer> before = new DataProperty<Integer>(0);
        ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
        exec.scheduleAtFixedRate(() -> {
            if (!((Boolean)b.get()).booleanValue()) {
                return;
            }
            int activeJobs = JobHandler.getActiveJobs();
            if ((Integer)before.get() == 0 && activeJobs != 0) {
                Platform.runLater(() -> {
                    this.rt.play();
                    this.bp.setRight((Node)this.loadIcon);
                });
            } else if ((Integer)before.get() != 0 && activeJobs == 0) {
                Platform.runLater(() -> {
                    this.rt.stop();
                    this.bp.setRight(null);
                });
            }
            before.set(activeJobs);
        }, 500L, 500L, TimeUnit.MILLISECONDS);
        ShutdownHooks.addShutdownHook(() -> {
            b.set(false);
            exec.shutdownNow();
        });
    }

    private void update(TileMap tileMap) {
        this.selectedChunks.setText(String.valueOf((Object)Translation.STATUS_SELECTED) + ": " + String.valueOf(tileMap.getSelection().isInverted() ? "\u221e" : Integer.valueOf(tileMap.getSelectedChunks())));
        this.queuedJobs.setText(String.valueOf((Object)Translation.STATUS_QUEUE) + ": " + JobHandler.getActiveJobs());
        this.totalRegions.setText(String.valueOf((Object)Translation.STATUS_TOTAL) + ": " + tileMap.getLoadedTiles());
        Point2i b = tileMap.getHoveredBlock();
        if (b != null) {
            this.hoveredBlock.setText(String.valueOf((Object)Translation.STATUS_BLOCK) + ": " + b.getX() + ", " + b.getZ());
            Point2i c = b.blockToChunk();
            this.hoveredChunk.setText(String.valueOf((Object)Translation.STATUS_CHUNK) + ": " + c.getX() + ", " + c.getZ());
            Point2i r = b.blockToRegion();
            this.hoveredRegion.setText(String.valueOf((Object)Translation.STATUS_REGION) + ": " + r.getX() + ", " + r.getZ());
            this.updateOverlay(tileMap, c);
        } else {
            this.hoveredBlock.setText(String.valueOf((Object)Translation.STATUS_BLOCK) + ": -, -");
            this.hoveredChunk.setText(String.valueOf((Object)Translation.STATUS_CHUNK) + ": -, -");
            this.hoveredRegion.setText(String.valueOf((Object)Translation.STATUS_REGION) + ": -, -");
            this.updateOverlay(tileMap, null);
        }
    }

    private void updateOverlay(TileMap tileMap, Point2i chunk) {
        if (tileMap.getOverlay() != null) {
            Overlay p = tileMap.getOverlay();
            String s = p.getShortMultiValues();
            if (!p.isActive()) {
                this.overlay.setText(String.valueOf((Object)Translation.STATUS_OVERLAY) + ": " + String.valueOf((Object)p.getType()) + "(" + p.min() + ", " + p.max() + (String)(s == null ? "" : ", " + s) + "), -");
            } else if (chunk != null) {
                tileMap.getOverlayPool().getHoveredChunkValue(chunk, v -> this.overlay.setText(String.valueOf((Object)Translation.STATUS_OVERLAY) + ": " + String.valueOf((Object)p.getType()) + "(" + p.min() + ", " + p.max() + (String)(s == null ? "" : ", " + s) + "), " + String.valueOf(v == null ? "-" : v)));
            } else {
                this.overlay.setText(String.valueOf((Object)Translation.STATUS_OVERLAY) + ": " + String.valueOf((Object)p.getType()) + "(" + p.min() + ", " + p.max() + (String)(s == null ? "" : ", " + s) + "), -");
            }
        } else {
            this.overlay.setText(String.valueOf((Object)Translation.STATUS_OVERLAY) + ": -, -");
        }
    }
}

