/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component;

import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.control.Dialog;
import net.querz.mcaselector.util.point.Point2i;

public interface PersistentDialogProperties {
    public static final Map<Class<? extends Dialog>, Point2i> lastWindowSize = new HashMap<Class<? extends Dialog>, Point2i>();
    public static final Map<Class<? extends Dialog>, Point2i> lastWindowLocation = new HashMap<Class<? extends Dialog>, Point2i>();

    public double getWidth();

    public double getHeight();

    public double getX();

    public double getY();

    default public void initPersistentLocationOnClose(Dialog<?> dialog) {
        lastWindowSize.put(dialog.getClass(), new Point2i((int)this.getWidth(), (int)this.getHeight()));
        lastWindowLocation.put(dialog.getClass(), new Point2i((int)this.getX(), (int)this.getY()));
    }

    default public void initPersistentLocationOnOpen(Dialog<?> dialog) {
        Point2i lastSize = lastWindowSize.get(dialog.getClass());
        Point2i lastLocation = lastWindowLocation.get(dialog.getClass());
        if (lastSize != null && lastLocation != null && lastSize.getX() != 0 && lastSize.getZ() != 0) {
            Platform.runLater(() -> {
                dialog.setWidth((double)lastSize.getX());
                dialog.setHeight((double)lastSize.getZ());
                dialog.setX((double)lastLocation.getX());
                dialog.setY((double)lastLocation.getZ());
            });
        }
    }
}

