/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.css.PseudoClass;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.ImageHelper;
import net.querz.mcaselector.overlay.Overlay;
import net.querz.mcaselector.overlay.OverlayType;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.ui.UIFactory;
import net.querz.mcaselector.ui.component.HueRangeSlider;
import net.querz.mcaselector.util.property.DataProperty;

public class OverlayBox
extends BorderPane {
    private static final Image deleteIcon = FileHelper.getIconFromResources("img/delete");
    private static final Image flipIcon = FileHelper.getIconFromResources("img/flip");
    private static final PseudoClass invalid = PseudoClass.getPseudoClass((String)"invalid");
    private static final PseudoClass selected = PseudoClass.getPseudoClass((String)"selected");
    public DataProperty<Overlay> valueProperty;
    private BiConsumer<Overlay, Overlay> onTypeChange;
    private Consumer<Overlay> onValuesChange;
    private Consumer<Overlay> onDelete;
    private final GridPane inputs = new GridPane();
    private final GridPane options = new GridPane();
    private final ComboBox<OverlayType> type = new ComboBox();
    private final TextField minimum = new TextField();
    private final TextField maximum = new TextField();
    protected final TextField additionalData = new TextField();
    private final Label gradient = new Label("");
    private final CheckBox active = new CheckBox();
    private final Label delete = new Label("", (Node)new ImageView(deleteIcon));

    public OverlayBox(Overlay value) {
        this.getStylesheets().add((Object)Objects.requireNonNull(OverlayBox.class.getClassLoader().getResource("style/component/overlay-box.css")).toExternalForm());
        this.valueProperty = new DataProperty<Overlay>(value);
        this.getStyleClass().add((Object)"overlay-box");
        this.type.getItems().addAll((Object[])OverlayType.values());
        this.type.getSelectionModel().select((Object)value.getType());
        this.type.setOnAction(e -> this.update((OverlayType)((Object)((Object)this.type.getSelectionModel().getSelectedItem()))));
        this.minimum.textProperty().addListener((a, b, c) -> this.onMinimumInput((String)c));
        this.maximum.textProperty().addListener((a, b, c) -> this.onMaximumInput((String)c));
        this.minimum.setAlignment(Pos.CENTER);
        this.maximum.setAlignment(Pos.CENTER);
        this.minimum.setPromptText("<min>");
        this.maximum.setPromptText("<max>");
        this.inputs.getStyleClass().add((Object)"overlay-input-grid");
        this.inputs.add(this.type, 0, 0, 1, 1);
        this.inputs.add((Node)this.minimum, 1, 0, 1, 1);
        this.inputs.add((Node)this.maximum, 2, 0, 1, 1);
        this.setLeft((Node)this.inputs);
        this.additionalData.setAlignment(Pos.CENTER);
        this.additionalData.textProperty().addListener((a, b, c) -> this.onAdditionalDataInput((String)c));
        this.setCenter((Node)this.additionalData);
        this.options.getStyleClass().add((Object)"overlay-options-grid");
        this.active.selectedProperty().addListener((v, o, n) -> {
            this.getValue().setActive((boolean)n);
            if (this.onValuesChange != null) {
                this.onValuesChange.accept(this.getValue());
            }
        });
        this.active.setTooltip(UIFactory.tooltip(Translation.DIALOG_EDIT_OVERLAYS_OVERLAY_ACTIVE_TOOLTIP));
        this.gradient.getStyleClass().add((Object)"gradient-label");
        ContextMenu gradientMenu = new ContextMenu();
        gradientMenu.setOnHiding(e -> this.onValuesChange.accept(this.getValue()));
        HueRangeSlider hueSlider = new HueRangeSlider(0.0f, 0.85f, value.getMinHue(), value.getMaxHue(), 400);
        this.setGradientBackground(hueSlider);
        Label flip = new Label("", (Node)new ImageView(flipIcon));
        flip.getStyleClass().add((Object)"flip-label");
        flip.setOnMouseReleased(a -> {
            hueSlider.setInverted(!hueSlider.isInverted());
            this.getValue().setMinHue(hueSlider.getMinHue());
            this.getValue().setMaxHue(hueSlider.getMaxHue());
            this.setGradientBackground(hueSlider);
        });
        hueSlider.lowProperty().addListener((v, o, n) -> {
            this.getValue().setMinHue(hueSlider.getMinHue());
            this.getValue().setMaxHue(hueSlider.getMaxHue());
            this.setGradientBackground(hueSlider);
        });
        hueSlider.highProperty().addListener((v, o, n) -> {
            this.getValue().setMinHue(hueSlider.getMinHue());
            this.getValue().setMaxHue(hueSlider.getMaxHue());
            this.setGradientBackground(hueSlider);
        });
        HBox slider = new HBox();
        slider.getStyleClass().add((Object)"slider-box");
        slider.setAlignment(Pos.CENTER_LEFT);
        slider.getChildren().addAll((Object[])new Node[]{hueSlider, flip});
        CustomMenuItem menuItem = new CustomMenuItem((Node)slider, false);
        menuItem.getStyleClass().add((Object)"custom-menu-item");
        gradientMenu.getItems().add((Object)menuItem);
        this.gradient.setOnMouseClicked(e -> {
            Bounds screenBounds = this.gradient.localToScreen(this.gradient.getBoundsInLocal());
            gradientMenu.show((Node)this.gradient, screenBounds.getMinX(), screenBounds.getMinY());
            Platform.runLater(() -> {
                gradientMenu.setX((screenBounds.getMinX() + screenBounds.getMaxX()) / 2.0 - gradientMenu.getWidth() / 2.0);
                gradientMenu.setY((screenBounds.getMinY() + screenBounds.getMaxY()) / 2.0 - gradientMenu.getHeight() / 2.0);
            });
        });
        this.options.add((Node)this.gradient, 0, 0, 1, 1);
        this.options.add((Node)this.active, 1, 0, 1, 1);
        this.options.add((Node)this.delete, 2, 0, 1, 1);
        this.delete.getStyleClass().add((Object)"control-label");
        this.delete.setOnMouseReleased(e -> this.onDelete.accept(this.getValue()));
        this.delete.setTooltip(UIFactory.tooltip(Translation.DIALOG_EDIT_OVERLAYS_DELETE_TOOLTIP));
        this.setRight((Node)this.options);
        this.additionalData.setDisable(value.multiValues() == null);
        this.minimum.setText(value.getRawMin());
        this.maximum.setText(value.getRawMax());
        if (value.multiValues() != null) {
            this.additionalData.setText(value.getRawMultiValues());
        }
        this.active.setSelected(value.isActive());
        this.onMinimumInput(value.minString());
        this.onMaximumInput(value.maxString());
    }

    public void setSelected(boolean selected) {
        this.pseudoClassStateChanged(OverlayBox.selected, selected);
    }

    private Overlay getValue() {
        return this.valueProperty.get();
    }

    private void setGradientBackground(HueRangeSlider hueSlider) {
        float min = (float)hueSlider.getLow();
        float max = (float)hueSlider.getHigh();
        if (hueSlider.isInverted()) {
            min = 0.85f - max;
            max = 0.85f - (float)hueSlider.getLow();
        }
        this.gradient.setBackground(new Background(new BackgroundImage[]{new BackgroundImage(ImageHelper.renderGradient(50, min, max, min, max, hueSlider.isInverted()), BackgroundRepeat.NO_REPEAT, BackgroundRepeat.REPEAT, BackgroundPosition.DEFAULT, BackgroundSize.DEFAULT)}));
    }

    public void setOnTypeChange(BiConsumer<Overlay, Overlay> consumer) {
        this.onTypeChange = consumer;
    }

    public void setOnValuesChange(Consumer<Overlay> consumer) {
        this.onValuesChange = consumer;
    }

    public void setOnDelete(Consumer<Overlay> consumer) {
        this.onDelete = consumer;
    }

    private void update(OverlayType type) {
        if (type == null || type == this.getValue().getType()) {
            return;
        }
        Overlay oldValue = this.getValue();
        Overlay newValue = type.instance();
        newValue.setActive(this.getValue().isActive());
        this.valueProperty.set(newValue);
        this.onMinimumInput(this.minimum.getText());
        this.onMaximumInput(this.maximum.getText());
        this.additionalData.setDisable(newValue.multiValues() == null);
        this.active.setSelected(newValue.isActive());
        this.onTypeChange.accept(oldValue, this.getValue());
    }

    private void onMinimumInput(String newValue) {
        this.displayValid(this.getValue().setMin(newValue));
        if (this.onValuesChange != null) {
            this.onValuesChange.accept(this.getValue());
        }
    }

    private void onMaximumInput(String newValue) {
        this.displayValid(this.getValue().setMax(newValue));
        if (this.onValuesChange != null) {
            this.onValuesChange.accept(this.getValue());
        }
    }

    private void onAdditionalDataInput(String newValue) {
        this.displayValid(this.getValue().setMultiValuesString(newValue));
        if (this.onValuesChange != null) {
            this.onValuesChange.accept(this.getValue());
        }
    }

    private void displayValid(boolean valid) {
        this.pseudoClassStateChanged(invalid, !valid);
    }
}

