/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.CacheHelper;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.selection.ClipboardSelection;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.tile.TileMap;
import net.querz.mcaselector.ui.DialogHelper;
import net.querz.mcaselector.ui.UIFactory;
import net.querz.mcaselector.ui.component.HeightSlider;
import net.querz.mcaselector.ui.dialog.ConfirmationDialog;
import net.querz.mcaselector.util.github.VersionChecker;

public class OptionBar
extends BorderPane {
    private final MenuBar menuBar = new MenuBar();
    private final Menu file = UIFactory.menu(Translation.MENU_FILE);
    private final Menu view = UIFactory.menu(Translation.MENU_VIEW);
    private final Menu selection = UIFactory.menu(Translation.MENU_SELECTION);
    private final Menu tools = UIFactory.menu(Translation.MENU_TOOLS);
    private final Label about = UIFactory.label(Translation.MENU_ABOUT);
    private final HeightSlider hSlider = new HeightSlider(319, true);
    private final MenuItem openWorld = UIFactory.menuItem(Translation.MENU_FILE_OPEN_WORLD);
    private final Menu openDimension = UIFactory.menu(Translation.MENU_FILE_OPEN_DIMENSION);
    private final Menu openRecent = UIFactory.menu(Translation.MENU_FILE_OPEN_RECENT_WORLD);
    private final MenuItem settings = UIFactory.menuItem(Translation.MENU_FILE_SETTINGS);
    private final MenuItem renderSettings = UIFactory.menuItem(Translation.MENU_FILE_RENDER_SETTINGS);
    private final MenuItem quit = UIFactory.menuItem(Translation.MENU_FILE_QUIT);
    private final MenuItem reload = UIFactory.menuItem(Translation.MENU_VIEW_RELOAD);
    private final CheckMenuItem chunkGrid = UIFactory.checkMenuItem(Translation.MENU_VIEW_CHUNK_GRID, true);
    private final CheckMenuItem regionGrid = UIFactory.checkMenuItem(Translation.MENU_VIEW_REGION_GRID, true);
    private final CheckMenuItem coordinates = UIFactory.checkMenuItem(Translation.MENU_VIEW_COORDINATES, false);
    private final MenuItem goTo = UIFactory.menuItem(Translation.MENU_VIEW_GOTO);
    private final MenuItem resetZoom = UIFactory.menuItem(Translation.MENU_VIEW_RESET_ZOOM);
    private final MenuItem saveScreenshot = UIFactory.menuItem(Translation.MENU_VIEW_SAVE_SCREENSHOT);
    private final MenuItem clearViewCache = UIFactory.menuItem(Translation.MENU_VIEW_CLEAR_CACHE);
    private final MenuItem clearAllCache = UIFactory.menuItem(Translation.MENU_VIEW_CLEAR_ALL_CACHE);
    private final MenuItem clear = UIFactory.menuItem(Translation.MENU_SELECTION_CLEAR);
    private final MenuItem invert = UIFactory.menuItem(Translation.MENU_SELECTION_INVERT);
    private final MenuItem invertRegions = UIFactory.menuItem(Translation.MENU_SELECTION_INVERT_REGIONS);
    private final MenuItem copy = UIFactory.menuItem(Translation.MENU_SELECTION_COPY_CHUNKS);
    private final MenuItem paste = UIFactory.menuItem(Translation.MENU_SELECTION_PASTE_CHUNKS);
    private final MenuItem exportChunks = UIFactory.menuItem(Translation.MENU_SELECTION_EXPORT_CHUNKS);
    private final MenuItem importChunks = UIFactory.menuItem(Translation.MENU_TOOLS_IMPORT_CHUNKS);
    private final MenuItem delete = UIFactory.menuItem(Translation.MENU_SELECTION_DELETE_CHUNKS);
    private final MenuItem importSelection = UIFactory.menuItem(Translation.MENU_SELECTION_IMPORT_SELECTION);
    private final MenuItem exportSelection = UIFactory.menuItem(Translation.MENU_SELECTION_EXPORT_SELECTION);
    private final MenuItem exportImage = UIFactory.menuItem(Translation.MENU_SELECTION_EXPORT_IMAGE);
    private final MenuItem clearSelectionCache = UIFactory.menuItem(Translation.MENU_SELECTION_CLEAR_CACHE);
    private final MenuItem filterChunks = UIFactory.menuItem(Translation.MENU_TOOLS_FILTER_CHUNKS);
    private final MenuItem changeFields = UIFactory.menuItem(Translation.MENU_TOOLS_CHANGE_FIELDS);
    private final MenuItem editNBT = UIFactory.menuItem(Translation.MENU_TOOLS_EDIT_NBT);
    private final MenuItem swapChunks = UIFactory.menuItem(Translation.MENU_TOOLS_SWAP_CHUNKS);
    private final MenuItem editOverlays = UIFactory.menuItem(Translation.MENU_TOOLS_EDIT_OVERLAYS);
    private final MenuItem nextOverlay = UIFactory.menuItem(Translation.MENU_TOOLS_NEXT_OVERLAY);
    private final MenuItem nextOverlayType = UIFactory.menuItem(Translation.MENU_TOOLS_NEXT_OVERLAY_TYPE);
    private final MenuItem sumSelection = UIFactory.menuItem(Translation.MENU_TOOLS_SUM_SELECTION);
    private int previousSelectedChunks = 0;
    private boolean previousInvertedSelection = false;
    private final IntegerProperty heightValue = new SimpleIntegerProperty(319);
    private final BooleanProperty heightDisabled = new SimpleBooleanProperty(false);

    public OptionBar(TileMap tileMap, Stage primaryStage) {
        this.getStyleClass().add((Object)"option-bar-box");
        this.menuBar.getStyleClass().add((Object)"option-bar");
        this.getStylesheets().add((Object)Objects.requireNonNull(OptionBar.class.getClassLoader().getResource("style/component/option-bar.css")).toExternalForm());
        tileMap.setOnUpdate(this::onUpdate);
        this.file.getItems().addAll((Object[])new MenuItem[]{this.openWorld, this.openDimension, this.openRecent, UIFactory.separator(), this.settings, this.renderSettings, UIFactory.separator(), this.quit});
        this.view.getItems().addAll((Object[])new MenuItem[]{this.reload, UIFactory.separator(), this.chunkGrid, this.regionGrid, this.coordinates, UIFactory.separator(), this.goTo, this.resetZoom, UIFactory.separator(), this.saveScreenshot, UIFactory.separator(), this.clearViewCache, this.clearAllCache});
        this.selection.getItems().addAll((Object[])new MenuItem[]{this.clear, this.invert, this.invertRegions, UIFactory.separator(), this.copy, this.paste, UIFactory.separator(), this.exportChunks, this.delete, UIFactory.separator(), this.importSelection, this.exportSelection, UIFactory.separator(), this.exportImage, UIFactory.separator(), this.clearSelectionCache});
        this.tools.getItems().addAll((Object[])new MenuItem[]{this.importChunks, this.filterChunks, this.changeFields, this.editNBT, UIFactory.separator(), this.swapChunks, UIFactory.separator(), this.editOverlays, this.nextOverlay, this.nextOverlayType, this.sumSelection});
        this.about.setOnMouseClicked(e -> DialogHelper.showAboutDialog(primaryStage));
        Menu aboutMenu = new Menu();
        aboutMenu.setGraphic((Node)this.about);
        this.hSlider.getStyleClass().add((Object)"option-bar-slider-box");
        this.heightValue.bind((ObservableValue)this.hSlider.valueProperty());
        this.heightValue.addListener((v, o, n) -> {
            if (!tileMap.getDisabled()) {
                this.heightDisabled.set(true);
                ConfigProvider.WORLD.setRenderHeight(n.intValue());
                CacheHelper.clearAllCacheAsync(tileMap, () -> {
                    this.heightDisabled.set(false);
                    if (this.hSlider.getValue() != this.heightValue.get()) {
                        this.heightValue.set(this.hSlider.getValue());
                    }
                });
            }
        });
        this.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                tileMap.requestFocus();
            }
        });
        this.menuBar.getMenus().addAll((Object[])new Menu[]{this.file, this.view, this.selection, this.tools, aboutMenu});
        this.openWorld.setOnAction(e -> DialogHelper.openWorld(tileMap, primaryStage));
        this.settings.setOnAction(e -> DialogHelper.editSettings(tileMap, primaryStage, false));
        this.renderSettings.setOnAction(e -> DialogHelper.editSettings(tileMap, primaryStage, true));
        this.quit.setOnAction(e -> DialogHelper.quit(tileMap, primaryStage));
        this.reload.setOnAction(e -> tileMap.reload());
        this.chunkGrid.setOnAction(e -> tileMap.setShowChunkGrid(this.chunkGrid.isSelected()));
        this.regionGrid.setOnAction(e -> tileMap.setShowRegionGrid(this.regionGrid.isSelected()));
        this.coordinates.setOnAction(e -> tileMap.setShowCoordinates(this.coordinates.isSelected()));
        this.goTo.setOnAction(e -> DialogHelper.gotoCoordinate(tileMap, primaryStage));
        this.resetZoom.setOnAction(e -> tileMap.setScale(1.0f));
        this.saveScreenshot.setOnAction(e -> DialogHelper.screenshot(tileMap, primaryStage));
        this.clearAllCache.setOnAction(e -> CacheHelper.clearAllCache(tileMap));
        this.clearViewCache.setOnAction(e -> CacheHelper.clearViewCache(tileMap));
        this.clear.setOnAction(e -> tileMap.clearSelection());
        this.invert.setOnAction(e -> tileMap.invertSelection());
        this.invertRegions.setOnAction(e -> tileMap.invertRegionsWithSelection());
        this.copy.setOnAction(e -> DialogHelper.copySelectedChunks(tileMap));
        this.paste.setOnAction(e -> DialogHelper.pasteSelectedChunks(tileMap, primaryStage));
        this.exportChunks.setOnAction(e -> DialogHelper.exportSelectedChunks(tileMap, primaryStage));
        this.importChunks.setOnAction(e -> DialogHelper.importChunks(tileMap, primaryStage));
        this.delete.setOnAction(e -> DialogHelper.deleteSelection(tileMap, primaryStage));
        this.importSelection.setOnAction(e -> DialogHelper.importSelection(tileMap, primaryStage));
        this.exportSelection.setOnAction(e -> DialogHelper.exportSelection(tileMap, primaryStage));
        this.exportImage.setOnAction(e -> DialogHelper.generateImageFromSelection(tileMap, primaryStage));
        this.clearSelectionCache.setOnAction(e -> CacheHelper.clearSelectionCache(tileMap));
        this.filterChunks.setOnAction(e -> DialogHelper.filterChunks(tileMap, primaryStage));
        this.changeFields.setOnAction(e -> DialogHelper.changeFields(tileMap, primaryStage));
        this.editNBT.setOnAction(e -> DialogHelper.editNBT(tileMap, primaryStage));
        this.swapChunks.setOnAction(e -> DialogHelper.swapChunks(tileMap, primaryStage));
        this.editOverlays.setOnAction(e -> DialogHelper.editOverlays(tileMap, primaryStage));
        this.nextOverlay.setOnAction(e -> tileMap.nextOverlay());
        this.nextOverlayType.setOnAction(e -> tileMap.nextOverlayType());
        this.sumSelection.setOnAction(e -> DialogHelper.sumSelection(tileMap, primaryStage));
        this.openWorld.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.settings.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.COMMA, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.renderSettings.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.E, new KeyCombination.Modifier[0]));
        this.quit.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Q, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.reload.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F5, new KeyCombination.Modifier[0]));
        this.chunkGrid.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.T, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.regionGrid.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.coordinates.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.goTo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.G, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.resetZoom.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT0, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.saveScreenshot.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.clearAllCache.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.K, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN, KeyCodeCombination.SHIFT_DOWN}));
        this.clearViewCache.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.K, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.clear.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.L, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.invert.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.U, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.invertRegions.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.U, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN, KeyCodeCombination.SHIFT_DOWN}));
        this.copy.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.paste.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.exportChunks.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.E, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN, KeyCodeCombination.SHIFT_DOWN}));
        this.importChunks.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN, KeyCodeCombination.SHIFT_DOWN}));
        this.delete.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.D, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.importSelection.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.exportSelection.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.E, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.clearSelectionCache.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.J, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.filterChunks.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.changeFields.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.editNBT.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.B, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.swapChunks.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.M, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.editOverlays.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.H, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        this.nextOverlay.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[0]));
        this.nextOverlayType.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[0]));
        this.setSelectionDependentMenuItemsEnabled(tileMap, tileMap.getSelectedChunks(), tileMap.getSelection().isInverted());
        this.setWorldDependentMenuItemsEnabled(false, tileMap, primaryStage);
        Toolkit.getDefaultToolkit().getSystemClipboard().addFlavorListener(e -> this.paste.setDisable(!this.hasValidClipboardContent(tileMap) || tileMap.getDisabled()));
        this.setLeft((Node)this.menuBar);
        this.setRight((Node)this.hSlider);
        this.checkForUpdateAsync();
    }

    private void checkForUpdateAsync() {
        new Thread(() -> {
            VersionChecker.VersionData data;
            String applicationVersion;
            try {
                applicationVersion = FileHelper.getManifestAttributes().getValue("Application-Version");
            }
            catch (IOException ex) {
                return;
            }
            VersionChecker checker = new VersionChecker("Querz", "mcaselector");
            try {
                data = checker.fetchLatestVersion();
            }
            catch (Exception e) {
                return;
            }
            if (data != null && data.isNewerThan(applicationVersion)) {
                Platform.runLater(() -> {
                    Hyperlink download = UIFactory.hyperlink("Update", data.getLink(), null);
                    download.getStyleClass().add((Object)"hyperlink-menu-update");
                    Menu updateMenu = new Menu();
                    updateMenu.setGraphic((Node)download);
                    this.menuBar.getMenus().add((Object)updateMenu);
                });
            }
        }).start();
    }

    private void onUpdate(TileMap tileMap) {
        int selectedChunks = tileMap.getSelectedChunks();
        boolean invertedSelection = tileMap.getSelection().isInverted();
        if (this.previousSelectedChunks != selectedChunks || this.previousInvertedSelection != invertedSelection) {
            this.setSelectionDependentMenuItemsEnabled(tileMap, selectedChunks, invertedSelection);
        }
        this.previousSelectedChunks = selectedChunks;
        this.previousInvertedSelection = invertedSelection;
        this.nextOverlay.setDisable(tileMap.getOverlay() == null);
        this.sumSelection.setDisable(tileMap.getOverlay() == null || tileMap.getSelectedChunks() == 0 && !invertedSelection);
    }

    public void setWorldDependentMenuItemsEnabled(boolean enabled, TileMap tileMap, Stage primaryStage) {
        this.renderSettings.setDisable(!enabled);
        this.clearViewCache.setDisable(!enabled);
        this.clearAllCache.setDisable(!enabled);
        this.saveScreenshot.setDisable(!enabled);
        this.filterChunks.setDisable(!enabled);
        this.changeFields.setDisable(!enabled);
        this.importChunks.setDisable(!enabled);
        this.invert.setDisable(!enabled);
        this.invertRegions.setDisable(!enabled || tileMap.getSelectedChunks() == 0);
        this.paste.setDisable(!enabled || !this.hasValidClipboardContent(tileMap));
        this.nextOverlay.setDisable(!enabled);
        this.nextOverlayType.setDisable(!enabled);
        this.sumSelection.setDisable(!enabled || tileMap.getOverlay() == null || tileMap.getSelectedChunks() == 0);
        this.hSlider.setDisable(!enabled);
        this.openDimension.getItems().clear();
        if (enabled && ConfigProvider.WORLD.getDimensionDirectories() != null && ConfigProvider.WORLD.getDimensionDirectories().size() > 1) {
            File currentWorldDir = ConfigProvider.WORLD.getRegionDir().getParentFile();
            ConfigProvider.WORLD.getDimensionDirectories().forEach(f -> {
                if (!f.equals(currentWorldDir)) {
                    MenuItem dimItem = new MenuItem(f.getName());
                    dimItem.setMnemonicParsing(false);
                    dimItem.setOnAction(e -> DialogHelper.setWorld(FileHelper.detectWorldDirectories(f), ConfigProvider.WORLD.getDimensionDirectories(), tileMap, primaryStage));
                    this.openDimension.getItems().add((Object)dimItem);
                }
            });
        }
        this.openDimension.setDisable(!enabled || this.openDimension.getItems().isEmpty());
        if (!ConfigProvider.GLOBAL.getRecentWorlds().isEmpty()) {
            this.openRecent.getItems().clear();
            File currentWorld = ConfigProvider.WORLD.getRegionDir();
            ConfigProvider.GLOBAL.getRecentWorlds().descendingMap().forEach((k, v) -> {
                if (currentWorld == null || !v.recentWorld().equals(currentWorld.getParentFile())) {
                    MenuItem openRecentItem = new MenuItem(v.toString());
                    openRecentItem.setMnemonicParsing(false);
                    openRecentItem.setOnAction(e -> {
                        Optional result;
                        if (tileMap.hasUnsavedSelection() && (result = new ConfirmationDialog((Window)primaryStage, Translation.DIALOG_UNSAVED_SELECTION_TITLE, Translation.DIALOG_UNSAVED_SELECTION_HEADER, "unsaved-changes").showAndWait()).isPresent() && result.get() == ButtonType.CANCEL) {
                            return;
                        }
                        DialogHelper.setWorld(FileHelper.detectWorldDirectories(v.recentWorld()), v.dimensionDirectories(), tileMap, primaryStage);
                    });
                    this.openRecent.getItems().add((Object)openRecentItem);
                }
            });
            this.openRecent.getItems().add((Object)UIFactory.separator());
            MenuItem clear = UIFactory.menuItem(Translation.MENU_FILE_OPEN_RECENT_WORLD_CLEAR);
            clear.setOnAction(e -> {
                this.openRecent.getItems().clear();
                ConfigProvider.GLOBAL.getRecentWorlds().clear();
                this.openRecent.setDisable(true);
            });
            this.openRecent.getItems().add((Object)clear);
        }
        this.openRecent.setDisable(this.openRecent.getItems().size() <= 2);
    }

    public void setEditOverlaysEnabled(boolean enabled) {
        this.editOverlays.setDisable(!enabled);
    }

    private void setSelectionDependentMenuItemsEnabled(TileMap tileMap, int selected, boolean inverted) {
        this.clear.setDisable(selected == 0 && !inverted);
        this.exportChunks.setDisable(selected == 0 && !inverted);
        this.exportSelection.setDisable(selected == 0 && !inverted);
        this.exportImage.setDisable(selected == 0 && !inverted);
        this.delete.setDisable(selected == 0 && !inverted);
        this.clearSelectionCache.setDisable(selected == 0 && !inverted);
        this.editNBT.setDisable(selected != 1 || inverted);
        this.swapChunks.setDisable(selected != 2 || inverted);
        this.copy.setDisable(selected == 0 && !inverted);
        this.invertRegions.setDisable(selected == 0 || inverted);
        this.sumSelection.setDisable(tileMap.getOverlay() == null || selected == 0 && !inverted);
    }

    private boolean hasValidClipboardContent(TileMap tileMap) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable content = clipboard.getContents(tileMap);
            DataFlavor[] flavors = content.getTransferDataFlavors();
            return flavors.length == 1 && flavors[0].equals(ClipboardSelection.SELECTION_DATA_FLAVOR);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setRenderHeight(int height) {
        this.hSlider.valueProperty().set(height);
    }
}

