/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component;

import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import net.querz.mcaselector.io.ImageHelper;
import net.querz.mcaselector.ui.component.RangeSlider;

public class HueRangeSlider
extends RangeSlider {
    private final BooleanProperty invertedProperty = new SimpleBooleanProperty(false);
    private final int width;

    public HueRangeSlider(float minHue, float maxHue, float low, float high, int width) {
        super(minHue, maxHue, minHue, maxHue);
        this.getStylesheets().add((Object)Objects.requireNonNull(HueRangeSlider.class.getClassLoader().getResource("style/component/hue-range-slider.css")).toExternalForm());
        this.width = width;
        if (low > high) {
            this.invertedProperty.set(true);
            low = maxHue - low;
            high = maxHue - high;
        }
        this.setLow(low);
        this.setHigh(high);
        this.getStyleClass().add((Object)"hue-range-slider");
        this.renderBackground();
        this.highProperty().addListener((v, o, n) -> this.renderBackground());
        this.lowProperty().addListener((v, o, n) -> this.renderBackground());
        this.invertedProperty.addListener((v, o, n) -> {
            double l = this.getLow();
            double h = this.getHigh();
            if (n.booleanValue()) {
                this.setHigh(this.getMax() - l);
                this.setLow(this.getMax() - h);
            } else {
                this.setLow(this.getMax() - h);
                this.setHigh(this.getMax() - l);
            }
            this.renderBackground();
        });
    }

    public void setInverted(boolean inverted) {
        this.invertedProperty.set(inverted);
    }

    public boolean isInverted() {
        return this.invertedProperty.get();
    }

    public float getMinHue() {
        if (this.invertedProperty.get()) {
            return (float)this.getMax() - (float)this.getLow();
        }
        return (float)this.getLow();
    }

    public float getMaxHue() {
        if (this.invertedProperty.get()) {
            return (float)this.getMax() - (float)this.getHigh();
        }
        return (float)this.getHigh();
    }

    private void renderBackground() {
        Image bg = ImageHelper.renderGradient(this.width, 0.0f, (float)this.getMax(), (float)this.getLow(), (float)this.getHigh(), this.invertedProperty.get());
        BackgroundImage bgi = new BackgroundImage(bg, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.REPEAT, BackgroundPosition.DEFAULT, BackgroundSize.DEFAULT);
        this.setBackground(new Background(new BackgroundImage[]{bgi}));
    }
}

