/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component;

import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;
import net.querz.mcaselector.ui.component.NumberTextField;

public class HeightSlider
extends HBox {
    private final IntegerProperty valueProperty = new SimpleIntegerProperty();
    private final Slider slider = new Slider(-64.0, 319.0, 319.0);
    private final Label heightMinLabel = new Label("-64");
    private final Label heightMaxLabel = new Label("319");
    private final NumberTextField heightField = new NumberTextField(-64L, 2047L);

    public HeightSlider(int init, boolean showCustomlabels) {
        this.valueProperty.set(init);
        this.heightField.getStyleClass().add((Object)"slider-value-field");
        this.slider.setSnapToTicks(true);
        this.slider.setShowTickLabels(!showCustomlabels);
        this.slider.setShowTickMarks(!showCustomlabels);
        this.slider.setMajorTickUnit(32.0);
        this.slider.setMinorTickCount(384);
        this.slider.setPrefWidth(300.0);
        this.slider.setBlockIncrement(1.0);
        this.slider.setValue((double)init);
        this.heightField.valueProperty().set((long)init);
        if (showCustomlabels) {
            this.slider.setLabelFormatter((StringConverter)new StringConverter<Double>(this){

                public String toString(Double object) {
                    return null;
                }

                public Double fromString(String string) {
                    return null;
                }
            });
        }
        this.slider.setOnScroll(e -> {
            int delta = e.getDeltaY() > 0.0 ? 1 : -1;
            this.slider.setValue(this.slider.getValue() + (double)delta);
        });
        this.slider.valueProperty().addListener((v, o, n) -> {
            if (o.intValue() != n.intValue()) {
                this.heightField.setText("" + n.intValue());
            }
        });
        this.heightField.valueProperty().addListener((v, o, n) -> {
            if (o.intValue() != n.intValue()) {
                this.valueProperty.set(n.intValue());
                if ((double)n.intValue() > this.slider.getMax()) {
                    this.slider.setValue(319.0);
                } else if ((double)n.intValue() < this.slider.getMin()) {
                    this.slider.setValue(-64.0);
                } else {
                    this.slider.setValue((double)n.intValue());
                }
            }
        });
        this.valueProperty.addListener((v, o, n) -> this.heightField.setText("" + n.intValue()));
        if (showCustomlabels) {
            this.getChildren().addAll((Object[])new Node[]{this.heightMinLabel, this.slider, this.heightMaxLabel, this.heightField});
        } else {
            this.getChildren().addAll((Object[])new Node[]{this.slider, this.heightField});
        }
    }

    public IntegerProperty valueProperty() {
        return this.valueProperty;
    }

    public int getValue() {
        return this.valueProperty.get();
    }

    public void disable(boolean disable) {
        this.slider.setDisable(disable);
        this.heightMinLabel.setDisable(disable);
        this.heightMaxLabel.setDisable(disable);
        this.heightField.setDisable(disable);
    }

    public void setMajorTickUnit(int unit) {
        this.slider.setMajorTickUnit((double)unit);
    }
}

