/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component;

import java.io.File;
import java.util.Objects;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.ui.DialogHelper;
import net.querz.mcaselector.util.property.DataProperty;

public class FileTextField
extends HBox {
    private static final Image openIcon = FileHelper.getIconFromResources("img/folder");
    private final TextField textField = new TextField();
    private final Button openButton = new Button(null, (Node)new ImageView(openIcon));

    public FileTextField() {
        this.getStyleClass().add((Object)"file-text-field");
        this.getStylesheets().add((Object)Objects.requireNonNull(FileTextField.class.getClassLoader().getResource("style/component/file-text-field.css")).toExternalForm());
        HBox.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
        this.openButton.setOnAction(e -> {
            File file;
            File fieldFile;
            Object lastOpenDirectory = null;
            if (this.textField.getText() != null && !this.textField.getText().isEmpty() && (fieldFile = new File(this.textField.getText())).exists() && fieldFile.isDirectory()) {
                lastOpenDirectory = String.valueOf(fieldFile);
            }
            if (lastOpenDirectory == null || ((String)lastOpenDirectory).isEmpty()) {
                lastOpenDirectory = FileHelper.getLastOpenedDirectory("open_world", ConfigProvider.GLOBAL.getMcSavesDir());
            }
            if ((file = DialogHelper.createDirectoryChooser((String)lastOpenDirectory).showDialog(this.getScene().getWindow())) != null) {
                this.textField.setText(String.valueOf(file));
            }
        });
        DataProperty<Integer> location = new DataProperty<Integer>(0);
        this.textField.textProperty().addListener((observable, oldValue, newValue) -> location.set(this.textField.getText().length()));
        this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.textField.positionCaret(((Integer)location.get()).intValue())));
        this.getChildren().addAll((Object[])new Node[]{this.textField, this.openButton});
    }

    public void setFile(File initFile) {
        if (initFile != null) {
            this.textField.setText(String.valueOf(initFile));
        }
    }

    public File getFile() {
        String text = this.textField.getText();
        if (text == null || text.isEmpty()) {
            return null;
        }
        return new File(text);
    }
}

