/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import net.querz.mcaselector.config.Config;
import net.querz.mcaselector.config.GlobalConfig;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.ui.DialogHelper;
import net.querz.mcaselector.ui.UIFactory;
import net.querz.mcaselector.ui.component.GroovyCodeArea;
import net.querz.mcaselector.ui.dialog.ConfirmationDialog;
import net.querz.mcaselector.ui.dialog.ErrorDialog;
import net.querz.mcaselector.util.property.DataProperty;
import org.fxmisc.flowless.VirtualizedScrollPane;

public class CodeEditor
extends StackPane {
    private static final String newFileName = "script.groovy";
    private final GroovyCodeArea codeArea = new GroovyCodeArea(true);
    private final Menu recentFilesMenu;
    private final DataProperty<Boolean> initTextEval = new DataProperty<Boolean>(true);
    private boolean saved = true;
    private Consumer<File> onSave;
    private File sourceFile;
    private Window owner;
    private Config.RecentFiles recentFiles;
    Label fileNameLabel = new Label("* script.groovy");

    public CodeEditor(String initText) {
        this.codeArea.setChangeListener(() -> {
            if (!this.initTextEval.get().booleanValue()) {
                this.saved = false;
                this.updateFileNameLabel();
            } else {
                this.initTextEval.set(false);
            }
        });
        this.codeArea.setText(initText);
        this.getStylesheets().add((Object)Objects.requireNonNull(CodeEditor.class.getClassLoader().getResource("style/component/code-editor.css")).toExternalForm());
        this.getStyleClass().add((Object)"code-editor-script-box");
        StackPane scriptPane = new StackPane(new Node[]{new VirtualizedScrollPane<GroovyCodeArea>(this.codeArea)});
        scriptPane.getStyleClass().add((Object)"script-pane");
        Label errorLabel = new Label();
        errorLabel.getStyleClass().add((Object)"script-error-label");
        errorLabel.textProperty().bind(this.codeArea.errorProperty());
        VBox.setVgrow((Node)scriptPane, (Priority)Priority.ALWAYS);
        MenuBar menuBar = new MenuBar();
        Menu fileMenu = UIFactory.menu(Translation.MENU_FILE);
        MenuItem newMenu = UIFactory.menuItem(Translation.MENU_FILE_NEW);
        newMenu.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        newMenu.setOnAction(e -> this.unsavedChangesConfirmation(() -> {
            this.sourceFile = null;
            this.initTextEval.set(true);
            this.codeArea.setText(initText);
            this.updateFileNameLabel();
            if (this.recentFiles != null) {
                this.recentFiles.addRecentFile(this.sourceFile);
                this.setRecentFiles(this.recentFiles);
            }
        }));
        MenuItem openMenu = UIFactory.menuItem(Translation.MENU_FILE_OPEN);
        openMenu.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        openMenu.setOnAction(e -> this.unsavedChangesConfirmation(() -> this.openFile(null)));
        MenuItem saveAsMenu = UIFactory.menuItem(Translation.MENU_FILE_SAVE_AS);
        saveAsMenu.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN, KeyCodeCombination.SHIFT_DOWN}));
        saveAsMenu.setOnAction(e -> this.save(true));
        MenuItem saveMenu = UIFactory.menuItem(Translation.MENU_FILE_SAVE);
        saveMenu.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        saveMenu.setOnAction(e -> this.save(false));
        this.recentFilesMenu = UIFactory.menu(Translation.MENU_FILE_OPEN_RECENT);
        menuBar.getMenus().addAll((Object[])new Menu[]{fileMenu});
        fileMenu.getItems().addAll((Object[])new MenuItem[]{newMenu, UIFactory.separator(), openMenu, this.recentFilesMenu, UIFactory.separator(), saveMenu, saveAsMenu});
        this.fileNameLabel.getStyleClass().add((Object)"file-name-label");
        BorderPane menuPane = new BorderPane();
        menuPane.setLeft((Node)menuBar);
        menuPane.setRight((Node)this.fileNameLabel);
        VBox box = new VBox();
        box.getChildren().addAll((Object[])new Node[]{menuPane, scriptPane, errorLabel});
        this.getChildren().add((Object)box);
    }

    private void openFile(File file) {
        if (file == null) {
            file = DialogHelper.createFileChooser(FileHelper.getLastOpenedDirectory("code_editor", null), new FileChooser.ExtensionFilter("*.groovy Files", new String[]{"*.groovy"})).showOpenDialog(this.owner);
        }
        if (file != null) {
            try {
                String s = Files.readString(file.toPath());
                this.initTextEval.set(true);
                this.codeArea.setText(s);
                FileHelper.setLastOpenedDirectory("code_editor", file.getParent());
                this.sourceFile = file;
                this.saved = true;
                this.updateFileNameLabel();
                if (this.recentFiles != null) {
                    this.recentFiles.addRecentFile(file);
                    this.setRecentFiles(this.recentFiles);
                }
            }
            catch (IOException ex) {
                new ErrorDialog(this.owner, ex);
            }
        }
    }

    private void unsavedChangesConfirmation(Runnable action) {
        if (!this.saved) {
            Optional result = new ConfirmationDialog(this.owner, Translation.DIALOG_UNSAVED_SCRIPT_TITLE, Translation.DIALOG_UNSAVED_SCRIPT_HEADER, "unsaved-changes").showAndWait();
            result.ifPresent(r -> {
                if (r == ButtonType.OK) {
                    action.run();
                }
            });
        } else {
            action.run();
        }
    }

    private boolean save(File file) {
        try {
            Files.writeString(file.toPath(), (CharSequence)this.codeArea.getText(), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            FileHelper.setLastOpenedDirectory("code_editor", file.getParent());
            this.sourceFile = file;
            this.saved = true;
            this.updateFileNameLabel();
            if (this.recentFiles != null) {
                this.recentFiles.addRecentFile(file);
                this.setRecentFiles(this.recentFiles);
            }
            if (this.onSave != null) {
                this.onSave.accept(file);
            }
            return true;
        }
        catch (IOException ex) {
            new ErrorDialog(this.owner, ex);
            return false;
        }
    }

    public boolean save(boolean newSave) {
        if (newSave || this.sourceFile == null) {
            File file = DialogHelper.createFileChooser(FileHelper.getLastOpenedDirectory("code_editor", null), new FileChooser.ExtensionFilter("*.groovy Files", new String[]{"*.groovy"})).showSaveDialog(this.owner);
            if (file != null) {
                return this.save(file);
            }
            return false;
        }
        return this.save(this.sourceFile);
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setOnSave(Consumer<File> onSave) {
        this.onSave = onSave;
    }

    private void updateFileNameLabel() {
        if (this.saved) {
            this.fileNameLabel.setText(this.sourceFile == null ? "* script.groovy" : this.sourceFile.getName());
        } else if (this.sourceFile == null) {
            this.fileNameLabel.setText("* script.groovy");
        } else {
            this.fileNameLabel.setText("* " + this.sourceFile.getName());
        }
    }

    public void setOwner(Window owner) {
        if (this.owner == null) {
            ObservableList t = this.getStylesheets();
            owner.getScene().getStylesheets().forEach(arg_0 -> this.lambda$setOwner$8((List)t, arg_0));
        }
        this.owner = owner;
    }

    public void setRecentFiles(Config.RecentFiles recentFiles) {
        this.recentFiles = recentFiles;
        if (!recentFiles.isEmpty()) {
            this.recentFilesMenu.getItems().clear();
            recentFiles.descendingMap().forEach((k, v) -> {
                if (!v.equals(this.sourceFile)) {
                    MenuItem openRecentItem = new MenuItem(v.toString());
                    openRecentItem.setMnemonicParsing(false);
                    openRecentItem.setOnAction(e -> this.unsavedChangesConfirmation(() -> this.openFile((File)v)));
                    this.recentFilesMenu.getItems().add((Object)openRecentItem);
                }
            });
            this.recentFilesMenu.getItems().add((Object)UIFactory.separator());
            MenuItem clear = UIFactory.menuItem(Translation.MENU_FILE_OPEN_RECENT_CLEAR);
            clear.setOnAction(e -> {
                this.recentFilesMenu.getItems().clear();
                recentFiles.clear();
                this.recentFilesMenu.setDisable(true);
            });
            this.recentFilesMenu.getItems().add((Object)clear);
        }
        this.recentFilesMenu.setDisable(this.recentFilesMenu.getItems().size() <= 2);
    }

    public void setSource(GlobalConfig.TempScript tempScript) {
        if (tempScript.text() == null || tempScript.text().isEmpty()) {
            return;
        }
        boolean exists = tempScript.file() == null || tempScript.file().exists();
        this.sourceFile = exists ? tempScript.file() : null;
        this.codeArea.setText(tempScript.text());
        this.saved = exists && tempScript.saved();
        this.updateFileNameLabel();
    }

    public GlobalConfig.TempScript getSource() {
        return new GlobalConfig.TempScript(this.sourceFile, this.saved, this.getText());
    }

    public String getText() {
        return this.codeArea.getText();
    }

    private /* synthetic */ void lambda$setOwner$8(List t, String s) {
        this.getStylesheets().add(t.size() - 1, (Object)s);
    }
}

