/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.tile;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.input.ZoomEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.ImageHelper;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.io.WorldDirectories;
import net.querz.mcaselector.io.job.ParseDataJob;
import net.querz.mcaselector.io.job.RegionImageGenerator;
import net.querz.mcaselector.overlay.Overlay;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.selection.SelectionData;
import net.querz.mcaselector.tile.ImagePool;
import net.querz.mcaselector.tile.KeyActivator;
import net.querz.mcaselector.tile.OverlayPool;
import net.querz.mcaselector.tile.Tile;
import net.querz.mcaselector.tile.TileImage;
import net.querz.mcaselector.ui.DialogHelper;
import net.querz.mcaselector.ui.ProgressTask;
import net.querz.mcaselector.ui.Window;
import net.querz.mcaselector.util.point.Point2f;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.progress.Timer;
import net.querz.mcaselector.util.property.DataProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TileMap
extends Canvas
implements ClipboardOwner {
    private static final Logger LOGGER = LogManager.getLogger(TileMap.class);
    private float scale = 1.0f;
    public static final float CHUNK_GRID_SCALE = 1.5f;
    public static final int TILE_VISIBILITY_THRESHOLD = 2;
    private final Window window;
    private final GraphicsContext context;
    private Point2f offset = new Point2f();
    private Point2f previousMouseLocation = null;
    private Point2f firstMouseLocation = null;
    private final Long2ObjectOpenHashMap<Tile> tiles = new Long2ObjectOpenHashMap();
    private Long2IntOpenHashMap tilePriorities = new Long2IntOpenHashMap();
    private int selectedChunks = 0;
    private Point2i hoveredBlock = null;
    private boolean showChunkGrid = true;
    private boolean showRegionGrid = true;
    private boolean showCoordinates = false;
    private boolean showNonexistentRegions;
    private final List<Consumer<TileMap>> updateListener = new ArrayList<Consumer<TileMap>>(1);
    private final List<Consumer<TileMap>> hoverListener = new ArrayList<Consumer<TileMap>>(1);
    private final KeyActivator keyActivator = new KeyActivator();
    private long totalDraws = 0L;
    private boolean disabled = true;
    private boolean trackpadScrolling = false;
    private final ImagePool imgPool;
    private final OverlayPool overlayPool;
    private List<Overlay> overlays = Collections.singletonList(null);
    private final ObjectProperty<Overlay> overlayParser = new SimpleObjectProperty(null);
    private Selection pastedChunks;
    private WorldDirectories pastedWorld;
    private Map<Point2i, Image> pastedChunksCache;
    private Point2i pastedChunksOffset;
    private Point2i firstPastedChunksOffset;
    private Selection selection = new Selection();
    private ScheduledExecutorService updateService;
    private ScheduledExecutorService drawService;
    private final AtomicBoolean drawRequested = new AtomicBoolean(false);
    private boolean unsavedSelection = false;

    public TileMap(Window window, int width, int height) {
        super((double)width, (double)height);
        this.window = window;
        this.context = this.getGraphicsContext2D();
        this.context.setImageSmoothing(ConfigProvider.WORLD.getSmoothRendering());
        this.context.setFont(Font.font((String)"Monospaced", (FontWeight)FontWeight.BOLD, null, (double)16.0));
        this.setFocusTraversable(true);
        this.setOnMousePressed(this::onMousePressed);
        this.setOnMouseReleased(e -> this.onMouseReleased());
        this.setOnMouseDragged(this::onMouseDragged);
        this.setOnMouseMoved(this::onMouseMoved);
        this.setOnMouseExited(e -> this.onMouseExited());
        this.setOnZoom(this::onZoom);
        this.setOnScroll(this::onScroll);
        this.setOnScrollStarted(e -> this.onScrollStarted());
        this.setOnScrollFinished(e -> this.onScrollFinished());
        this.setOnDragOver(this::onDragOver);
        this.setOnDragDropped(this::onDragDropped);
        this.keyActivator.registerAction(KeyCode.W, c -> {
            this.offset = this.offset.sub(0.0f, (float)(c.contains(KeyCode.SHIFT) ? 10 : 5) * this.scale);
        });
        this.keyActivator.registerAction(KeyCode.A, c -> {
            this.offset = this.offset.sub((float)(c.contains(KeyCode.SHIFT) ? 10 : 5) * this.scale, 0.0f);
        });
        this.keyActivator.registerAction(KeyCode.S, c -> {
            this.offset = this.offset.add(0.0f, (float)(c.contains(KeyCode.SHIFT) ? 10 : 5) * this.scale);
        });
        this.keyActivator.registerAction(KeyCode.D, c -> {
            this.offset = this.offset.add((float)(c.contains(KeyCode.SHIFT) ? 10 : 5) * this.scale, 0.0f);
        });
        this.keyActivator.registerAction(KeyCode.UP, c -> {
            this.offset = this.offset.sub(0.0f, (float)(c.contains(KeyCode.SHIFT) ? 10 : 5) * this.scale);
        });
        this.keyActivator.registerAction(KeyCode.LEFT, c -> {
            this.offset = this.offset.sub((float)(c.contains(KeyCode.SHIFT) ? 10 : 5) * this.scale, 0.0f);
        });
        this.keyActivator.registerAction(KeyCode.DOWN, c -> {
            this.offset = this.offset.add(0.0f, (float)(c.contains(KeyCode.SHIFT) ? 10 : 5) * this.scale);
        });
        this.keyActivator.registerAction(KeyCode.RIGHT, c -> {
            this.offset = this.offset.add((float)(c.contains(KeyCode.SHIFT) ? 10 : 5) * this.scale, 0.0f);
        });
        this.keyActivator.registerGlobalAction(this::draw);
        this.setOnKeyPressed(this::onKeyPressed);
        this.setOnKeyReleased(this::onKeyReleased);
        this.setOnKeyTyped(this::onKeyTyped);
        this.offset = new Point2f(-((double)width) / 2.0, -((double)height) / 2.0);
        this.overlayPool = new OverlayPool(this);
        this.imgPool = new ImagePool(this, 2.5);
        this.setOverlays(ConfigProvider.OVERLAY.getOverlays());
        this.showNonexistentRegions = ConfigProvider.WORLD.getShowNonexistentRegions();
        RegionImageGenerator.setCacheEligibilityChecker(region -> {
            DataProperty<Boolean> eligible = new DataProperty<Boolean>(false);
            this.runOnVisibleRegions(r -> {
                if (region.equals(r)) {
                    eligible.set(true);
                }
            }, new Point2f(), () -> Float.valueOf(this.scale), ConfigProvider.GLOBAL.getMaxLoadedFiles());
            return eligible.get();
        });
        this.initUpdateService();
        this.initDrawService();
        this.draw();
    }

    private void initUpdateService() {
        this.updateService = Executors.newSingleThreadScheduledExecutor();
        this.updateService.scheduleAtFixedRate(() -> {
            try {
                if (ConfigProvider.WORLD.getRegionDir() == null) {
                    return;
                }
                this.tiles.values().removeIf(v -> {
                    boolean visible = v.isVisible(this, 2);
                    if (!visible) {
                        v.unload(true, true);
                    }
                    return !visible && v.getImage() == null;
                });
                JobHandler.validateJobs(j -> {
                    ParseDataJob job;
                    if (j instanceof RegionImageGenerator.MCAImageProcessJob) {
                        RegionImageGenerator.MCAImageProcessJob job2 = (RegionImageGenerator.MCAImageProcessJob)j;
                        if (!job2.getTile().isVisible(this)) {
                            LOGGER.debug("removing {} for tile {} from queue", (Object)job2.getClass().getSimpleName(), (Object)job2.getTile().getLocation());
                            RegionImageGenerator.setLoading(job2.getTile(), false);
                            return true;
                        }
                    } else if (j instanceof ParseDataJob && !(job = (ParseDataJob)j).getTile().isVisible(this)) {
                        ParseDataJob.setLoading(job.getTile(), false);
                        LOGGER.debug("removing {} for tile {} from queue", (Object)job.getClass().getSimpleName(), (Object)job.getTile().getLocation());
                        return true;
                    }
                    return false;
                });
                if (this.pastedChunksCache != null) {
                    this.pastedChunksCache.keySet().removeIf(img -> {
                        Point2i o = this.offset.toPoint2i();
                        Point2i min = o.sub(1024).blockToRegion().regionToBlock();
                        Point2i max = new Point2i((int)((double)o.getX() + this.getWidth() * (double)this.scale), (int)((double)o.getZ() + this.getHeight() * (double)this.scale)).add(1024).blockToRegion().regionToBlock();
                        Point2i location = img.regionToBlock().add(this.pastedChunksOffset.chunkToBlock());
                        return location.getX() < min.getX() || location.getZ() < min.getZ() || location.getX() > max.getX() || location.getZ() > max.getZ();
                    });
                }
                int zoomLevel = this.getZoomLevel();
                Long2IntOpenHashMap newTilePriorities = new Long2IntOpenHashMap(this.tilePriorities.size());
                DataProperty<Integer> priority = new DataProperty<Integer>(1);
                this.runOnVisibleRegions(region -> {
                    Tile tile = this.tiles.get(region.asLong());
                    if (tile == null) {
                        tile = new Tile((Point2i)region);
                        this.tiles.put(region.asLong(), tile);
                    }
                    newTilePriorities.put(region.asLong(), (int)((Integer)priority.get()));
                    priority.set((Integer)priority.get() + 1);
                    if (tile.image != null) {
                        if (tile.loaded) {
                            if (tile.getImageZoomLevel() != zoomLevel) {
                                if (tile.getImageZoomLevel() < zoomLevel) {
                                    tile.setImage(ImageHelper.scaleDownFXImage(tile.image, 512 / zoomLevel));
                                } else {
                                    this.imgPool.requestImage(tile, zoomLevel);
                                }
                            }
                        } else {
                            this.imgPool.requestImage(tile, zoomLevel);
                        }
                    } else {
                        this.imgPool.requestImage(tile, zoomLevel);
                    }
                    if (this.overlayParser.get() != null && !tile.isOverlayLoaded()) {
                        this.overlayPool.requestImage(tile, (Overlay)this.overlayParser.get());
                    }
                }, new Point2f(), () -> Float.valueOf(this.scale), Integer.MAX_VALUE);
                this.tilePriorities = newTilePriorities;
                Platform.runLater(this::runUpdateListeners);
            }
            catch (Exception ex) {
                LOGGER.warn("failed to update", (Throwable)ex);
            }
        }, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    private void initDrawService() {
        this.drawService = Executors.newSingleThreadScheduledExecutor();
        this.drawService.scheduleAtFixedRate(() -> {
            if (!this.drawRequested.get()) {
                return;
            }
            Platform.runLater(() -> {
                Timer t = new Timer();
                this.draw(this.context);
                LOGGER.trace("draw #{}: {}", (Object)this.totalDraws++, (Object)t);
            });
            this.drawRequested.set(false);
        }, 16L, 16L, TimeUnit.MILLISECONDS);
    }

    public void reload() {
        this.runOnVisibleRegions(region -> {
            this.imgPool.discardCachedImage((Point2i)region);
            Tile tile = this.tiles.get(region.asLong());
            if (tile != null) {
                tile.loaded = false;
            }
        }, new Point2f(), () -> Float.valueOf(this.scale), Integer.MAX_VALUE);
    }

    public int getTilePriority(Point2i region) {
        return this.tilePriorities.getOrDefault(region.asLong(), 9999999);
    }

    private void updateScale(float oldScale, Point2f center) {
        float f = this.scale = this.scale < 15.9999f ? Math.max(this.scale, 0.05f) : 15.9999f;
        if (oldScale != this.scale) {
            Point2f diff = this.offset.add(center.getX() * oldScale, center.getY() * oldScale).sub(this.offset.add(center.getX() * this.scale, center.getY() * this.scale));
            this.offset = this.offset.add(diff);
            if (Tile.getZoomLevel(oldScale) != Tile.getZoomLevel(this.scale)) {
                LOGGER.debug("zoom level changed from {} to {}", (Object)Tile.getZoomLevel(oldScale), (Object)Tile.getZoomLevel(this.scale));
                this.unloadTiles(false, false);
                JobHandler.clearQueues();
                if (this.pastedChunksCache != null) {
                    this.pastedChunksCache.clear();
                }
            }
            this.draw();
        }
    }

    public void nextOverlay() {
        Overlay parser;
        if (this.disabled || this.overlayParser.get() == null) {
            return;
        }
        int index = this.overlays.indexOf(this.overlayParser.get());
        do {
            if (++index != this.overlays.size()) continue;
            index = 0;
        } while ((parser = this.overlays.get(index)) == null || !parser.isActive() || !parser.isValid() || parser.getType() != ((Overlay)this.overlayParser.get()).getType());
        this.setOverlay(parser);
        JobHandler.cancelParserQueue();
        this.draw();
    }

    public void nextOverlayType() {
        Overlay parser;
        if (this.disabled) {
            return;
        }
        int index = this.overlays.indexOf(this.overlayParser.get());
        do {
            if (++index != this.overlays.size()) continue;
            index = 0;
        } while ((parser = this.overlays.get(index)) != null && (!parser.isActive() || !parser.isValid() || this.overlayParser.get() != null && parser.getType() == ((Overlay)this.overlayParser.get()).getType()));
        this.setOverlay(parser);
        JobHandler.cancelParserQueue();
        this.draw();
    }

    public void setOverlays(List<Overlay> overlays) {
        if (overlays == null) {
            this.overlays = Collections.singletonList(null);
            this.setOverlay(null);
            JobHandler.cancelParserQueue();
            return;
        }
        this.overlays = new ArrayList<Overlay>(overlays.size() + 1);
        this.overlays.addAll(overlays);
        this.overlays.sort(Comparator.comparing(Overlay::getType));
        this.overlays.add(null);
        this.setOverlay(null);
        JobHandler.cancelParserQueue();
    }

    public void setOverlay(Overlay overlay) {
        if (this.disabled) {
            return;
        }
        this.overlayParser.set((Object)overlay);
        this.overlayPool.setParser(overlay);
        this.clearOverlay();
    }

    public void clearOverlay() {
        for (Tile tile : this.tiles.values()) {
            tile.overlay = null;
            tile.overlayLoaded = false;
        }
    }

    public Overlay getOverlay() {
        return (Overlay)this.overlayParser.get();
    }

    public ObjectProperty<Overlay> overlayParserProperty() {
        return this.overlayParser;
    }

    public List<Overlay> getOverlays() {
        ArrayList<Overlay> overlays = new ArrayList<Overlay>(this.overlays.size() - 1);
        for (Overlay parser : this.overlays) {
            if (parser == null) continue;
            overlays.add(parser.clone());
        }
        return overlays;
    }

    public void setScale(float newScale) {
        this.scale = newScale;
        this.draw();
    }

    public static Point2f getRegionGridMin(Point2f offset, float scale) {
        Point2i min = offset.toPoint2i().blockToRegion();
        Point2f regionOffset = min.regionToBlock().toPoint2f().sub(offset.getX(), offset.getY());
        return new Point2f(regionOffset.getX() / scale, regionOffset.getY() / scale);
    }

    public static Point2f getChunkGridMin(Point2f offset, float scale) {
        Point2i min = offset.toPoint2i().blockToChunk();
        Point2f chunkOffset = min.chunkToBlock().toPoint2f().sub(offset.getX(), offset.getY());
        return new Point2f(chunkOffset.getX() / scale, chunkOffset.getY() / scale);
    }

    private void onKeyPressed(KeyEvent event) {
        if (event.getCode() == KeyCode.SHIFT) {
            this.keyActivator.pressActionKey(event.getCode());
        } else {
            this.keyActivator.pressKey(event.getCode());
        }
        if (event.getCode() == KeyCode.ESCAPE) {
            LOGGER.debug("cancelling chunk pasting");
            this.pastedChunks = null;
            this.pastedWorld = null;
            this.pastedChunksCache = null;
            this.pastedChunksOffset = null;
            this.draw();
        }
        if (KeyActivator.isArrowKey(event.getCode())) {
            event.consume();
        }
    }

    private void onKeyTyped(KeyEvent event) {
        if ("+".equals(event.getCharacter())) {
            this.zoomFactor(1.05, new Point2f(this.getWidth() / 2.0, this.getHeight() / 2.0));
        } else if ("-".equals(event.getCharacter())) {
            this.zoomFactor(0.95, new Point2f(this.getWidth() / 2.0, this.getHeight() / 2.0));
        }
    }

    private void zoomFactor(double factor, Point2f center) {
        float oldScale = this.scale;
        this.scale /= (float)factor;
        this.updateScale(oldScale, center);
    }

    private void onKeyReleased(KeyEvent event) {
        if (event.getCode() == KeyCode.SHIFT) {
            this.keyActivator.releaseActionKey(event.getCode());
        } else {
            switch (event.getCode()) {
                case UP: 
                case DOWN: 
                case LEFT: 
                case RIGHT: {
                    event.consume();
                }
            }
            this.keyActivator.releaseKey(event.getCode());
        }
    }

    public void releaseAllKeys() {
        this.keyActivator.releaseAllKeys();
    }

    private void onMouseMoved(MouseEvent event) {
        this.hoveredBlock = this.getMouseBlock(event.getX(), event.getY());
        this.runHoverListeners();
    }

    private void onMouseExited() {
        this.hoveredBlock = null;
        this.runHoverListeners();
    }

    private void onScroll(ScrollEvent event) {
        if (this.trackpadScrolling || event.isInertia()) {
            if (this.window.isKeyPressed(KeyCode.COMMAND)) {
                if (event.getDeltaY() > 0.0) {
                    this.zoomFactor(1.03 + event.getDeltaY() / 1000.0, new Point2f(event.getX(), event.getY()));
                } else if (event.getDeltaY() < 0.0) {
                    this.zoomFactor(0.97 + event.getDeltaY() / 1000.0, new Point2f(event.getX(), event.getY()));
                }
            } else {
                this.offset = this.offset.sub(new Point2f(event.getDeltaX(), event.getDeltaY()).mul(this.scale));
                this.draw();
            }
        } else if (event.getDeltaY() > 0.0) {
            this.zoomFactor(1.03 + event.getDeltaY() / 1000.0, new Point2f(event.getX(), event.getY()));
        } else if (event.getDeltaY() < 0.0) {
            this.zoomFactor(0.97 + event.getDeltaY() / 1000.0, new Point2f(event.getX(), event.getY()));
        }
    }

    private void onScrollStarted() {
        this.trackpadScrolling = true;
    }

    private void onScrollFinished() {
        this.trackpadScrolling = false;
    }

    private void onZoom(ZoomEvent event) {
        this.zoomFactor(event.getZoomFactor(), new Point2f(event.getX(), event.getY()));
    }

    private void onMousePressed(MouseEvent event) {
        this.requestFocus();
        if (!this.disabled) {
            this.firstMouseLocation = new Point2f(event.getX(), event.getY());
            this.firstPastedChunksOffset = this.pastedChunksOffset;
            if (event.getButton() == MouseButton.PRIMARY && !this.window.isKeyPressed(KeyCode.COMMAND) && this.pastedChunks == null) {
                this.mark(event.getX(), event.getY(), true);
            } else if (event.getButton() == MouseButton.SECONDARY) {
                this.mark(event.getX(), event.getY(), false);
            }
            this.draw();
        }
    }

    private void onMouseReleased() {
        this.previousMouseLocation = null;
        this.firstPastedChunksOffset = null;
    }

    private void onMouseDragged(MouseEvent event) {
        Point2f mouseLocation = new Point2f(event.getX(), event.getY());
        if (event.getButton() == MouseButton.MIDDLE || event.getButton() == MouseButton.PRIMARY && this.window.isKeyPressed(KeyCode.COMMAND)) {
            if (this.previousMouseLocation != null) {
                Point2f diff = mouseLocation.sub(this.previousMouseLocation);
                diff = diff.mul(-1.0f);
                this.offset = this.offset.add(diff.mul(this.scale));
            }
            this.previousMouseLocation = mouseLocation;
        } else if (!this.disabled && event.getButton() == MouseButton.PRIMARY) {
            if (this.pastedChunks != null) {
                Point2f diff = mouseLocation.sub(this.firstMouseLocation).mul(this.scale);
                this.pastedChunksOffset = this.firstPastedChunksOffset.add(diff.toPoint2i().div(16));
            } else {
                this.mark(event.getX(), event.getY(), true);
            }
        } else if (!this.disabled && event.getButton() == MouseButton.SECONDARY) {
            this.mark(event.getX(), event.getY(), false);
        }
        this.hoveredBlock = this.getMouseBlock(event.getX(), event.getY());
        this.runUpdateListeners();
        this.draw();
    }

    private void onDragOver(DragEvent event) {
        if (event.getGestureSource() != this && event.getDragboard().hasFiles() && FileHelper.testWorldDirectoriesValid(event.getDragboard().getFiles(), null) != null) {
            event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            event.consume();
        }
    }

    private void onDragDropped(DragEvent event) {
        Dragboard db = event.getDragboard();
        if (db.hasFiles()) {
            WorldDirectories wd = FileHelper.testWorldDirectoriesValid(db.getFiles(), this.getWindow().getPrimaryStage());
            if (wd != null) {
                DialogHelper.setWorld(wd, List.of(wd.getRegion().getParentFile()), this, this.window.getPrimaryStage());
            }
            event.setDropCompleted(true);
        }
        event.consume();
    }

    public void redrawOverlays() {
        for (Tile tile : this.tiles.values()) {
            if (tile.markedChunksImage == null) continue;
            TileImage.createMarkedChunksImage(tile, this.selection.getSelectedChunks(tile.getLocation()));
        }
        if (this.pastedChunksCache != null) {
            this.pastedChunksCache.clear();
        }
    }

    public void draw() {
        this.drawRequested.set(true);
    }

    public void disable(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setOnUpdate(Consumer<TileMap> listener) {
        this.updateListener.add(listener);
    }

    public void setOnHover(Consumer<TileMap> listener) {
        this.hoverListener.add(listener);
    }

    private void runUpdateListeners() {
        this.updateListener.forEach(c -> c.accept(this));
    }

    private void runHoverListeners() {
        this.hoverListener.forEach(c -> c.accept(this));
    }

    public Point2f getOffset() {
        return this.offset;
    }

    public float getScale() {
        return this.scale;
    }

    public int getZoomLevel() {
        return Tile.getZoomLevel(this.scale);
    }

    public void setShowRegionGrid(boolean showRegionGrid) {
        this.showRegionGrid = showRegionGrid;
        this.draw();
    }

    public void setShowChunkGrid(boolean showChunkGrid) {
        this.showChunkGrid = showChunkGrid;
        this.draw();
    }

    public void setShowCoordinates(boolean showCoordinates) {
        this.showCoordinates = showCoordinates;
        this.draw();
    }

    public void setShowNonexistentRegions(boolean showNonexistentRegions) {
        this.showNonexistentRegions = showNonexistentRegions;
        this.draw();
    }

    public void goTo(int x, int z) {
        this.offset = new Point2f((double)x - this.getWidth() * (double)this.scale / 2.0, (double)z - this.getHeight() * (double)this.scale / 2.0);
        this.draw();
    }

    public int getSelectedChunks() {
        return this.selectedChunks;
    }

    public Point2i getHoveredBlock() {
        return this.hoveredBlock;
    }

    public ObjectOpenHashSet<Point2i> getVisibleRegions() {
        return this.getVisibleRegions(this.scale);
    }

    public ObjectOpenHashSet<Point2i> getVisibleRegions(float scale) {
        ObjectOpenHashSet<Point2i> regions = new ObjectOpenHashSet<Point2i>();
        this.runOnVisibleRegions(regions::add, new Point2f(), () -> Float.valueOf(scale), Integer.MAX_VALUE);
        return regions;
    }

    public int getVisibleTiles() {
        return 0;
    }

    public int getLoadedTiles() {
        return this.tiles.size();
    }

    public void clear() {
        this.clear(null, true);
    }

    public void clear(ProgressTask loadWorldTask, boolean initCache) {
        this.tiles.clear();
        this.imgPool.clear(loadWorldTask);
        this.overlayPool.clear(initCache);
        this.pastedChunks = null;
        this.pastedWorld = null;
        this.pastedChunksCache = null;
        this.pastedChunksOffset = null;
    }

    public void markAllTilesAsObsolete() {
        for (Tile tile : this.tiles.values()) {
            tile.setLoaded(false);
        }
        this.imgPool.clear(null);
    }

    public void clearTile(long p) {
        Tile tile = this.tiles.remove(p);
        if (tile != null) {
            tile.unload(true, true);
        }
        this.imgPool.discardImage(new Point2i(p));
        this.overlayPool.discardData(new Point2i(p));
    }

    public OverlayPool getOverlayPool() {
        return this.overlayPool;
    }

    public void clearSelection() {
        this.selection = new Selection();
        this.selectedChunks = 0;
        this.unsavedSelection = false;
        for (Tile tile : this.tiles.values()) {
            tile.clearMarkedChunksImage();
        }
        this.draw();
    }

    public void invertSelection() {
        this.selection.setInverted(!this.selection.isInverted());
        this.redrawOverlays();
        this.draw();
    }

    public void invertRegionsWithSelection() {
        this.selection.invertAll();
        this.selectedChunks = this.selection.count();
        this.unsavedSelection = true;
        this.runUpdateListeners();
        this.redrawOverlays();
        this.draw();
    }

    public void unloadTiles(boolean overlay, boolean img) {
        for (Tile tile : this.tiles.values()) {
            tile.unload(overlay, img);
        }
    }

    public void setSmoothRendering(boolean smoothRendering) {
        this.context.setImageSmoothing(smoothRendering);
    }

    public Selection getSelection() {
        return this.selection;
    }

    public void addSelection(Selection selection) {
        int selectedBefore = this.selectedChunks;
        this.selection.merge(selection);
        this.selectedChunks = this.selection.count();
        for (Long2ObjectMap.Entry<ChunkSet> e : selection) {
            Tile tile = this.tiles.get(e.getLongKey());
            if (tile == null) continue;
            tile.clearMarkedChunksImage();
        }
        this.unsavedSelection = !selection.isEmpty() || selectedBefore == this.selectedChunks && this.unsavedSelection;
    }

    public void setSelection(Selection selection) {
        this.selection = selection;
        this.selectedChunks = selection.count();
        this.unsavedSelection = !selection.isEmpty();
    }

    public void setPastedChunks(SelectionData data) {
        this.pastedChunks = data.getSelection();
        this.pastedWorld = data.getWorld();
        if (data.getSelection() == null) {
            this.pastedChunksCache = null;
            this.pastedChunksOffset = null;
        } else {
            this.pastedChunksCache = new HashMap<Point2i, Image>();
            Point2i offsetInChunks = this.offset.toPoint2i().blockToChunk();
            Point2i pastedMid = new Point2i((data.getMax().getX() - data.getMin().getX()) / 2, (data.getMax().getZ() - data.getMin().getZ()) / 2);
            Point2i originOffset = offsetInChunks.sub(data.getMin()).sub(pastedMid);
            Point2f screenSizeInChunks = new Point2f(this.getWidth(), this.getHeight()).mul(this.scale).div(16.0f);
            this.pastedChunksOffset = originOffset.add(screenSizeInChunks.div(2.0f).toPoint2i());
        }
    }

    public boolean hasUnsavedSelection() {
        return this.unsavedSelection;
    }

    public void setSelectionSaved() {
        this.unsavedSelection = false;
    }

    public Selection getPastedChunks() {
        return this.pastedChunks;
    }

    public boolean isInPastingMode() {
        return this.pastedChunks != null;
    }

    public WorldDirectories getPastedWorld() {
        return this.pastedWorld;
    }

    public Point2i getPastedChunksOffset() {
        return this.pastedChunksOffset;
    }

    private Point2i getMouseBlock(double x, double z) {
        int blockX = (int)Math.floor((double)this.offset.getX() + x * (double)this.scale);
        int blockZ = (int)Math.floor((double)this.offset.getY() + z * (double)this.scale);
        return new Point2i(blockX, blockZ);
    }

    private Point2i getMouseRegion(double x, double z) {
        return this.getMouseBlock(x, z).blockToRegion();
    }

    private Point2i getMouseChunk(double x, double z) {
        return this.getMouseBlock(x, z).blockToChunk();
    }

    private void sortPoints(Point2i a, Point2i b) {
        Point2i aa = a.clone();
        a.setX(Math.min(a.getX(), b.getX()));
        a.setZ(Math.min(a.getZ(), b.getZ()));
        b.setX(Math.max(aa.getX(), b.getX()));
        b.setZ(Math.max(aa.getZ(), b.getZ()));
    }

    private void mark(double mouseX, double mouseY, boolean mark) {
        boolean paintMode = this.window.isKeyPressed(KeyCode.SHIFT);
        if (paintMode) {
            this.firstMouseLocation = new Point2f(mouseX, mouseY);
        }
        int selectedBefore = this.selectedChunks;
        if (this.scale > 1.5f) {
            Point2i mouseRegion = this.getMouseRegion(mouseX, mouseY);
            Point2i firstRegion = paintMode ? mouseRegion : this.getMouseRegion(this.firstMouseLocation.getX(), this.firstMouseLocation.getY());
            this.sortPoints(firstRegion, mouseRegion);
            for (int x = firstRegion.getX(); x <= mouseRegion.getX(); ++x) {
                for (int z = firstRegion.getZ(); z <= mouseRegion.getZ(); ++z) {
                    int diff;
                    Point2i region = new Point2i(x, z);
                    if (mark) {
                        diff = this.selection.addRegion(region.asLong());
                        this.selectedChunks += this.selection.isInverted() ? -diff : diff;
                        continue;
                    }
                    diff = this.selection.removeRegion(region.asLong());
                    this.selectedChunks += this.selection.isInverted() ? diff : -diff;
                }
            }
        } else {
            Point2i mouseChunk = this.getMouseChunk(mouseX, mouseY);
            Point2i firstChunk = paintMode ? mouseChunk : this.getMouseChunk(this.firstMouseLocation.getX(), this.firstMouseLocation.getY());
            this.sortPoints(firstChunk, mouseChunk);
            for (int x = firstChunk.getX(); x <= mouseChunk.getX(); ++x) {
                for (int z = firstChunk.getZ(); z <= mouseChunk.getZ(); ++z) {
                    Point2i chunk = new Point2i(x, z);
                    Point2i region = chunk.chunkToRegion();
                    if (mark) {
                        if (this.selection.isChunkSelected(x, z)) continue;
                        this.selection.addChunk(chunk);
                        this.selectedChunks = this.selection.isInverted() ? --this.selectedChunks : ++this.selectedChunks;
                        this.resetMarkedChunksImage(region);
                        continue;
                    }
                    if (!this.selection.isChunkSelected(x, z)) continue;
                    this.selection.removeChunk(chunk);
                    this.selectedChunks = this.selection.isInverted() ? ++this.selectedChunks : --this.selectedChunks;
                    this.resetMarkedChunksImage(region);
                }
            }
        }
        this.unsavedSelection = !this.selection.isEmpty() || selectedBefore == this.selectedChunks && this.unsavedSelection;
    }

    private void resetMarkedChunksImage(Point2i region) {
        Tile tile = this.tiles.get(region.asLong());
        if (tile == null) {
            tile = this.tiles.put(region.asLong(), new Tile(region));
        }
        tile.markedChunksImage = null;
    }

    private void draw(GraphicsContext ctx) {
        ctx.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
        this.runOnVisibleRegions(region -> {
            Tile tile = this.tiles.get(region.asLong());
            Point2f canvasOffset = region.regionToBlock().toPoint2f().sub(this.offset).div(this.scale);
            TileImage.draw(ctx, tile, this.scale, canvasOffset, this.selection, this.overlayParser.get() != null, this.showNonexistentRegions);
        }, new Point2f(), () -> Float.valueOf(this.scale), Integer.MAX_VALUE);
        if (this.pastedChunks != null) {
            this.runOnVisibleRegions(region -> {
                Point2f regionOffset = region.regionToBlock().toPoint2f().sub(this.offset.getX(), this.offset.getY());
                Point2f p = regionOffset.div(this.scale).add(this.pastedChunksOffset.mul(16).toPoint2f().div(this.scale));
                this.drawPastedChunks(ctx, (Point2i)region, p);
            }, this.pastedChunksOffset.mul(16).toPoint2f(), () -> Float.valueOf(this.scale), Integer.MAX_VALUE);
        }
        if (this.showRegionGrid) {
            this.drawRegionGrid(ctx);
        }
        if (this.showChunkGrid && this.scale <= 1.5f) {
            this.drawChunkGrid(ctx);
        }
        if (this.showCoordinates) {
            if ((double)this.scale < 1.2) {
                this.drawChunkCoordinates(ctx);
            } else {
                this.drawRegionCoordinates(ctx);
            }
        }
    }

    private void drawRegionCoordinates(GraphicsContext ctx) {
        ctx.setFill((Paint)Tile.COORDINATES_COLOR.makeJavaFXColor());
        Point2f p = TileMap.getRegionGridMin(this.offset, this.scale);
        int multiplier = 1;
        if (this.scale > 7.0f) {
            multiplier = 4;
        } else if (this.scale > 4.0f) {
            multiplier = 2;
        }
        float step = 512.0f / this.scale;
        float halfStep = 512.0f / (this.scale * 2.0f);
        int mul = multiplier * 512;
        boolean oldStep = true;
        Point2f first = p;
        float x = first.getX();
        while ((double)x <= this.getWidth()) {
            float y = first.getY();
            while ((double)y <= this.getHeight()) {
                Point2i region = this.getMouseRegion(x + halfStep, y + halfStep).regionToBlock();
                if (!oldStep || region.getX() % mul == 0 && region.getZ() % mul == 0) {
                    ctx.fillText(region.getX() + "," + region.getZ(), (double)(x + 2.0f), (double)(y + 16.0f));
                    if (oldStep) {
                        step *= (float)multiplier;
                        oldStep = false;
                        first = new Point2f(x, y);
                    }
                }
                y += step;
            }
            x += step;
        }
        float y = first.getY();
        while ((double)y <= this.getHeight()) {
            Point2i region = this.getMouseRegion(first.getX() - step + halfStep, y + halfStep).regionToBlock();
            ctx.fillText(region.getX() + "," + region.getZ(), (double)(first.getX() - step + 2.0f), (double)(y + 16.0f));
            y += step;
        }
    }

    private void drawChunkCoordinates(GraphicsContext ctx) {
        ctx.setFill((Paint)Tile.COORDINATES_COLOR.makeJavaFXColor());
        Point2f p = TileMap.getRegionGridMin(this.offset, this.scale);
        int multiplier = 1;
        if ((double)this.scale > 0.8) {
            multiplier = 16;
        } else if ((double)this.scale > 0.4) {
            multiplier = 8;
        } else if ((double)this.scale > 0.2) {
            multiplier = 4;
        } else if ((double)this.scale > 0.1) {
            multiplier = 2;
        }
        float step = 16.0f / this.scale;
        float halfStep = 16.0f / (this.scale * 2.0f);
        int mul = multiplier * 16;
        boolean oldStep = true;
        Point2f first = p;
        float x = first.getX();
        while ((double)x <= this.getWidth()) {
            float y = first.getY();
            while ((double)y <= this.getHeight()) {
                Point2i chunk = this.getMouseChunk(x + halfStep, y + halfStep).chunkToBlock();
                if (!oldStep || chunk.getX() % mul == 0 && chunk.getZ() % mul == 0) {
                    ctx.fillText(chunk.getX() + "," + chunk.getZ(), (double)(x + 2.0f), (double)(y + 16.0f));
                    if (oldStep) {
                        step *= (float)multiplier;
                        oldStep = false;
                        first = new Point2f(x, y);
                    }
                }
                y += step;
            }
            x += step;
        }
    }

    private void drawPastedChunks(GraphicsContext ctx, Point2i region, Point2f pos) {
        Color color = ConfigProvider.GLOBAL.getPasteChunksColor().makeJavaFXColor();
        ctx.setFill((Paint)color);
        if (this.pastedChunks.isRegionSelected(region.asLong())) {
            ctx.fillRect((double)pos.getX(), (double)pos.getY(), Math.ceil(512.0f / this.scale), Math.ceil(512.0f / this.scale));
            return;
        }
        if (!this.pastedChunksCache.containsKey(region)) {
            WritableImage wImage = new WritableImage(32, 32);
            PixelWriter writer = wImage.getPixelWriter();
            ChunkSet chunks = this.pastedChunks.getSelectedChunks(region);
            IntIterator intIterator = chunks.iterator();
            while (intIterator.hasNext()) {
                int chunk = (Integer)intIterator.next();
                Point2i regionChunk = new Point2i(chunk);
                writer.setColor(regionChunk.getX(), regionChunk.getZ(), color);
            }
            this.pastedChunksCache.put(region, (Image)wImage);
            ctx.drawImage((Image)wImage, (double)pos.getX(), (double)pos.getY(), (double)(512.0f / this.scale), (double)(512.0f / this.scale));
        } else {
            ctx.drawImage(this.pastedChunksCache.get(region), (double)pos.getX(), (double)pos.getY(), (double)(512.0f / this.scale), (double)(512.0f / this.scale));
        }
    }

    private void drawRegionGrid(GraphicsContext ctx) {
        ctx.setLineWidth(Tile.GRID_LINE_WIDTH);
        ctx.setStroke((Paint)Tile.REGION_GRID_COLOR.makeJavaFXColor());
        Point2f p = TileMap.getRegionGridMin(this.offset, this.scale);
        float x = p.getX();
        while ((double)x <= this.getWidth()) {
            ctx.strokeLine((double)x, 0.0, (double)x, this.getHeight());
            x += 512.0f / this.scale;
        }
        float y = p.getY();
        while ((double)y <= this.getHeight()) {
            ctx.strokeLine(0.0, (double)y, this.getWidth(), (double)y);
            y += 512.0f / this.scale;
        }
    }

    private void drawChunkGrid(GraphicsContext ctx) {
        ctx.setLineWidth(Tile.GRID_LINE_WIDTH);
        ctx.setStroke((Paint)Tile.CHUNK_GRID_COLOR.makeJavaFXColor());
        Point2f p = TileMap.getChunkGridMin(this.offset, this.scale);
        Point2f pReg = TileMap.getRegionGridMin(this.offset, this.scale);
        float x = p.getX() + 16.0f / this.scale;
        while ((double)x <= this.getWidth()) {
            if (this.showRegionGrid && (int)(pReg.getX() + 512.0f / this.scale) == (int)x) {
                pReg.setX(pReg.getX() + 512.0f / this.scale);
            } else {
                ctx.strokeLine((double)x, 0.0, (double)x, this.getHeight());
            }
            x += 16.0f / this.scale;
        }
        float y = p.getY() + 16.0f / this.scale;
        while ((double)y <= this.getHeight()) {
            if (this.showRegionGrid && (int)(pReg.getY() + 512.0f / this.scale) == (int)y) {
                pReg.setY(pReg.getY() + 512.0f / this.scale);
            } else {
                ctx.strokeLine(0.0, (double)y, this.getWidth(), (double)y);
            }
            y += 16.0f / this.scale;
        }
    }

    public void runOnVisibleRegions(Consumer<Point2i> consumer, Point2f additionalOffset, Supplier<Float> scaleSupplier, int limit) {
        float scale = scaleSupplier.get().floatValue();
        Point2i min = this.offset.sub(additionalOffset).toPoint2i().blockToRegion();
        Point2i max = this.offset.sub(additionalOffset).add((float)this.getWidth() * scale, (float)this.getHeight() * scale).toPoint2i().blockToRegion();
        Point2i mid = min.regionToBlock().add(max.regionToBlock()).div(2).blockToRegion().regionToBlock().blockToRegion();
        int dir = 0;
        int steps = 1;
        int xSteps = 0;
        int ySteps = 0;
        int step = 0;
        int x = mid.getX();
        int y = mid.getZ();
        int count = 0;
        while (!(x > max.getX() && y > max.getZ() || x < min.getX() && y < min.getZ())) {
            for (int i = 0; i < steps * 2; ++i) {
                x = mid.getX() + xSteps;
                y = mid.getZ() + ySteps;
                if (x <= max.getX() && x >= min.getX() && y <= max.getZ() && y >= min.getZ()) {
                    consumer.accept(new Point2i(x, y));
                    if (++count == limit) {
                        return;
                    }
                }
                switch (dir) {
                    case 0: {
                        ++xSteps;
                        break;
                    }
                    case 1: {
                        ++ySteps;
                        break;
                    }
                    case 2: {
                        --xSteps;
                        break;
                    }
                    case 3: {
                        --ySteps;
                    }
                }
                if (++step != steps) continue;
                step = 0;
                if (++dir <= 3) continue;
                dir = 0;
            }
            ++steps;
        }
    }

    public Window getWindow() {
        return this.window;
    }

    public void resize(double width, double height) {
        this.setWidth(width);
        this.setHeight(height);
        this.draw();
    }

    public boolean isResizable() {
        return true;
    }

    public double minHeight(double width) {
        return 0.0;
    }

    public double minWidth(double height) {
        return 0.0;
    }

    public double maxHeight(double width) {
        return 2.147483647E9;
    }

    public double maxWidth(double height) {
        return 2.147483647E9;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        LOGGER.debug("TileMap lost ownership");
    }
}

