/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.tile;

import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.ImageHelper;
import net.querz.mcaselector.io.mca.Chunk;
import net.querz.mcaselector.io.mca.RegionMCAFile;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.tile.Tile;
import net.querz.mcaselector.util.math.MathUtil;
import net.querz.mcaselector.util.point.Point2f;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.version.ChunkRenderer;
import net.querz.mcaselector.version.ColorMapping;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.VersionHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TileImage {
    private static final Logger LOGGER = LogManager.getLogger(TileImage.class);
    private static final int[] corruptedChunkOverlay = new int[256];

    private TileImage() {
    }

    public static void draw(GraphicsContext ctx, Tile tile, float scale, Point2f offset, Selection selection, boolean overlay, boolean showNonexistentRegions) {
        if ((tile == null || tile.image == null) && showNonexistentRegions) {
            ctx.drawImage(ImageHelper.getEmptyTileImage(), (double)offset.getX(), (double)offset.getY(), (double)(512.0f / scale), (double)(512.0f / scale));
        }
        if (tile != null) {
            if (tile.image != null) {
                ctx.setImageSmoothing(ConfigProvider.WORLD.getSmoothRendering());
                ctx.drawImage(tile.image, (double)offset.getX(), (double)offset.getY(), (double)(512.0f / scale), (double)(512.0f / scale));
                ctx.setImageSmoothing(false);
            }
            if (overlay && tile.overlay != null) {
                ctx.setGlobalAlpha(0.5);
                ctx.setImageSmoothing(ConfigProvider.WORLD.getSmoothOverlays());
                ctx.drawImage(tile.getOverlay(), (double)offset.getX(), (double)offset.getY(), (double)(512.0f / scale), (double)(512.0f / scale));
                ctx.setGlobalAlpha(1.0);
                ctx.setImageSmoothing(false);
            }
            if (selection.isRegionSelected(tile.getLongLocation())) {
                ctx.setFill((Paint)ConfigProvider.GLOBAL.getRegionSelectionColor().makeJavaFXColor());
                ctx.fillRect((double)offset.getX(), (double)offset.getY(), (double)(512.0f / scale), (double)(512.0f / scale));
            } else if (selection.isAnyChunkInRegionSelected(tile.getLongLocation())) {
                if (tile.markedChunksImage == null) {
                    TileImage.createMarkedChunksImage(tile, selection.getSelectedChunks(tile.getLocation()));
                }
                ctx.drawImage(tile.markedChunksImage, (double)offset.getX(), (double)offset.getY(), (double)(512.0f / scale), (double)(512.0f / scale));
            }
        } else if (selection.isInverted()) {
            ctx.setFill((Paint)ConfigProvider.GLOBAL.getRegionSelectionColor().makeJavaFXColor());
            ctx.fillRect((double)offset.getX(), (double)offset.getY(), (double)(512.0f / scale), (double)(512.0f / scale));
        }
    }

    static void createMarkedChunksImage(Tile tile, ChunkSet selection) {
        if (selection == null) {
            tile.markedChunksImage = null;
            return;
        }
        WritableImage wImage = new WritableImage(32, 32);
        PixelWriter writer = wImage.getPixelWriter();
        Color chunkSelectionColor = ConfigProvider.GLOBAL.getChunkSelectionColor().makeJavaFXColor();
        selection.forEach(s -> {
            Point2i regionChunk = new Point2i(s);
            writer.setColor(regionChunk.getX(), regionChunk.getZ(), chunkSelectionColor);
        });
        tile.markedChunksImage = wImage;
    }

    public static Image generateImage(RegionMCAFile mcaFile, int scale) {
        int size = 512 / scale;
        int chunkSize = 16 / scale;
        int pixels = 262144 / (scale * scale);
        try {
            WritableImage finalImage = new WritableImage(size, size);
            PixelWriter writer = finalImage.getPixelWriter();
            int[] pixelBuffer = new int[pixels];
            int[] waterPixels = ConfigProvider.WORLD.getShade() && ConfigProvider.WORLD.getShadeWater() && !ConfigProvider.WORLD.getRenderCaves() ? new int[pixels] : null;
            short[] terrainHeights = new short[pixels];
            short[] waterHeights = ConfigProvider.WORLD.getShade() && ConfigProvider.WORLD.getShadeWater() && !ConfigProvider.WORLD.getRenderCaves() ? new short[pixels] : null;
            for (int cx = 0; cx < 32; ++cx) {
                for (int cz = 0; cz < 32; ++cz) {
                    int index = cz * 32 + cx;
                    Object data = mcaFile.getChunk(index);
                    if (data == null) continue;
                    TileImage.drawChunkImage(data, cx * chunkSize, cz * chunkSize, scale, pixelBuffer, waterPixels, terrainHeights, waterHeights);
                }
            }
            if (ConfigProvider.WORLD.getRenderCaves()) {
                TileImage.flatShade(pixelBuffer, terrainHeights, scale);
            } else if (ConfigProvider.WORLD.getShade() && !ConfigProvider.WORLD.getRenderLayerOnly()) {
                TileImage.shade(pixelBuffer, waterPixels, terrainHeights, waterHeights, scale);
            }
            writer.setPixels(0, 0, size, size, (PixelFormat)PixelFormat.getIntArgbPreInstance(), pixelBuffer, 0, size);
            return finalImage;
        }
        catch (Exception ex) {
            LOGGER.warn("failed to create image for MCAFile {}", (Object)mcaFile.getFile().getName(), (Object)ex);
            return null;
        }
    }

    private static void drawChunkImage(Chunk chunkData, int x, int z, int scale, int[] pixelBuffer, int[] waterPixels, short[] terrainHeights, short[] waterHeights) {
        if (chunkData.getData() == null) {
            return;
        }
        int dataVersion = Helper.getDataVersion(chunkData.getData());
        try {
            if (ConfigProvider.WORLD.getRenderCaves()) {
                VersionHandler.getImpl(dataVersion, ChunkRenderer.class).drawCaves(chunkData.getData(), VersionHandler.getImpl(dataVersion, ColorMapping.class), x, z, scale, pixelBuffer, terrainHeights, ConfigProvider.WORLD.getRenderHeight());
            } else if (ConfigProvider.WORLD.getRenderLayerOnly()) {
                VersionHandler.getImpl(dataVersion, ChunkRenderer.class).drawLayer(chunkData.getData(), VersionHandler.getImpl(dataVersion, ColorMapping.class), x, z, scale, pixelBuffer, ConfigProvider.WORLD.getRenderHeight());
            } else {
                VersionHandler.getImpl(dataVersion, ChunkRenderer.class).drawChunk(chunkData.getData(), VersionHandler.getImpl(dataVersion, ColorMapping.class), x, z, scale, pixelBuffer, waterPixels, terrainHeights, waterHeights, ConfigProvider.WORLD.getShade() && ConfigProvider.WORLD.getShadeWater(), ConfigProvider.WORLD.getRenderHeight());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("failed to draw chunk {}", (Object)chunkData.getAbsoluteLocation(), (Object)ex);
            for (int cx = 0; cx < 16; cx += scale) {
                for (int cz = 0; cz < 16; cz += scale) {
                    int srcIndex = cz * 16 + cx;
                    int dstIndex = (z + cz / scale) * 512 / scale + (x + cx / scale);
                    pixelBuffer[dstIndex] = corruptedChunkOverlay[srcIndex];
                    terrainHeights[dstIndex] = 64;
                    waterHeights[dstIndex] = 64;
                }
            }
        }
    }

    private static void flatShade(int[] pixelBuffer, short[] terrainHeights, int scale) {
        int size = 512 / scale;
        int index = 0;
        for (int z = 0; z < size; ++z) {
            int x = 0;
            while (x < size) {
                int altitudeShade = MathUtil.clamp(terrainHeights[index] / 4, -50, 50);
                pixelBuffer[index] = net.querz.mcaselector.ui.Color.shade(pixelBuffer[index], altitudeShade * 4);
                ++x;
                ++index;
            }
        }
    }

    private static void shade(int[] pixelBuffer, int[] waterPixels, short[] terrainHeights, short[] waterHeights, int scale) {
        if (!ConfigProvider.WORLD.getShadeWater() || !ConfigProvider.WORLD.getShade()) {
            waterHeights = terrainHeights;
        }
        int size = 512 / scale;
        float altitudeShadeMultiplier = ConfigProvider.WORLD.getShadeAltitude() ? 0.046875f : 0.0f;
        int index = 0;
        for (int z = 0; z < size; ++z) {
            int x = 0;
            while (x < size) {
                if (pixelBuffer[index] != 0) {
                    if (terrainHeights[index] != waterHeights[index]) {
                        float ratio = 0.5f - 0.0125f * (float)(waterHeights[index] - terrainHeights[index]);
                        pixelBuffer[index] = net.querz.mcaselector.ui.Color.blend(pixelBuffer[index], waterPixels[index], ratio);
                    } else {
                        float zShade = z == 0 ? (float)(waterHeights[index + size] - waterHeights[index]) : (z == size - 1 ? (float)(waterHeights[index] - waterHeights[index - size]) : (float)((waterHeights[index + size] - waterHeights[index - size]) * 2));
                        float xShade = x == 0 ? (float)(waterHeights[index + 1] - waterHeights[index]) : (x == size - 1 ? (float)(waterHeights[index] - waterHeights[index - 1]) : (float)((waterHeights[index + 1] - waterHeights[index - 1]) * 2));
                        float shade = xShade + zShade;
                        shade = MathUtil.clamp(shade, -8.0f, 8.0f);
                        float altitudeShade = ((float)waterHeights[index] - 64.0f) * altitudeShadeMultiplier;
                        altitudeShade = MathUtil.clamp(altitudeShade, -4.0f, 12.0f);
                        pixelBuffer[index] = net.querz.mcaselector.ui.Color.shade(pixelBuffer[index], (int)((shade += altitudeShade) * 8.0f));
                    }
                }
                ++x;
                ++index;
            }
        }
    }

    static {
        Image corrupted = FileHelper.getIconFromResources("img/corrupted");
        PixelReader pr = corrupted.getPixelReader();
        pr.getPixels(0, 0, 16, 16, PixelFormat.getIntArgbPreInstance(), corruptedChunkOverlay, 0, 16);
    }
}

