/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.tile;

import java.io.File;
import javafx.scene.image.Image;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.ImageHelper;
import net.querz.mcaselector.tile.TileMap;
import net.querz.mcaselector.ui.Color;
import net.querz.mcaselector.util.math.Bits;
import net.querz.mcaselector.util.point.Point2i;

public class Tile {
    public static Color REGION_GRID_COLOR = new Color(0.0, 0.0, 0.0, 0.5);
    public static Color CHUNK_GRID_COLOR = new Color(0.6627451181411743, 0.6627451181411743, 0.6627451181411743, 0.5);
    public static Color COORDINATES_COLOR = new Color(1.0, 1.0, 1.0, 0.5);
    public static Color EMPTY_COLOR = new Color(0.2, 0.2, 0.2, 1.0);
    public static double GRID_LINE_WIDTH = 1.0;
    public static final int SIZE = 512;
    public static final int CHUNK_SIZE = 16;
    public static final int SIZE_IN_CHUNKS = 32;
    public static final int CHUNKS = 1024;
    public static final int PIXELS = 262144;
    final Point2i location;
    final long longLocation;
    Image markedChunksImage;
    Image image;
    boolean loaded = false;
    Image overlay;
    boolean overlayLoaded = false;

    public Tile(Point2i location) {
        this.location = location;
        this.longLocation = location.asLong();
    }

    public static int getZoomLevel(float scale) {
        return Bits.getMsb((int)scale);
    }

    public boolean isVisible(TileMap tileMap) {
        return this.isVisible(tileMap, 0);
    }

    public boolean isVisible(TileMap tileMap, int threshold) {
        Point2i o = tileMap.getOffset().toPoint2i();
        Point2i min = o.sub(threshold * 512).blockToRegion().regionToBlock();
        Point2i max = new Point2i((int)((double)o.getX() + tileMap.getWidth() * (double)tileMap.getScale()), (int)((double)o.getZ() + tileMap.getHeight() * (double)tileMap.getScale())).add(threshold * 512).blockToRegion().regionToBlock();
        return this.location.getX() * 512 >= min.getX() && this.location.getZ() * 512 >= min.getZ() && this.location.getX() * 512 <= max.getX() && this.location.getZ() * 512 <= max.getZ();
    }

    public Image getImage() {
        return this.image;
    }

    public Image getOverlay() {
        return this.overlay;
    }

    public boolean isOverlayLoaded() {
        return this.overlayLoaded;
    }

    public Point2i getLocation() {
        return this.location;
    }

    public long getLongLocation() {
        return this.longLocation;
    }

    public boolean isEmpty() {
        return this.image == null || this.image == ImageHelper.getEmptyTileImage();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public boolean matchesZoomLevel(int zoomLevel) {
        if (this.image == null) {
            return true;
        }
        return (int)(512.0 / this.image.getWidth()) == zoomLevel;
    }

    public int getImageZoomLevel() {
        return (int)(512.0 / this.image.getWidth());
    }

    public void unload(boolean overlay, boolean img) {
        if (this.image != null) {
            this.image.cancel();
            if (img) {
                this.image = null;
            }
        }
        if (this.markedChunksImage != null) {
            this.markedChunksImage.cancel();
            this.markedChunksImage = null;
        }
        if (overlay && this.overlay != null) {
            this.overlay.cancel();
            this.overlay = null;
        }
        this.loaded = false;
    }

    public void clearMarkedChunksImage() {
        this.markedChunksImage = null;
    }

    public File getMCAFile() {
        return FileHelper.createMCAFilePath(this.location);
    }

    public void setImage(Image image) {
        this.image = image;
    }
}

