/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.tile;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import javafx.scene.input.KeyCode;
import net.querz.mcaselector.util.validation.ShutdownHooks;

public class KeyActivator
extends TimerTask {
    private final Set<KeyCode> pressedButtons = EnumSet.noneOf(KeyCode.class);
    private final Set<KeyCode> pressedActionKeys = EnumSet.noneOf(KeyCode.class);
    private final Map<KeyCode, List<Consumer<Set<KeyCode>>>> actions = new EnumMap<KeyCode, List<Consumer<Set<KeyCode>>>>(KeyCode.class);
    private Runnable globalAction;

    public KeyActivator() {
        Timer timer = new Timer();
        timer.schedule((TimerTask)this, 0L, 33L);
        ShutdownHooks.addShutdownHook(timer::cancel);
    }

    @Override
    public void run() {
        int executed = 0;
        for (KeyCode pressedButton : this.pressedButtons) {
            List<Consumer<Set<KeyCode>>> actionList = this.actions.get(pressedButton);
            if (actionList == null) continue;
            for (Consumer<Set<KeyCode>> consumer : actionList) {
                consumer.accept(this.pressedActionKeys);
                ++executed;
            }
        }
        if (this.globalAction != null && executed > 0) {
            this.globalAction.run();
        }
    }

    public void pressActionKey(KeyCode key) {
        this.pressedActionKeys.add(key);
    }

    public void releaseActionKey(KeyCode key) {
        this.pressedActionKeys.remove(key);
    }

    public void pressKey(KeyCode key) {
        this.pressedButtons.add(key);
    }

    public void releaseKey(KeyCode key) {
        this.pressedButtons.remove(key);
    }

    public void releaseAllKeys() {
        this.pressedButtons.clear();
        this.pressedActionKeys.clear();
    }

    public void registerAction(KeyCode key, Consumer<Set<KeyCode>> action) {
        List actionList = this.actions.getOrDefault(key, new ArrayList());
        actionList.add(action);
        this.actions.put(key, actionList);
    }

    public void registerGlobalAction(Runnable action) {
        this.globalAction = action;
    }

    public static boolean isArrowKey(KeyCode code) {
        return switch (code) {
            case KeyCode.UP, KeyCode.RIGHT, KeyCode.DOWN, KeyCode.LEFT -> true;
            default -> false;
        };
    }
}

