/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.tile;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Stream;
import javafx.scene.image.Image;
import javafx.stage.Window;
import net.querz.mcaselector.config.Config;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.ImageHelper;
import net.querz.mcaselector.io.db.CacheHandler;
import net.querz.mcaselector.io.job.CachedImageLoadJob;
import net.querz.mcaselector.io.job.RegionImageGenerator;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.tile.Tile;
import net.querz.mcaselector.tile.TileMap;
import net.querz.mcaselector.ui.ProgressTask;
import net.querz.mcaselector.ui.dialog.ErrorDialog;
import net.querz.mcaselector.util.point.Point2i;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.iq80.leveldb.DBException;

public final class ImagePool {
    private static final Logger LOGGER = LogManager.getLogger(ImagePool.class);
    private final Object poolLock = new Object();
    private final Int2ObjectOpenHashMap<Long2ObjectLinkedOpenHashMap<Image>> pool = new Int2ObjectOpenHashMap(4);
    private final LongSet regions = new LongOpenHashSet(2048);
    private final TileMap tileMap;
    private final double poolSize;

    public ImagePool(TileMap tileMap, double poolSize) {
        for (int i = 1; i <= Config.MAX_ZOOM_LEVEL; i *= 2) {
            this.pool.put(i, (Long2ObjectLinkedOpenHashMap<Image>)new Long2ObjectLinkedOpenHashMap());
        }
        this.tileMap = tileMap;
        this.poolSize = poolSize;
    }

    public void requestImage(Tile tile, int zoomLevel) {
        File diskCacheImageFile;
        if (!this.regions.contains(tile.location.asLong())) {
            tile.setLoaded(true);
            return;
        }
        if (RegionImageGenerator.isLoading(tile) || CachedImageLoadJob.isLoading(tile)) {
            return;
        }
        Image image = this.pool.get(zoomLevel).get(tile.location.asLong());
        if (image != null) {
            tile.setImage(image);
            tile.setLoaded(true);
            return;
        }
        for (int zl = 1; zl <= Config.MAX_ZOOM_LEVEL; zl *= 2) {
            if (zl == zoomLevel || (image = this.pool.get(zl).get(tile.location.asLong())) == null) continue;
            if (zl < zoomLevel) {
                tile.setImage(ImageHelper.scaleDownFXImage(image, 512 / zl));
                tile.setLoaded(true);
                this.push(zoomLevel, tile.location, tile.image);
                return;
            }
            tile.setImage(image);
            tile.setLoaded(true);
            break;
        }
        if ((diskCacheImageFile = FileHelper.createPNGFilePath(ConfigProvider.WORLD.getCacheDir(), zoomLevel, tile.location)).exists()) {
            CachedImageLoadJob.setLoading(tile, true);
            CachedImageLoadJob.load(tile, diskCacheImageFile, zoomLevel, zoomLevel, img -> {
                CachedImageLoadJob.setLoading(tile, false);
                this.push(zoomLevel, tile.location, (Image)img);
                this.tileMap.draw();
                if (this.isImageOutdated(tile.location)) {
                    this.discardCachedImage(tile.location);
                    tile.setLoaded(false);
                }
            });
            return;
        }
        for (int zl = 1; zl <= Config.MAX_ZOOM_LEVEL; zl *= 2) {
            if (zl == zoomLevel || !(diskCacheImageFile = FileHelper.createPNGFilePath(ConfigProvider.WORLD.getCacheDir(), zl, tile.location)).exists()) continue;
            if (zl < zoomLevel) {
                CachedImageLoadJob.setLoading(tile, true);
                CachedImageLoadJob.load(tile, diskCacheImageFile, zl, zoomLevel, img -> {
                    CachedImageLoadJob.setLoading(tile, false);
                    this.push(zoomLevel, tile.location, (Image)img);
                    this.tileMap.draw();
                    if (this.isImageOutdated(tile.location)) {
                        this.discardCachedImage(tile.location);
                        tile.setLoaded(false);
                    }
                });
                return;
            }
            CachedImageLoadJob.setLoading(tile, true);
            CachedImageLoadJob.load(tile, diskCacheImageFile, zl, zl, img -> {
                CachedImageLoadJob.setLoading(tile, false);
                this.tileMap.draw();
                if (this.isImageOutdated(tile.location)) {
                    this.discardCachedImage(tile.location);
                    tile.setLoaded(false);
                }
            });
            break;
        }
        RegionImageGenerator.setLoading(tile, true);
        RegionImageGenerator.generate(tile, (img, uuid) -> {
            tile.setImage((Image)img);
            tile.loaded = true;
            RegionImageGenerator.setLoading(tile, false);
            this.push(zoomLevel, tile.location, (Image)img);
            this.tileMap.draw();
            try {
                CacheHandler.setFileTime(tile.location, this.readLastModifiedDate(tile.location));
            }
            catch (DBException e) {
                LOGGER.error("failed to cache last modified date for {}", (Object)tile.location, (Object)e);
            }
        }, zoomLevel, null, true, () -> this.tileMap.getTilePriority(tile.getLocation()));
    }

    public boolean isImageOutdated(Point2i region) {
        try {
            long time = CacheHandler.getFileTime(region);
            if (time == -1L) {
                return false;
            }
            return time != this.readLastModifiedDate(region);
        }
        catch (DBException e) {
            return false;
        }
    }

    private long readLastModifiedDate(Point2i region) {
        try {
            Path path = FileHelper.createMCAFilePath(region).toPath();
            if (!path.toFile().exists()) {
                return 0L;
            }
            BasicFileAttributes bfa = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            return bfa.lastModifiedTime().toMillis();
        }
        catch (IOException e) {
            LOGGER.warn("failed to read last modified date for {}", (Object)region, (Object)e);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(int scale, Point2i location, Image img) {
        Object object = this.poolLock;
        synchronized (object) {
            this.pool.get(scale).put(location.asLong(), img);
            this.trim(scale);
        }
    }

    private void trim(int scale) {
        Long2ObjectLinkedOpenHashMap<Image> scaleEntry = this.pool.get(scale);
        if ((double)scaleEntry.size() <= (double)this.tileMap.getVisibleTiles() * this.poolSize) {
            return;
        }
        ObjectOpenHashSet<Point2i> l = this.tileMap.getVisibleRegions(scale * 2);
        LongBidirectionalIterator it = scaleEntry.keySet().iterator();
        while (it.hasNext()) {
            long p = it.nextLong();
            Point2i r = new Point2i(p);
            if (l.contains(r)) continue;
            it.remove();
            LOGGER.debug("removed {} for scale {} from pool", (Object)r, (Object)scale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(ProgressTask task) {
        Object object = this.poolLock;
        synchronized (object) {
            for (Int2ObjectMap.Entry scale : this.pool.int2ObjectEntrySet()) {
                ((Long2ObjectLinkedOpenHashMap)scale.getValue()).clear();
            }
        }
        this.loadRegions(task);
        LOGGER.debug("cleared pool");
    }

    public void loadRegions(ProgressTask task) {
        File[] files;
        this.regions.clear();
        if (task != null) {
            task.setMessage(Translation.DIALOG_PROGRESS_SCANNING_FILES.toString());
        }
        if ((files = ConfigProvider.WORLD.getWorldDirs().getRegion().listFiles()) == null) {
            return;
        }
        if (task != null) {
            task.setMax(files.length);
        }
        try (ForkJoinPool threadPool = new ForkJoinPool(ConfigProvider.GLOBAL.getProcessThreads());){
            List points = (List)((ForkJoinTask)threadPool.submit(() -> ((Stream)Arrays.stream(files).parallel()).filter(file -> file.length() > 8192L).map(file -> {
                Point2i p = FileHelper.parseMCAFileName(file);
                if (task != null && p != null) {
                    task.incrementProgress(String.format("%d, %d", p.getX(), p.getZ()));
                }
                return p;
            }).filter(Objects::nonNull).toList())).get();
            points.forEach(p -> this.regions.add(p.asLong()));
            LOGGER.debug("loaded all world files");
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.warn("failed to load world", (Throwable)e);
            if (task != null) {
                task.done(null);
            }
            new ErrorDialog((Window)this.tileMap.getWindow().getPrimaryStage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardImage(Point2i region) {
        Object object = this.poolLock;
        synchronized (object) {
            for (Int2ObjectMap.Entry scale : this.pool.int2ObjectEntrySet()) {
                ((Long2ObjectLinkedOpenHashMap)scale.getValue()).remove(region.asLong());
            }
        }
        if (!CacheHandler.isInitialized()) {
            return;
        }
        try {
            CacheHandler.deleteData(region);
        }
        catch (IOException e) {
            LOGGER.error("failed to delete cache for {}", (Object)region, (Object)e);
        }
        LOGGER.debug("removed images for {} from image pool", (Object)region);
    }

    public void discardCachedImage(Point2i region) {
        this.discardImage(region);
        RegionImageGenerator.uncacheRegionMCAFile(region);
        for (int i = 1; i <= Config.MAX_ZOOM_LEVEL; i *= 2) {
            File png = FileHelper.createPNGFilePath(ConfigProvider.WORLD.getCacheDir(), i, region);
            png.delete();
        }
    }
}

