/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.text;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.querz.mcaselector.util.exception.ParseException;

public final class TextHelper {
    private static final Map<Pattern, Long> DURATION_REGEXP = new HashMap<Pattern, Long>();
    private static final DateTimeFormatter TIMESTAMP_FORMAT;
    private static final ZoneId ZONE_ID;

    private TextHelper() {
    }

    public static long parseDuration(String d) {
        boolean result = false;
        int duration = 0;
        ArrayList<String> elements = new ArrayList<String>();
        for (Map.Entry<Pattern, Long> entry : DURATION_REGEXP.entrySet()) {
            Matcher m = entry.getKey().matcher(d);
            if (!m.find()) continue;
            duration += (int)(Long.parseLong(m.group("data")) * entry.getValue());
            result = true;
            elements.add(d.substring(m.start(), m.end()));
        }
        if (!result) {
            throw new IllegalArgumentException("could not parse anything from duration string");
        }
        String remains = d;
        for (String element : elements) {
            remains = remains.replaceFirst(element, "");
        }
        if (!(remains = remains.trim()).isEmpty()) {
            throw new IllegalArgumentException("invalid element in duration string: " + remains);
        }
        return duration;
    }

    public static int parseTimestamp(String t) {
        String trim = t.trim();
        try {
            LocalDateTime date = LocalDateTime.parse(trim, TIMESTAMP_FORMAT);
            ZonedDateTime zdt = ZonedDateTime.of(date, ZONE_ID);
            return (int)zdt.toInstant().getEpochSecond();
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("could not parse date time");
        }
    }

    public static Integer parseInt(String s, int radix) {
        try {
            return Integer.parseInt(s, radix);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static String byteToBinaryString(byte b) {
        StringBuilder s = new StringBuilder(Integer.toBinaryString(b & 0xFF));
        for (int i = s.length(); i < 8; ++i) {
            s.insert(0, "0");
        }
        return s.toString();
    }

    public static String intToBinaryString(int n) {
        StringBuilder s = new StringBuilder(Integer.toBinaryString(n));
        for (int i = s.length(); i < 32; ++i) {
            s.insert(0, "0");
        }
        return s.toString();
    }

    public static String longToBinaryString(long l) {
        StringBuilder s = new StringBuilder(Long.toBinaryString(l));
        for (int i = s.length(); i < 64; ++i) {
            s.insert(0, "0");
        }
        return s.toString();
    }

    public static String longToBinaryString(long l, int div) {
        int i;
        StringBuilder s = new StringBuilder(Long.toBinaryString(l));
        for (i = s.length(); i < 64; ++i) {
            s.insert(0, "0");
        }
        for (i = 64 - div; i > 0; i -= div) {
            s.insert(i, "_");
        }
        return s.toString();
    }

    public static String getStacktraceAsString(Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static String[] splitWithEscaping(String input, char split, char escape) throws ParseException {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder s = new StringBuilder(input);
        int start = 0;
        boolean escaped = false;
        for (int i = 0; i < s.length(); ++i) {
            char current = s.charAt(i);
            if (current == escape) {
                if (escaped) {
                    s.deleteCharAt(--i);
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (current == split) {
                if (!escaped) {
                    result.add(s.substring(start, i));
                    start = ++i;
                    continue;
                }
                s.deleteCharAt(--i);
                escaped = false;
                continue;
            }
            if (!escaped) continue;
            throw new ParseException("invalid escape sequence", s.toString(), i);
        }
        if (start < s.length() - 1) {
            result.add(s.substring(start));
        }
        return result.toArray(new String[0]);
    }

    static {
        DURATION_REGEXP.put(Pattern.compile("(?<data>\\d+)\\W*(?:years?|y)"), 31536000L);
        DURATION_REGEXP.put(Pattern.compile("(?<data>\\d+)\\W*months?"), 2592000L);
        DURATION_REGEXP.put(Pattern.compile("(?<data>\\d+)\\W*(?:days?|d)"), 86400L);
        DURATION_REGEXP.put(Pattern.compile("(?<data>\\d+)\\W*(?:hours?|h)"), 3600L);
        DURATION_REGEXP.put(Pattern.compile("(?<data>\\d+)\\W*(?:minutes?|mins?)"), 60L);
        DURATION_REGEXP.put(Pattern.compile("(?<data>\\d+)\\W*(?:seconds?|secs?|s)"), 1L);
        TIMESTAMP_FORMAT = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd[ [HH][:mm][:ss]]").parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();
        ZONE_ID = ZoneId.systemDefault();
    }
}

