/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.selection;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.Serializable;
import net.querz.mcaselector.io.WorldDirectories;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.util.point.Point2i;

public class SelectionData
implements Serializable {
    private final Selection selection;
    private Point2i min;
    private Point2i max;
    private final WorldDirectories world;

    public SelectionData(Selection selection, WorldDirectories world) {
        this.selection = selection;
        this.world = world;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public boolean isInverted() {
        return this.selection.inverted;
    }

    public Point2i getMin() {
        if (this.min == null) {
            this.calculateMinMax();
        }
        return this.min;
    }

    public Point2i getMax() {
        if (this.max == null) {
            this.calculateMinMax();
        }
        return this.max;
    }

    public long getWidth() {
        if (this.min == null || this.max == null) {
            this.calculateMinMax();
        }
        return Math.abs((long)this.max.getX() - (long)this.min.getX()) + 1L;
    }

    public long getHeight() {
        if (this.min == null || this.max == null) {
            this.calculateMinMax();
        }
        return Math.abs((long)this.max.getZ() - (long)this.min.getZ()) + 1L;
    }

    public int size() {
        return this.selection.size();
    }

    public WorldDirectories getWorld() {
        return this.world;
    }

    protected void calculateMinMax() {
        int minChunkX = 31;
        int minChunkZ = 31;
        int maxChunkX = 0;
        int maxChunkZ = 0;
        int minRegionX = Integer.MAX_VALUE;
        int minRegionZ = Integer.MAX_VALUE;
        int maxRegionX = Integer.MIN_VALUE;
        int maxRegionZ = Integer.MIN_VALUE;
        for (Long2ObjectMap.Entry entry : this.selection.selection.long2ObjectEntrySet()) {
            Point2i region = new Point2i(entry.getLongKey());
            if (region.getX() <= minRegionX) {
                if (region.getX() < minRegionX) {
                    minRegionX = region.getX();
                    minChunkX = 31;
                }
                int n = minChunkX = entry.getValue() == null ? 0 : ((ChunkSet)entry.getValue()).getMinX(minChunkX);
            }
            if (region.getX() >= maxRegionX) {
                if (region.getX() > maxRegionX) {
                    maxRegionX = region.getX();
                    maxChunkX = 0;
                }
                int n = maxChunkX = entry.getValue() == null ? 31 : ((ChunkSet)entry.getValue()).getMaxX(maxChunkX);
            }
            if (region.getZ() <= minRegionZ) {
                if (region.getZ() < minRegionZ) {
                    minRegionZ = region.getZ();
                    minChunkZ = 31;
                }
                int n = minChunkZ = entry.getValue() == null ? 0 : ((ChunkSet)entry.getValue()).getMinZ(minChunkZ);
            }
            if (region.getZ() < maxRegionZ) continue;
            if (region.getZ() > maxRegionZ) {
                maxRegionZ = region.getZ();
                maxChunkZ = 0;
            }
            maxChunkZ = entry.getValue() == null ? 31 : ((ChunkSet)entry.getValue()).getMaxZ(maxChunkZ);
        }
        this.min = new Point2i(minRegionX, minRegionZ).regionToChunk().add(minChunkX, minChunkZ);
        this.max = new Point2i(maxRegionX, maxRegionZ).regionToChunk().add(maxChunkX, maxChunkZ);
    }

    public String toString() {
        return String.format("SelectionData{min: %s, max: %s, width: %d, height: %d}", this.min, this.max, this.getWidth(), this.getHeight());
    }
}

