/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.selection;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.WorldDirectories;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.util.point.Point2i;

public class Selection
implements Serializable,
Iterable<Long2ObjectMap.Entry<ChunkSet>> {
    protected Long2ObjectOpenHashMap<ChunkSet> selection;
    protected boolean inverted;

    public Selection() {
        this.selection = new Long2ObjectOpenHashMap();
        this.inverted = false;
    }

    protected Selection(Long2ObjectOpenHashMap<ChunkSet> selection, boolean inverted) {
        this.selection = selection;
        this.inverted = inverted;
    }

    public static Selection readFromFile(File csvFile) throws IOException {
        Long2ObjectOpenHashMap<ChunkSet> sel = new Long2ObjectOpenHashMap<ChunkSet>();
        Selection selection = new Selection(sel, false);
        boolean inverted = false;
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
            String line;
            int num = 0;
            while ((line = br.readLine()) != null) {
                if (++num == 1 && "inverted".equals(line)) {
                    inverted = true;
                    continue;
                }
                String[] elements = line.split(";");
                if (elements.length != 2 && elements.length != 4) {
                    throw Selection.ioException("invalid region or chunk coordinate format in line %d", num);
                }
                Integer x = Selection.parseInt(elements[0]);
                Integer z = Selection.parseInt(elements[1]);
                if (x == null || z == null) {
                    throw Selection.ioException("failed to read region coordinates in line %d", num);
                }
                Point2i region = new Point2i(x, z);
                if (elements.length == 4) {
                    Integer cx = Selection.parseInt(elements[2]);
                    Integer cz = Selection.parseInt(elements[3]);
                    if (cx == null || cz == null) {
                        throw Selection.ioException("failed to read chunk coordinates in line %d", num);
                    }
                    Point2i chunk = new Point2i(cx, cz);
                    if (!chunk.chunkToRegion().equals(region)) {
                        throw Selection.ioException("chunk %s is not in region %s in line %d", chunk, region, num);
                    }
                    selection.addChunk(chunk);
                    continue;
                }
                selection.addRegion(region.asLong());
            }
        }
        selection.setInverted(inverted);
        return selection;
    }

    public void saveToFile(File csvFile) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(csvFile));){
            if (this.inverted) {
                bw.write("inverted\n");
            }
            for (Long2ObjectMap.Entry entry : this.selection.long2ObjectEntrySet()) {
                Point2i region = new Point2i(entry.getLongKey());
                if (entry.getValue() == null) {
                    Selection.writePoint(bw, region);
                    bw.write(10);
                    continue;
                }
                IntIterator intIterator = ((ChunkSet)entry.getValue()).iterator();
                while (intIterator.hasNext()) {
                    int i = (Integer)intIterator.next();
                    Selection.writePoint(bw, region);
                    bw.write(59);
                    Point2i c = new Point2i(i).add(region.regionToChunk());
                    Selection.writePoint(bw, c);
                    bw.write(10);
                }
            }
        }
    }

    public String saveToString() {
        StringBuilder sb = new StringBuilder();
        if (this.inverted) {
            sb.append("inverted\n");
        }
        for (Long2ObjectMap.Entry entry : this.selection.long2ObjectEntrySet()) {
            Point2i region = new Point2i(entry.getLongKey());
            if (entry.getValue() == null) {
                sb.append(Selection.writePoint(region));
                sb.append('\n');
                continue;
            }
            IntIterator intIterator = ((ChunkSet)entry.getValue()).iterator();
            while (intIterator.hasNext()) {
                int i = (Integer)intIterator.next();
                sb.append(Selection.writePoint(region));
                sb.append(';');
                Point2i c = new Point2i(i).add(region.regionToChunk());
                sb.append(Selection.writePoint(c));
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    private static void writePoint(BufferedWriter bw, Point2i p) throws IOException {
        bw.write(Integer.toString(p.getX()));
        bw.write(59);
        bw.write(Integer.toString(p.getZ()));
    }

    private static String writePoint(Point2i p) {
        return p.getX() + ";" + p.getZ();
    }

    private static IOException ioException(String msg, Object ... format) {
        return new IOException(String.format(msg, format));
    }

    private static Integer parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public boolean isChunkSelected(int x, int z) {
        Point2i pChunk = new Point2i(x, z);
        Point2i pRegion = pChunk.chunkToRegion();
        return this.isChunkSelected(pRegion.asLong(), pChunk.asChunkIndex());
    }

    public boolean isChunkSelected(Point2i chunk) {
        return this.isChunkSelected(chunk.chunkToRegion().asLong(), chunk.asChunkIndex());
    }

    protected boolean isChunkSelected(long region, short chunk) {
        if (this.selection.containsKey(region)) {
            ChunkSet chunks = this.selection.get(region);
            return (chunks == null || chunks.get(chunk)) != this.inverted;
        }
        return this.inverted;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public boolean isEmpty() {
        return !this.inverted && this.selection.isEmpty();
    }

    public int size() {
        return this.inverted ? Integer.MAX_VALUE : this.selection.size();
    }

    public int count() {
        int result = 0;
        for (Long2ObjectMap.Entry entry : this.selection.long2ObjectEntrySet()) {
            result += entry.getValue() == null ? 1024 : (int)((ChunkSet)entry.getValue()).size();
        }
        return result;
    }

    public Point2i one() {
        if (this.inverted || this.selection.isEmpty()) {
            return new Point2i();
        }
        return new Point2i(((Long2ObjectMap.Entry)this.selection.long2ObjectEntrySet().iterator().next()).getLongKey());
    }

    public void addChunk(Point2i chunk) {
        this.addChunk(chunk.chunkToRegion().asLong(), chunk.asChunkIndex());
    }

    public Selection getTrueSelection(WorldDirectories world) {
        if (!this.inverted) {
            return this;
        }
        Long2ObjectOpenHashMap<ChunkSet> selection = new Long2ObjectOpenHashMap<ChunkSet>();
        LongOpenHashSet allRegions = FileHelper.parseAllMCAFileNames(world.getRegion());
        LongOpenHashSet allPoi = FileHelper.parseAllMCAFileNames(world.getPoi());
        LongOpenHashSet allEntities = FileHelper.parseAllMCAFileNames(world.getEntities());
        allRegions.addAll(allPoi);
        allRegions.addAll(allEntities);
        LongIterator longIterator = allRegions.iterator();
        while (longIterator.hasNext()) {
            long region = (Long)longIterator.next();
            if (!this.selection.containsKey(region)) {
                selection.put(region, (ChunkSet)null);
                continue;
            }
            ChunkSet chunks = this.selection.get(region);
            if (chunks == null) continue;
            selection.put(region, Selection.invertChunks(chunks));
        }
        return new Selection(selection, false);
    }

    public void addChunk(long chunkCoords) {
        Point2i chunk = new Point2i(chunkCoords);
        this.addChunk(chunk.chunkToRegion().asLong(), chunk.asChunkIndex());
    }

    public void setSelection(Selection other) {
        this.selection = other.selection;
        this.inverted = other.inverted;
    }

    protected void addChunk(long region, short chunk) {
        if (this.inverted) {
            if (this.selection.containsKey(region)) {
                ChunkSet chunks = this.selection.get(region);
                if (chunks == null) {
                    chunks = new ChunkSet();
                    chunks.fill();
                    chunks.clear(chunk);
                    this.selection.put(region, chunks);
                } else {
                    chunks.clear(chunk);
                    if (chunks.isEmpty()) {
                        this.selection.remove(region);
                    }
                }
            }
        } else if (this.selection.containsKey(region)) {
            ChunkSet chunks = this.selection.get(region);
            if (chunks != null) {
                chunks.set(chunk);
                if (chunks.size() == 1024) {
                    this.selection.put(region, (ChunkSet)null);
                }
            }
        } else {
            ChunkSet chunks = new ChunkSet();
            chunks.set(chunk);
            this.selection.put(region, chunks);
        }
    }

    public int addRegion(long region) {
        if (this.inverted) {
            if (this.selection.containsKey(region)) {
                ChunkSet chunks = this.selection.get(region);
                this.selection.remove(region);
                if (chunks == null) {
                    return 1024;
                }
                return chunks.size();
            }
            return 0;
        }
        if (this.selection.containsKey(region)) {
            ChunkSet chunks = this.selection.get(region);
            if (chunks == null) {
                return 0;
            }
            this.selection.put(region, (ChunkSet)null);
            return 1024 - chunks.size();
        }
        this.selection.put(region, (ChunkSet)null);
        return 1024;
    }

    public boolean isRegionSelected(long region) {
        if (this.inverted) {
            return !this.selection.containsKey(region);
        }
        return this.selection.containsKey(region) && this.selection.get(region) == null;
    }

    public boolean isAnyChunkInRegionSelected(long region) {
        if (this.inverted) {
            return !this.selection.containsKey(region) || this.selection.get(region) != null;
        }
        return this.selection.containsKey(region);
    }

    public boolean isAnyChunkInRegionSelected(Point2i region) {
        return this.isAnyChunkInRegionSelected(region.asLong());
    }

    public ChunkSet getSelectedChunks(Point2i region) {
        if (this.inverted) {
            if (this.selection.containsKey(region.asLong())) {
                return Selection.invertChunks(this.selection.get(region.asLong())).immutable();
            }
            return null;
        }
        if (this.selection.containsKey(region.asLong())) {
            ChunkSet result = this.selection.get(region.asLong());
            if (result == null) {
                return null;
            }
            return result.immutable();
        }
        return ChunkSet.EMPTY_SET;
    }

    public void clear() {
        this.selection = new Long2ObjectOpenHashMap();
        this.inverted = false;
    }

    public int removeRegion(long region) {
        if (this.inverted) {
            if (this.selection.containsKey(region)) {
                ChunkSet chunks = this.selection.get(region);
                if (chunks == null) {
                    return 0;
                }
                this.selection.put(region, (ChunkSet)null);
                return 1024 - chunks.size();
            }
            this.selection.put(region, (ChunkSet)null);
            return 1024;
        }
        if (this.selection.containsKey(region)) {
            ChunkSet chunks = this.selection.get(region);
            this.selection.remove(region);
            if (chunks == null) {
                return 1024;
            }
            return chunks.size();
        }
        return 0;
    }

    public void removeChunk(Point2i chunk) {
        long region = chunk.chunkToRegion().asLong();
        if (this.inverted) {
            if (this.selection.containsKey(region)) {
                ChunkSet chunks = this.selection.get(region);
                if (chunks != null) {
                    chunks.set(chunk.asChunkIndex());
                    if (chunks.size() == 1024) {
                        this.selection.put(region, (ChunkSet)null);
                    }
                }
            } else {
                ChunkSet chunks = new ChunkSet();
                chunks.set(chunk.asChunkIndex());
                this.selection.put(region, chunks);
            }
        } else if (this.selection.containsKey(region)) {
            ChunkSet chunks = this.selection.get(region);
            if (chunks == null) {
                chunks = new ChunkSet();
                chunks.fill();
                chunks.clear(chunk.asChunkIndex());
                this.selection.put(region, chunks);
            } else {
                chunks.clear(chunk.asChunkIndex());
                if (chunks.isEmpty()) {
                    this.selection.remove(region);
                }
            }
        }
    }

    public ChunkSet getSelectedChunksIgnoreInverted(Point2i region) {
        if (this.selection.containsKey(region.asLong())) {
            return this.selection.get(region.asLong());
        }
        return ChunkSet.EMPTY_SET;
    }

    public void invertAll() {
        for (Long2ObjectMap.Entry entry : this.selection.long2ObjectEntrySet()) {
            if (entry.getValue() == null) {
                this.selection.remove(entry.getLongKey());
                continue;
            }
            this.selection.put(entry.getLongKey(), ((ChunkSet)entry.getValue()).flip());
        }
    }

    private static ChunkSet invertChunks(ChunkSet chunks) {
        if (chunks == null) {
            return new ChunkSet();
        }
        ChunkSet result = new ChunkSet();
        for (int i = 0; i < 1024; i = (int)((short)(i + 1))) {
            if (chunks.get(i)) continue;
            result.set(i);
        }
        return result;
    }

    public void merge(Selection other) {
        if (!this.inverted && !other.inverted) {
            for (Long2ObjectMap.Entry entry : other.selection.long2ObjectEntrySet()) {
                long r = entry.getLongKey();
                if (this.selection.containsKey(r)) {
                    this.selection.put(r, Selection.add(this.selection.get(r), (ChunkSet)entry.getValue()));
                    continue;
                }
                this.selection.put(r, Selection.cloneValue((ChunkSet)entry.getValue()));
            }
        } else if (this.inverted && !other.inverted) {
            for (Long2ObjectMap.Entry entry : other.selection.long2ObjectEntrySet()) {
                long r = entry.getLongKey();
                if (!this.selection.containsKey(r)) continue;
                ChunkSet result = Selection.subtract(this.selection.get(r), (ChunkSet)entry.getValue());
                if (result.isEmpty()) {
                    this.selection.remove(r);
                    continue;
                }
                this.selection.put(r, result);
            }
        } else if (!this.inverted) {
            long r;
            for (Long2ObjectMap.Entry entry : other.selection.long2ObjectEntrySet()) {
                r = entry.getLongKey();
                if (this.selection.containsKey(r)) {
                    ChunkSet result = Selection.subtract(Selection.cloneValue((ChunkSet)entry.getValue()), this.selection.get(r));
                    if (result.isEmpty()) {
                        this.selection.remove(r);
                        continue;
                    }
                    this.selection.put(r, result);
                    continue;
                }
                this.selection.put(r, Selection.cloneValue((ChunkSet)entry.getValue()));
            }
            for (Long2ObjectMap.Entry entry : this.selection.long2ObjectEntrySet()) {
                r = entry.getLongKey();
                if (other.selection.containsKey(r)) continue;
                this.selection.remove(r);
            }
            this.inverted = true;
        } else {
            for (Long2ObjectMap.Entry entry : this.selection.long2ObjectEntrySet()) {
                long r = entry.getLongKey();
                if (!other.selection.containsKey(r)) {
                    this.selection.remove(r);
                    continue;
                }
                ChunkSet union = Selection.union((ChunkSet)entry.getValue(), other.selection.get(r));
                if (union != null && union.isEmpty()) {
                    this.selection.remove(r);
                    continue;
                }
                this.selection.put(r, union);
            }
        }
    }

    private static ChunkSet cloneValue(ChunkSet v) {
        return v == null ? null : v.clone();
    }

    private static ChunkSet union(ChunkSet a, ChunkSet b) {
        if (a == null) {
            return Selection.cloneValue(b);
        }
        if (b == null) {
            return a;
        }
        a.forEach(l -> {
            if (!b.get(l)) {
                a.clear(l);
            }
        });
        b.forEach(l -> {
            if (!a.get(l)) {
                a.clear(l);
            }
        });
        return a;
    }

    private static ChunkSet subtract(ChunkSet source, ChunkSet target) {
        if (source == null) {
            return Selection.invertChunks(target);
        }
        if (target == null) {
            return new ChunkSet();
        }
        source.removeIf(target::get);
        return source;
    }

    private static ChunkSet add(ChunkSet source, ChunkSet target) {
        if (source == null || target == null) {
            return null;
        }
        source.or(target);
        return source.size() == 1024 ? null : source;
    }

    public void addAll(LongOpenHashSet entries) {
        LongIterator longIterator = entries.iterator();
        while (longIterator.hasNext()) {
            long entry = (Long)longIterator.next();
            this.addChunk(entry);
        }
    }

    public void addAll(Point2i region, ChunkSet chunks) {
        long r = region.asLong();
        if (this.inverted) {
            if (chunks == null || chunks.size() == 1024) {
                this.selection.remove(r);
            } else if (this.selection.containsKey(r)) {
                ChunkSet existing = this.selection.get(r);
                if (existing != null) {
                    existing.otherNotAnd(chunks);
                    if (existing.isEmpty()) {
                        this.selection.remove(r);
                    }
                } else {
                    ChunkSet inverted = Selection.invertChunks(chunks);
                    if (!inverted.isEmpty()) {
                        this.selection.put(r, inverted);
                    }
                }
            }
        } else if (chunks == null || chunks.size() == 1024) {
            this.selection.put(r, (ChunkSet)null);
        } else if (this.selection.containsKey(r)) {
            ChunkSet existing = this.selection.get(r);
            if (existing != null) {
                existing.or(chunks);
                if (existing.size() == 1024) {
                    this.selection.put(r, (ChunkSet)null);
                }
            }
        } else if (!chunks.isEmpty()) {
            this.selection.put(r, chunks);
        }
    }

    public void addRadius(int radius, Selection bounds) {
        for (Long2ObjectMap.Entry entry : this.selection.long2ObjectEntrySet()) {
            if (entry.getValue() == null) {
                Point2i center;
                for (int x = 0; x < 32; ++x) {
                    center = new Point2i(x, 0).add(new Point2i(entry.getLongKey()).regionToChunk());
                    this.addRadius(center, radius, bounds);
                    center = new Point2i(x, 31).add(new Point2i(entry.getLongKey()).regionToChunk());
                    this.addRadius(center, radius, bounds);
                }
                for (int z = 1; z < 31; ++z) {
                    center = new Point2i(0, z).add(new Point2i(entry.getLongKey()).regionToChunk());
                    this.addRadius(center, radius, bounds);
                    center = new Point2i(31, z).add(new Point2i(entry.getLongKey()).regionToChunk());
                    this.addRadius(center, radius, bounds);
                }
                continue;
            }
            IntIterator intIterator = ((ChunkSet)entry.getValue()).clone().iterator();
            while (intIterator.hasNext()) {
                int i = (Integer)intIterator.next();
                Point2i center = new Point2i(i).add(new Point2i(entry.getLongKey()).regionToChunk());
                this.addRadius(center, radius, bounds);
            }
        }
    }

    private void addRadius(Point2i center, int radius, Selection bounds) {
        Point2i min = center.sub(radius);
        Point2i max = center.add(radius);
        double radiusSquared = ((double)radius + 0.3) * ((double)radius + 0.3);
        for (int x = min.getX(); x <= max.getX(); ++x) {
            for (int z = min.getZ(); z <= max.getZ(); ++z) {
                int distX = x - center.getX();
                int distZ = z - center.getZ();
                if (bounds != null && !bounds.isChunkSelected(x, z) || !((double)(distX * distX + distZ * distZ) <= radiusSquared)) continue;
                this.addChunk(new Point2i(x, z));
            }
        }
    }

    @Override
    public Iterator<Long2ObjectMap.Entry<ChunkSet>> iterator() {
        return this.selection.long2ObjectEntrySet().iterator();
    }

    public Stats getStats() {
        int totalSelectedChunks = 0;
        int totalChunksOfPartiallySelectedRegions = 0;
        int partiallySelectedRegions = 0;
        int fullySelectedRegions = 0;
        int below64 = 0;
        int below128 = 0;
        int below256 = 0;
        int below512 = 0;
        for (Long2ObjectMap.Entry entry : this.selection.long2ObjectEntrySet()) {
            if (entry.getValue() == null) {
                totalSelectedChunks += 1024;
                ++fullySelectedRegions;
                continue;
            }
            short size = ((ChunkSet)entry.getValue()).size();
            totalSelectedChunks += size;
            totalChunksOfPartiallySelectedRegions += size;
            ++partiallySelectedRegions;
            if (size < 512) {
                ++below512;
            }
            if (size < 256) {
                ++below256;
            }
            if (size < 128) {
                ++below128;
            }
            if (size >= 64) continue;
            ++below64;
        }
        return new Stats(totalSelectedChunks, totalChunksOfPartiallySelectedRegions, partiallySelectedRegions, fullySelectedRegions, below64, below128, below256, below512);
    }

    public String toString() {
        return this.getStats().toString();
    }

    public record Stats(int totalSelectedChunks, int totalChunksOfPartiallySelectedRegions, int partiallySelectedRegions, int fullySelectedRegions, int below64, int below128, int below256, int below512) {
    }
}

