/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.overlay.overlays;

import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.overlay.Overlay;
import net.querz.mcaselector.overlay.OverlayType;
import net.querz.mcaselector.text.TextHelper;

public class TimestampOverlay
extends Overlay {
    private String minTimestamp;
    private String maxTimestamp;

    public TimestampOverlay() {
        super(OverlayType.TIMESTAMP);
    }

    @Override
    public int parseValue(ChunkData data) {
        if (data.region() == null) {
            return 0;
        }
        return data.region().getTimestamp();
    }

    @Override
    public String name() {
        return "Timestamp";
    }

    @Override
    public String minString() {
        return this.minTimestamp == null ? super.minString() : this.minTimestamp;
    }

    @Override
    public String maxString() {
        return this.minTimestamp == null ? super.maxString() : this.maxTimestamp;
    }

    @Override
    public boolean setMin(String raw) {
        this.setRawMin(raw);
        this.minTimestamp = null;
        if (raw == null || raw.isEmpty()) {
            return this.setMinInt(null);
        }
        try {
            return this.setMinInt(Integer.parseInt(raw));
        }
        catch (NumberFormatException ex) {
            try {
                int timestamp = TextHelper.parseTimestamp(raw);
                boolean res = this.setMinInt(timestamp);
                if (res) {
                    this.minTimestamp = raw;
                }
                return res;
            }
            catch (IllegalArgumentException ex2) {
                return this.setMinInt(null);
            }
        }
    }

    @Override
    public boolean setMax(String raw) {
        this.setRawMax(raw);
        this.maxTimestamp = null;
        if (raw == null || raw.isEmpty()) {
            return this.setMaxInt(null);
        }
        try {
            return this.setMaxInt(Integer.parseInt(raw));
        }
        catch (NumberFormatException ex) {
            try {
                int timestamp = TextHelper.parseTimestamp(raw);
                boolean res = this.setMaxInt(timestamp);
                if (res) {
                    this.maxTimestamp = raw;
                }
                return res;
            }
            catch (IllegalArgumentException ex2) {
                return this.setMaxInt(null);
            }
        }
    }
}

