/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.overlay.overlays;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.querz.mcaselector.config.adapter.OverlayAdapter;
import net.querz.mcaselector.io.mca.Chunk;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.overlay.AmountOverlay;
import net.querz.mcaselector.overlay.OverlayType;
import net.querz.mcaselector.text.TextHelper;
import net.querz.mcaselector.util.exception.ParseException;
import net.querz.nbt.CollectionTag;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.NumberTag;
import net.querz.nbt.Tag;

public class PathOverlay
extends AmountOverlay {
    private final List<Node> path = new ArrayList<Node>();
    private String root;
    private boolean size;
    private final Pattern indexPattern = Pattern.compile("^\\[(?<index>\\d+)]$");

    public PathOverlay() {
        super(OverlayType.PATH);
        this.setMultiValues(new String[0]);
    }

    @Override
    public int parseValue(ChunkData data) {
        return switch (this.root) {
            case "region" -> this.getValue(data.region());
            case "poi" -> this.getValue(data.poi());
            case "entities" -> this.getValue(data.entities());
            default -> 0;
        };
    }

    private int getValue(Chunk chunk) {
        if (chunk == null || chunk.getData() == null) {
            return 0;
        }
        Tag current = chunk.getData();
        for (Node node : this.path) {
            if (node instanceof Name) {
                Name name = (Name)node;
                if (current instanceof CompoundTag) {
                    CompoundTag t = current;
                    current = t.get(name.name);
                    continue;
                }
                return 0;
            }
            if (node instanceof Index) {
                Index index = (Index)node;
                if (current instanceof ListTag) {
                    ListTag l = (ListTag)current;
                    current = l.get(index.index);
                    continue;
                }
                return 0;
            }
            return 0;
        }
        if (current instanceof NumberTag) {
            NumberTag number = (NumberTag)current;
            if (!this.size) {
                return number.asInt();
            }
        }
        if (current instanceof CompoundTag) {
            CompoundTag compound = current;
            if (this.size) {
                return compound.size();
            }
        }
        if (current instanceof CollectionTag) {
            CollectionTag collection = (CollectionTag)current;
            if (this.size) {
                return collection.size();
            }
        }
        return 0;
    }

    @Override
    public String name() {
        return "Custom";
    }

    @Override
    public boolean setMultiValuesString(String raw) {
        String[] elements;
        this.path.clear();
        this.size = false;
        this.root = "";
        if (raw == null) {
            this.setMultiValues(new String[0]);
            return false;
        }
        this.setRawMultiValues(raw);
        try {
            elements = TextHelper.splitWithEscaping(raw, '/', '\\');
            this.setMultiValues(elements);
        }
        catch (ParseException ex) {
            this.setMultiValues(new String[0]);
            return false;
        }
        if (elements.length < 2) {
            this.setMultiValues(new String[0]);
            return false;
        }
        this.root = elements[0];
        for (int i = 1; i < elements.length - 1; ++i) {
            if (this.parseElement(elements[i])) continue;
            return false;
        }
        try {
            String[] last = TextHelper.splitWithEscaping(elements[elements.length - 1], '.', '\\');
            if (last.length > 1 && last[last.length - 1].equals("size")) {
                this.size = true;
                this.parseElement(elements[elements.length - 1].substring(0, elements[elements.length - 1].length() - 5));
            } else {
                this.parseElement(elements[elements.length - 1]);
            }
        }
        catch (ParseException e) {
            this.setMultiValues(new String[0]);
            return false;
        }
        return true;
    }

    private boolean parseElement(String element) {
        Matcher m = this.indexPattern.matcher(element);
        if (m.find()) {
            String g = m.group("index");
            try {
                int index = Integer.parseInt(g);
                this.path.add(new Index(index));
            }
            catch (NumberFormatException ex) {
                this.setMultiValues(new String[0]);
                return false;
            }
        } else {
            this.path.add(new Name(element));
        }
        return true;
    }

    @Override
    public String toString() {
        return "root: " + this.root + ", path: " + String.valueOf(this.path) + ", size: " + this.size;
    }

    @Override
    public void writeCustomJSON(JsonObject obj) {
        JsonArray path = new JsonArray();
        this.path.forEach(n -> path.add(n.toString()));
        obj.add("path", path);
        obj.addProperty("root", this.root);
        obj.addProperty("size", this.size);
    }

    @Override
    public void readCustomJSON(JsonObject obj) {
        JsonArray p = OverlayAdapter.get(obj, "path", null, JsonElement::getAsJsonArray);
        if (p != null) {
            p.forEach(e -> this.parseElement(e.getAsString()));
        }
        this.root = OverlayAdapter.get(obj, "root", "", JsonElement::getAsString);
        this.size = OverlayAdapter.get(obj, "size", false, JsonElement::getAsBoolean);
    }

    private static abstract class Node {
        private Node() {
        }
    }

    private static class Name
    extends Node {
        String name;

        Name(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class Index
    extends Node {
        int index;

        Index(int index) {
            this.index = index;
        }

        public String toString() {
            return "[" + this.index + "]";
        }
    }
}

