/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.overlay;

import net.querz.mcaselector.overlay.Overlay;
import net.querz.mcaselector.overlay.OverlayType;
import net.querz.mcaselector.util.exception.ParseException;

public class OverlayParser {
    private final String type;
    private final String min;
    private final String max;
    private final String data;
    private final float minHue;
    private final float maxHue;

    public OverlayParser(String type, String min, String max, String data, float minHue, float maxHue) {
        this.type = type;
        this.min = min;
        this.max = max;
        this.data = data;
        this.minHue = minHue;
        this.maxHue = maxHue;
    }

    public Overlay parse() throws ParseException {
        OverlayType t = OverlayType.getByName(this.type);
        if (t == null) {
            throw new ParseException("invalid overlay type \"" + this.type + "\"");
        }
        if (this.min == null) {
            throw new ParseException("missing mandatory minimum value for \"" + this.type + "\" overlay");
        }
        if (this.max == null) {
            throw new ParseException("missing mandatory maximum value for \"" + this.type + "\" overlay");
        }
        Overlay o = t.instance();
        o.setMin(this.min);
        o.setMax(this.max);
        o.setMultiValuesString(this.data);
        if (!o.isValid()) {
            throw new ParseException("failed to parse values for " + this.type + " overlay");
        }
        o.setMinHue(this.minHue);
        o.setMaxHue(this.maxHue);
        return o;
    }
}

