/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.overlay;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.UUID;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.overlay.OverlayType;

public abstract class Overlay
implements Cloneable {
    private UUID id;
    private final OverlayType type;
    private boolean active;
    private Integer min;
    private Integer max;
    private String rawMin;
    private String rawMax;
    private String[] multiValues = null;
    private String rawMultiValues;
    private String rawMultiValuesShort;
    private float minHue = 0.6666667f;
    private float maxHue = 0.0f;
    private transient String multiValuesID = "";

    public Overlay(OverlayType type) {
        this.type = type;
        this.id = UUID.randomUUID();
    }

    public OverlayType getType() {
        return this.type;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public Integer min() {
        return this.min;
    }

    public Integer max() {
        return this.max;
    }

    public String minString() {
        return this.min == null ? "" : "" + this.min;
    }

    public String maxString() {
        return this.max == null ? "" : "" + this.max;
    }

    public boolean isValid() {
        return this.min != null && this.max != null && this.min < this.max;
    }

    public String getRawMin() {
        return this.rawMin;
    }

    public String getRawMax() {
        return this.rawMax;
    }

    public String getRawMultiValues() {
        return this.rawMultiValues;
    }

    public String getShortMultiValues() {
        if (this.rawMultiValuesShort != null) {
            return this.rawMultiValuesShort;
        }
        if (this.rawMultiValues == null) {
            return null;
        }
        if (this.rawMultiValues.length() > 50) {
            this.rawMultiValuesShort = this.rawMultiValues.substring(0, 50) + "...";
            return this.rawMultiValuesShort;
        }
        this.rawMultiValuesShort = this.rawMultiValues;
        return this.rawMultiValuesShort;
    }

    public void setRawMin(String rawMin) {
        this.rawMin = rawMin;
    }

    public void setRawMax(String rawMax) {
        this.rawMax = rawMax;
    }

    public void setRawMultiValues(String rawMultiValues) {
        this.rawMultiValues = rawMultiValues;
        this.rawMultiValuesShort = null;
    }

    public boolean setMinInt(Integer min) {
        this.min = min;
        return this.isValid();
    }

    public boolean setMaxInt(Integer max) {
        this.max = max;
        return this.isValid();
    }

    public float getMinHue() {
        return this.minHue;
    }

    public float getMaxHue() {
        return this.maxHue;
    }

    public void setMinHue(float minHue) {
        this.minHue = minHue;
    }

    public void setMaxHue(float maxHue) {
        this.maxHue = maxHue;
    }

    public void setMultiValues(String[] multiValues) {
        this.multiValues = multiValues;
        this.multiValuesID = multiValues == null ? "" : UUID.nameUUIDFromBytes(String.join((CharSequence)"", multiValues).getBytes()).toString().replace("-", "");
    }

    public String getMultiValuesID() {
        return this.multiValuesID;
    }

    public abstract int parseValue(ChunkData var1);

    public abstract String name();

    public abstract boolean setMin(String var1);

    public abstract boolean setMax(String var1);

    public boolean setMultiValuesString(String raw) {
        return true;
    }

    public String[] multiValues() {
        return this.multiValues;
    }

    public void writeCustomJSON(JsonObject obj) {
    }

    public void readCustomJSON(JsonObject obj) {
    }

    public String toString() {
        return String.format("{min=%s, max=%s, active=%s, valid=%s, minHue=%f, maxHue=%f}", this.minString(), this.maxString(), this.active, this.isValid(), Float.valueOf(this.minHue), Float.valueOf(this.maxHue));
    }

    public boolean equals(Object other) {
        if (!(other instanceof Overlay)) {
            return false;
        }
        Overlay o = (Overlay)other;
        return this.type == o.type && (this.min == null && o.min == null || this.min != null && o.min != null && this.min.intValue() == o.min.intValue()) && (this.max == null && o.max == null || this.max != null && o.max != null && this.max.intValue() == o.max.intValue() && this.active == o.active && this.minHue == o.minHue && this.maxHue == o.maxHue && Arrays.equals(this.multiValues(), o.multiValues()));
    }

    public boolean same(Object other) {
        if (!(other instanceof Overlay)) {
            return false;
        }
        Overlay o = (Overlay)other;
        return this.id.equals(o.id);
    }

    public Overlay clone() {
        Overlay clone = this.type.instance();
        clone.id = this.id;
        clone.min = this.min;
        clone.max = this.max;
        clone.multiValues = this.multiValues == null ? null : Arrays.copyOf(this.multiValues, this.multiValues.length);
        clone.rawMultiValues = this.rawMultiValues;
        clone.active = this.active;
        clone.rawMin = this.rawMin;
        clone.rawMax = this.rawMax;
        clone.minHue = this.minHue;
        clone.maxHue = this.maxHue;
        clone.multiValuesID = this.multiValuesID;
        return clone;
    }
}

