/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.logging;

import java.util.Objects;

public class MappableExceptionInfo {
    private final Class<? extends Throwable> clazz;
    private final int line;
    private final String file;
    private int hashCode;

    public MappableExceptionInfo(Throwable t) {
        this.clazz = t.getClass();
        if (t.getCause() == null) {
            if (t.getStackTrace().length > 0) {
                StackTraceElement element = t.getStackTrace()[0];
                this.line = element.getLineNumber();
                this.file = element.getFileName();
            } else {
                this.line = -1;
                this.file = null;
            }
        } else {
            Throwable c = t;
            while (c.getCause() != null) {
                c = c.getCause();
            }
            if (c.getStackTrace().length > 0) {
                StackTraceElement element = c.getStackTrace()[0];
                this.line = element.getLineNumber();
                this.file = element.getFileName();
            } else {
                this.line = -1;
                this.file = null;
            }
        }
    }

    protected String getExceptionOneLine(Throwable t) {
        if (t.getStackTrace().length == 0) {
            return t.getMessage();
        }
        StackTraceElement element = t.getStackTrace()[0];
        String trace = String.format("%s: %s %s %s L%d", t.getMessage(), element.getFileName(), element.getClassName(), element.getMethodName(), element.getLineNumber());
        if (t.getCause() != null) {
            Throwable c = t;
            while (c.getCause() != null) {
                c = c.getCause();
            }
            StackTraceElement cause = c.getStackTrace()[0];
            return String.format("%s, cause: %s: %s %s %s L%s", trace, c.getMessage(), cause.getFileName(), cause.getClassName(), cause.getMethodName(), cause.getLineNumber());
        }
        return trace;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.clazz, this.line, this.file);
            return this.hashCode;
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MappableExceptionInfo)) {
            return false;
        }
        MappableExceptionInfo ex = (MappableExceptionInfo)other;
        return this.clazz == ex.clazz && this.line == ex.line && (this.file == null && ex.file == null || this.file != null && this.file.equals(ex.file));
    }
}

