/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.logging;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.querz.mcaselector.logging.ExceptionInfo;
import net.querz.mcaselector.logging.MappableExceptionInfo;
import net.querz.mcaselector.util.validation.ShutdownHooks;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

@Plugin(name="ExceptionBurstFilter", category="Core", elementType="filter", printObject=true)
public class ExceptionBurstFilter
extends AbstractFilter {
    private static final Logger LOGGER = LogManager.getLogger(ExceptionBurstFilter.class);
    private final Map<MappableExceptionInfo, ExceptionInfo> lastExceptions = new ConcurrentHashMap<MappableExceptionInfo, ExceptionInfo>();
    private static final int defaultDuration = 20000;
    private final int duration;
    private boolean running;

    private ExceptionBurstFilter(int duration) {
        super(Filter.Result.DENY, Filter.Result.ACCEPT);
        this.duration = duration;
        this.running = true;
        new Thread(this::repeatedFlush).start();
        ShutdownHooks.addShutdownHook(this::close);
    }

    @Override
    public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        if (t == null) {
            return Filter.Result.NEUTRAL;
        }
        MappableExceptionInfo i = new MappableExceptionInfo(t);
        if (this.lastExceptions.containsKey(i)) {
            this.lastExceptions.get(i).update();
            return Filter.Result.DENY;
        }
        this.lastExceptions.put(i, new ExceptionInfo(t));
        return Filter.Result.NEUTRAL;
    }

    @Override
    public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        if (t == null) {
            return Filter.Result.NEUTRAL;
        }
        MappableExceptionInfo i = new MappableExceptionInfo(t);
        if (this.lastExceptions.containsKey(i)) {
            this.lastExceptions.get(i).update();
            return Filter.Result.DENY;
        }
        this.lastExceptions.put(i, new ExceptionInfo(t));
        return Filter.Result.NEUTRAL;
    }

    @PluginFactory
    public static ExceptionBurstFilter createFilter(@PluginAttribute(value="duration") Integer duration) {
        int actualDuration = duration == null ? 20000 : duration;
        return new ExceptionBurstFilter(actualDuration);
    }

    private void repeatedFlush() {
        while (this.running) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                LOGGER.warn("failed repeated flush of ExceptionBurstFilter: {}", (Object)ex.getMessage());
            }
            long now = System.currentTimeMillis();
            this.lastExceptions.entrySet().removeIf(e -> {
                if (now - ((ExceptionInfo)e.getValue()).timestamp > (long)this.duration) {
                    ((ExceptionInfo)e.getValue()).log(LOGGER);
                    return true;
                }
                return false;
            });
        }
    }

    private void close() {
        this.running = false;
        for (Map.Entry<MappableExceptionInfo, ExceptionInfo> e : this.lastExceptions.entrySet()) {
            e.getValue().log(LOGGER);
        }
        this.lastExceptions.clear();
    }
}

