/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.mca;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.querz.mcaselector.changer.Field;
import net.querz.mcaselector.filter.Filter;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.io.mca.EntitiesChunk;
import net.querz.mcaselector.io.mca.EntitiesMCAFile;
import net.querz.mcaselector.io.mca.PoiChunk;
import net.querz.mcaselector.io.mca.PoiMCAFile;
import net.querz.mcaselector.io.mca.RegionChunk;
import net.querz.mcaselector.io.mca.RegionMCAFile;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.progress.Timer;
import net.querz.mcaselector.util.range.Range;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Region {
    private static final Logger LOGGER = LogManager.getLogger(Region.class);
    private RegionMCAFile region;
    private PoiMCAFile poi;
    private EntitiesMCAFile entities;
    private RegionDirectories directories;
    private Point2i location;

    public static Region loadRegion(RegionDirectories dirs) throws IOException {
        Region r = new Region();
        if (dirs.getRegion() != null) {
            r.loadRegion(dirs.getRegion());
        }
        if (dirs.getPoi() != null) {
            r.loadPoi(dirs.getPoi());
        }
        if (dirs.getEntities() != null) {
            r.loadEntities(dirs.getEntities());
        }
        r.location = dirs.getLocation();
        r.directories = dirs;
        return r;
    }

    public static Region loadRegionHeaders(RegionDirectories dirs) throws IOException {
        Region r = new Region();
        if (dirs.getRegion() != null && dirs.getRegion().length() >= 8192L) {
            r.region = new RegionMCAFile(dirs.getRegion());
            r.region.loadHeader();
        }
        if (dirs.getPoi() != null && dirs.getPoi().length() >= 8192L) {
            r.poi = new PoiMCAFile(dirs.getPoi());
            r.poi.loadHeader();
        }
        if (dirs.getEntities() != null && dirs.getEntities().length() >= 8192L) {
            r.entities = new EntitiesMCAFile(dirs.getEntities());
            r.entities.loadHeader();
        }
        r.directories = dirs;
        return r;
    }

    public static Region loadOrCreateEmptyRegion(RegionDirectories dirs) throws IOException {
        Region r = new Region();
        if (dirs.getRegion() != null) {
            if (dirs.getRegion().exists()) {
                r.loadRegion(dirs.getRegion());
            } else {
                r.region = new RegionMCAFile(dirs.getRegion());
            }
        }
        if (dirs.getPoi() != null) {
            if (dirs.getPoi().exists()) {
                r.loadPoi(dirs.getPoi());
            } else {
                r.poi = new PoiMCAFile(dirs.getPoi());
            }
        }
        if (dirs.getEntities() != null) {
            if (dirs.getEntities().exists()) {
                r.loadEntities(dirs.getEntities());
            } else {
                r.entities = new EntitiesMCAFile(dirs.getEntities());
            }
        }
        return r;
    }

    public void loadRegion(File src) throws IOException {
        this.region = new RegionMCAFile(src);
        this.region.load(false);
    }

    public void loadPoi(File src) throws IOException {
        this.poi = new PoiMCAFile(src);
        this.poi.load(false);
    }

    public void loadEntities(File src) throws IOException {
        this.entities = new EntitiesMCAFile(src);
        this.entities.load(false);
    }

    public RegionMCAFile getRegion() {
        return this.region;
    }

    public PoiMCAFile getPoi() {
        return this.poi;
    }

    public EntitiesMCAFile getEntities() {
        return this.entities;
    }

    public void setRegion(RegionMCAFile region) {
        this.region = region;
    }

    public void setPoi(PoiMCAFile poi) {
        this.poi = poi;
    }

    public void setEntities(EntitiesMCAFile entities) {
        this.entities = entities;
    }

    public boolean isEmpty() {
        boolean empty = true;
        if (this.region != null) {
            empty = this.region.isEmpty();
        }
        if (this.poi != null && empty) {
            empty = this.poi.isEmpty();
        }
        if (this.entities != null && empty) {
            empty = this.entities.isEmpty();
        }
        return empty;
    }

    public void setDirectories(RegionDirectories dirs) {
        if (this.region != null) {
            this.region.setFile(dirs.getRegion());
        }
        if (this.poi != null) {
            this.poi.setFile(dirs.getPoi());
        }
        if (this.entities != null) {
            this.entities.setFile(dirs.getEntities());
        }
    }

    public ChunkData getChunkDataAt(Point2i location, boolean selected) {
        RegionChunk regionChunk = null;
        PoiChunk poiChunk = null;
        EntitiesChunk entitiesChunk = null;
        if (this.region != null) {
            regionChunk = (RegionChunk)this.region.getChunkAt(location);
        }
        if (this.poi != null) {
            poiChunk = (PoiChunk)this.poi.getChunkAt(location);
        }
        if (this.entities != null) {
            entitiesChunk = (EntitiesChunk)this.entities.getChunkAt(location);
        }
        return new ChunkData(regionChunk, poiChunk, entitiesChunk, selected);
    }

    public ChunkData getChunkData(int index, boolean selected) {
        RegionChunk regionChunk = null;
        PoiChunk poiChunk = null;
        EntitiesChunk entitiesChunk = null;
        if (this.region != null) {
            regionChunk = (RegionChunk)this.region.getChunk(index);
        }
        if (this.poi != null) {
            poiChunk = (PoiChunk)this.poi.getChunk(index);
        }
        if (this.entities != null) {
            entitiesChunk = (EntitiesChunk)this.entities.getChunk(index);
        }
        return new ChunkData(regionChunk, poiChunk, entitiesChunk, selected);
    }

    public void setChunkDataAt(ChunkData chunkData, Point2i location) {
        if (this.region == null && this.directories.getRegion() != null) {
            this.region = new RegionMCAFile(this.directories.getRegion());
        }
        if (this.poi == null && this.directories.getPoi() != null) {
            this.poi = new PoiMCAFile(this.directories.getPoi());
        }
        if (this.entities == null && this.directories.getEntities() != null) {
            this.entities = new EntitiesMCAFile(this.directories.getEntities());
        }
        if (this.region != null) {
            this.region.setChunkAt(location, chunkData.region());
        }
        if (this.poi != null) {
            this.poi.setChunkAt(location, chunkData.poi());
        }
        if (this.entities != null) {
            this.entities.setChunkAt(location, chunkData.entities());
        }
    }

    public void save() throws IOException {
        if (this.region != null) {
            this.region.save();
        }
        if (this.poi != null) {
            this.poi.save();
        }
        if (this.entities != null) {
            this.entities.save();
        }
    }

    public void saveWithTempFiles() throws IOException {
        if (this.region != null) {
            this.region.saveWithTempFile();
        }
        if (this.poi != null) {
            this.poi.saveWithTempFile();
        }
        if (this.entities != null) {
            this.entities.saveWithTempFile();
        }
    }

    public void saveWithTempFiles(RegionDirectories dest) throws IOException {
        if (this.region != null) {
            this.region.saveWithTempFile(dest.getRegion());
        }
        if (this.poi != null) {
            this.poi.saveWithTempFile(dest.getPoi());
        }
        if (this.entities != null) {
            this.entities.saveWithTempFile(dest.getEntities());
        }
    }

    public void deFragment() throws IOException {
        if (this.region != null) {
            this.region.deFragment();
        }
        if (this.poi != null) {
            this.poi.deFragment();
        }
        if (this.entities != null) {
            this.entities.deFragment();
        }
    }

    public void deFragment(RegionDirectories dest) throws IOException {
        if (this.region != null) {
            this.region.deFragment(dest.getRegion());
        }
        if (this.poi != null) {
            this.poi.deFragment(dest.getPoi());
        }
        if (this.entities != null) {
            this.entities.deFragment(dest.getEntities());
        }
    }

    public void deleteFiles() {
        if (this.directories.getRegion() != null && this.directories.getRegion().exists()) {
            this.directories.getRegion().delete();
        }
        if (this.directories.getPoi() != null && this.directories.getPoi().exists()) {
            this.directories.getPoi().delete();
        }
        if (this.directories.getEntities() != null && this.directories.getEntities().exists()) {
            this.directories.getEntities().delete();
        }
    }

    public void deleteChunks(ChunkSet selection) {
        if (this.region != null) {
            this.region.deleteChunks(selection);
        }
        if (this.poi != null) {
            this.poi.deleteChunks(selection);
        }
        if (this.entities != null) {
            this.entities.deleteChunks(selection);
        }
    }

    public boolean deleteChunks(Filter<?> filter, Selection selection) {
        boolean deleted = false;
        for (int i = 0; i < 1024; ++i) {
            Point2i location;
            PoiChunk poi;
            RegionChunk region = (RegionChunk)this.region.getChunk(i);
            EntitiesChunk entities = this.entities == null ? null : (EntitiesChunk)this.entities.getChunk(i);
            PoiChunk poiChunk = poi = this.poi == null ? null : (PoiChunk)this.poi.getChunk(i);
            if (region == null || region.isEmpty() || selection != null && !selection.isAnyChunkInRegionSelected(region.getAbsoluteLocation()) || (location = region.getAbsoluteLocation()) == null) continue;
            ChunkData filterData = new ChunkData(region, poi, entities, selection != null && selection.isChunkSelected(location));
            if (selection != null && !selection.isChunkSelected(location) || !filter.matches(filterData)) continue;
            this.deleteChunkIndex(i);
            deleted = true;
        }
        return deleted;
    }

    public boolean keepChunks(Filter<?> filter, Selection selection) {
        boolean deleted = false;
        for (int i = 0; i < 1024; ++i) {
            ChunkData filterData;
            Point2i location;
            PoiChunk poi;
            RegionChunk region = (RegionChunk)this.region.getChunk(i);
            EntitiesChunk entities = this.entities == null ? null : (EntitiesChunk)this.entities.getChunk(i);
            PoiChunk poiChunk = poi = this.poi == null ? null : (PoiChunk)this.poi.getChunk(i);
            if (region == null || region.isEmpty() || (location = region.getAbsoluteLocation()) == null || filter.matches(filterData = new ChunkData(region, poi, entities, selection != null && selection.isChunkSelected(location))) && (selection == null || selection.isChunkSelected(location))) continue;
            this.deleteChunkIndex(i);
            deleted = true;
        }
        return deleted;
    }

    private void deleteChunkIndex(int index) {
        if (this.region != null) {
            this.region.deleteChunk(index);
        }
        if (this.entities != null) {
            this.entities.deleteChunk(index);
        }
        if (this.poi != null) {
            this.poi.deleteChunk(index);
        }
    }

    public ChunkSet getFilteredChunks(Filter<?> filter, Selection selection) {
        ChunkSet chunks = new ChunkSet();
        for (int i = 0; i < 1024; ++i) {
            RegionChunk regionChunk = this.region == null ? null : (RegionChunk)this.region.getChunk(i);
            EntitiesChunk entitiesChunk = this.entities == null ? null : (EntitiesChunk)this.entities.getChunk(i);
            PoiChunk poiChunk = this.poi == null ? null : (PoiChunk)this.poi.getChunk(i);
            Point2i chunkLocation = this.location.regionToChunk().add(new Point2i(i));
            ChunkData filterData = new ChunkData(regionChunk, poiChunk, entitiesChunk, selection != null && selection.isChunkSelected(chunkLocation));
            try {
                if (selection != null && !selection.isChunkSelected(chunkLocation) || !filter.matches(filterData)) continue;
                chunks.set(i);
                continue;
            }
            catch (Exception ex) {
                LOGGER.warn("failed to select chunk {}: {}", (Object)chunkLocation, (Object)ex.getMessage());
            }
        }
        return chunks;
    }

    public void applyFieldChanges(List<Field<?>> fields, boolean force, Selection selection) {
        Timer t = new Timer();
        boolean selected = false;
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                Point2i absoluteLocation = this.location.regionToChunk().add(x, z);
                if (selection != null && !(selected = selection.isChunkSelected(absoluteLocation))) continue;
                ChunkData chunkData = this.getChunkDataAt(absoluteLocation, selected);
                try {
                    chunkData.applyFieldChanges(fields, force);
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.warn("failed to apply field changes to chunk {}: {}", (Object)absoluteLocation, (Object)ex.getMessage());
                }
            }
        }
        LOGGER.debug("took {} to apply field changes to region {}", (Object)t, (Object)this.location);
    }

    public void mergeInto(Region region, Point3i offset, boolean overwrite, ChunkSet sourceChunks, ChunkSet targetChunks, List<Range> ranges) {
        if (this.region != null) {
            this.region.mergeChunksInto(region.region, offset, overwrite, sourceChunks, targetChunks, ranges);
        }
        if (this.poi != null) {
            this.poi.mergeChunksInto(region.poi, offset, overwrite, sourceChunks, targetChunks, ranges);
        }
        if (this.entities != null) {
            this.entities.mergeChunksInto(region.entities, offset, overwrite, sourceChunks, targetChunks, ranges);
        }
    }

    protected Region clone() throws CloneNotSupportedException {
        Region clone = (Region)super.clone();
        if (this.region != null) {
            clone.region = this.region.clone();
        }
        if (this.poi != null) {
            clone.poi = this.poi.clone();
        }
        if (this.entities != null) {
            clone.entities = this.entities.clone();
        }
        if (this.directories != null) {
            clone.directories = this.directories.clone();
        }
        clone.location = this.location.clone();
        return clone;
    }
}

