/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.mca;

import java.io.File;
import java.util.List;
import net.querz.mcaselector.io.mca.CompressionType;
import net.querz.mcaselector.io.mca.MCAFile;
import net.querz.mcaselector.io.mca.PoiChunk;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.range.Range;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.nbt.CompoundTag;

public class PoiMCAFile
extends MCAFile<PoiChunk>
implements Cloneable {
    public PoiMCAFile(File file) {
        super(file, PoiChunk::new);
        this.chunks = new PoiChunk[1024];
    }

    static PoiChunk newEmptyChunk(Point2i absoluteLocation, int dataVersion) {
        CompoundTag root = VersionHandler.getImpl(dataVersion, ChunkFilter.MergePOI.class).newEmptyChunk(absoluteLocation, dataVersion);
        PoiChunk chunk = new PoiChunk(absoluteLocation);
        chunk.data = root;
        chunk.compressionType = CompressionType.ZLIB;
        return chunk;
    }

    @Override
    public void mergeChunksInto(MCAFile<PoiChunk> destination, Point3i offset, boolean overwrite, ChunkSet sourceChunks, ChunkSet selection, List<Range> ranges) {
        this.mergeChunksInto(destination, offset, overwrite, sourceChunks, selection, ranges, PoiMCAFile::newEmptyChunk);
    }

    public PoiMCAFile clone() {
        return this.clone(PoiMCAFile::new);
    }
}

