/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.mca;

import java.io.File;
import java.util.List;
import net.querz.mcaselector.io.mca.CompressionType;
import net.querz.mcaselector.io.mca.EntitiesChunk;
import net.querz.mcaselector.io.mca.MCAFile;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.range.Range;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.nbt.CompoundTag;

public class EntitiesMCAFile
extends MCAFile<EntitiesChunk>
implements Cloneable {
    public EntitiesMCAFile(File file) {
        super(file, EntitiesChunk::new);
        this.chunks = new EntitiesChunk[1024];
    }

    static EntitiesChunk newEmptyChunk(Point2i absoluteLocation, int dataVersion) {
        CompoundTag root = VersionHandler.getImpl(dataVersion, ChunkFilter.MergeEntities.class).newEmptyChunk(absoluteLocation, dataVersion);
        EntitiesChunk chunk = new EntitiesChunk(absoluteLocation);
        chunk.data = root;
        chunk.compressionType = CompressionType.ZLIB;
        return chunk;
    }

    @Override
    public void mergeChunksInto(MCAFile<EntitiesChunk> destination, Point3i offset, boolean overwrite, ChunkSet sourceChunks, ChunkSet targetChunks, List<Range> ranges) {
        this.mergeChunksInto(destination, offset, overwrite, sourceChunks, targetChunks, ranges, EntitiesMCAFile::newEmptyChunk);
    }

    public EntitiesMCAFile clone() {
        return this.clone(EntitiesMCAFile::new);
    }
}

