/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.mca;

public enum CompressionType {
    NONE(0),
    GZIP(1),
    ZLIB(2),
    UNCOMPRESSED(3),
    LZ4(4),
    NONE_EXT(-128),
    GZIP_EXT(-127),
    ZLIB_EXT(-126),
    UNCOMPRESSED_EXT(-125),
    LZ4_EXT(-124);

    private final byte type;

    private CompressionType(int type) {
        this.type = (byte)type;
    }

    public static CompressionType fromByte(byte t) {
        for (CompressionType c : CompressionType.values()) {
            if (c.type != t) continue;
            return c;
        }
        throw new IllegalArgumentException("Invalid compression type " + t);
    }

    public byte getByte() {
        return this.type;
    }

    public CompressionType getExternal() {
        return switch (this.ordinal()) {
            case 0 -> NONE_EXT;
            case 1 -> GZIP_EXT;
            case 2 -> ZLIB_EXT;
            case 3 -> UNCOMPRESSED_EXT;
            case 4 -> LZ4_EXT;
            default -> this;
        };
    }
}

