/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.mca;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Function;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import net.querz.io.ExposedByteArrayOutputStream;
import net.querz.mcaselector.io.ByteBufferBackedInputStream;
import net.querz.mcaselector.io.mca.CompressionType;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.range.Range;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.NBTUtil;
import net.querz.nbt.Tag;
import net.querz.nbt.io.NBTReader;
import net.querz.nbt.io.NBTWriter;

public abstract class Chunk {
    protected int timestamp;
    protected CompoundTag data;
    protected CompressionType compressionType;
    protected final Point2i absoluteLocation;

    public Chunk(Point2i absoluteLocation) {
        this.absoluteLocation = absoluteLocation;
    }

    public void load(ByteBuffer buf, boolean raw) throws IOException {
        int length = buf.getInt();
        this.compressionType = CompressionType.fromByte(buf.get());
        DataInputStream nbtIn = switch (this.compressionType) {
            default -> throw new MatchException(null, null);
            case CompressionType.GZIP -> new DataInputStream(new GZIPInputStream(new ByteBufferBackedInputStream(buf)));
            case CompressionType.ZLIB -> new DataInputStream(new InflaterInputStream(new ByteBufferBackedInputStream(buf)));
            case CompressionType.LZ4 -> new DataInputStream(new LZ4BlockInputStream(new ByteBufferBackedInputStream(buf)));
            case CompressionType.NONE, CompressionType.UNCOMPRESSED -> new DataInputStream(new ByteBufferBackedInputStream(buf));
            case CompressionType.GZIP_EXT -> new DataInputStream(new GZIPInputStream((InputStream)new FileInputStream(this.getMCCFile()), 4096 * length));
            case CompressionType.ZLIB_EXT -> new DataInputStream(new InflaterInputStream(new FileInputStream(this.getMCCFile())));
            case CompressionType.LZ4_EXT -> new DataInputStream(new LZ4BlockInputStream(new FileInputStream(this.getMCCFile())));
            case CompressionType.NONE_EXT, CompressionType.UNCOMPRESSED_EXT -> new DataInputStream(new BufferedInputStream(new FileInputStream(this.getMCCFile()), 4096 * length));
        };
        Tag tag = new NBTReader().rawArrays(raw).read(nbtIn);
        if (!(tag instanceof CompoundTag)) {
            throw new IOException("unexpected chunk data tag type " + String.valueOf((Object)tag.getType()) + ", expected " + String.valueOf((Object)Tag.Type.COMPOUND));
        }
        this.data = (CompoundTag)tag;
    }

    public int save(RandomAccessFile raf) throws IOException {
        ExposedByteArrayOutputStream baos = null;
        DataOutputStream nbtOut = switch (this.compressionType) {
            default -> throw new MatchException(null, null);
            case CompressionType.GZIP, CompressionType.GZIP_EXT -> {
                baos = new ExposedByteArrayOutputStream();
                DataOutputStream v0 = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(baos)));
                yield v0;
            }
            case CompressionType.ZLIB, CompressionType.ZLIB_EXT -> {
                baos = new ExposedByteArrayOutputStream();
                DataOutputStream v2 = new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream(baos)));
                yield v2;
            }
            case CompressionType.LZ4, CompressionType.LZ4_EXT -> {
                baos = new ExposedByteArrayOutputStream();
                DataOutputStream v3 = new DataOutputStream(new BufferedOutputStream(new LZ4BlockOutputStream(baos)));
                yield v3;
            }
            case CompressionType.NONE, CompressionType.UNCOMPRESSED, CompressionType.NONE_EXT, CompressionType.UNCOMPRESSED_EXT -> {
                baos = new ExposedByteArrayOutputStream();
                DataOutputStream v4 = new DataOutputStream(new BufferedOutputStream(baos));
                yield v4;
            }
        };
        new NBTWriter().write(nbtOut, (Tag)this.data);
        nbtOut.close();
        if (baos.size() > 0x100000) {
            int dataVersion = this.data.getInt("DataVersion");
            if (dataVersion < 2203) {
                throw new RuntimeException("chunk at " + String.valueOf(this.absoluteLocation) + " is oversized and can't be saved when DataVersion is below 2203");
            }
            raf.writeInt(1);
            raf.writeByte(this.compressionType.getExternal().getByte());
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.getMCCFile()), baos.size());){
                bos.write(baos.getBuffer(), 0, baos.size());
            }
            return 5;
        }
        raf.writeInt(baos.size() + 1);
        raf.writeByte(this.compressionType.getByte());
        raf.write(baos.getBuffer(), 0, baos.size());
        return baos.size() + 5;
    }

    public abstract boolean relocate(Point3i var1);

    public abstract void merge(CompoundTag var1, List<Range> var2, int var3);

    public abstract File getMCCFile();

    public boolean isEmpty() {
        return this.data == null;
    }

    public CompoundTag getData() {
        return this.data;
    }

    public void setData(CompoundTag data) {
        this.data = data;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public Point2i getAbsoluteLocation() {
        return this.absoluteLocation;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public String toString() {
        String s = NBTUtil.toSNBT(this.data);
        return "<absoluteLocation=" + String.valueOf(this.absoluteLocation) + ", compressionType=" + String.valueOf((Object)this.compressionType) + ", data=" + s + ">";
    }

    protected <T extends Chunk> T clone(Function<Point2i, T> chunkConstructor) {
        Chunk clone = (Chunk)chunkConstructor.apply(this.absoluteLocation);
        clone.compressionType = this.compressionType;
        clone.timestamp = this.timestamp;
        if (this.data != null) {
            clone.data = this.data.copy();
        }
        return (T)clone;
    }
}

