/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.job;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.function.Consumer;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.io.WorldDirectories;
import net.querz.mcaselector.io.job.ProcessDataJob;
import net.querz.mcaselector.io.job.SaveDataJob;
import net.querz.mcaselector.io.mca.Region;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.progress.Progress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SelectionExporter {
    private static final Logger LOGGER = LogManager.getLogger(SelectionExporter.class);

    private SelectionExporter() {
    }

    public static void exportSelection(Selection selection, WorldDirectories destination, Progress progressChannel) {
        if (selection.isEmpty()) {
            progressChannel.done("no selection");
            return;
        }
        JobHandler.clearQueues();
        Selection trueSelection = selection.getTrueSelection(destination);
        progressChannel.setMax(trueSelection.size());
        progressChannel.updateProgress(FileHelper.createMCAFileName(trueSelection.one()), 0);
        Consumer<Throwable> errorHandler = t -> progressChannel.incrementProgress("error");
        for (Long2ObjectMap.Entry<ChunkSet> entry : trueSelection) {
            MCADeleteSelectionProcessJob job = new MCADeleteSelectionProcessJob(FileHelper.createRegionDirectories(new Point2i(entry.getLongKey())), (ChunkSet)entry.getValue(), destination, progressChannel);
            job.errorHandler = errorHandler;
            JobHandler.addJob(job);
        }
    }

    private static class MCADeleteSelectionProcessJob
    extends ProcessDataJob {
        private final Progress progressChannel;
        private final ChunkSet chunksToBeExported;
        private final WorldDirectories destination;

        private MCADeleteSelectionProcessJob(RegionDirectories dirs, ChunkSet chunksToBeExported, WorldDirectories destination, Progress progressChannel) {
            super(dirs, 20000000);
            this.chunksToBeExported = chunksToBeExported;
            this.destination = destination;
            this.progressChannel = progressChannel;
        }

        @Override
        public boolean execute() {
            File toRegion = new File(this.destination.getRegion(), this.getRegionDirectories().getLocationAsFileName());
            File toPoi = new File(this.destination.getPoi(), this.getRegionDirectories().getLocationAsFileName());
            File toEntities = new File(this.destination.getEntities(), this.getRegionDirectories().getLocationAsFileName());
            if (toRegion.exists() || toPoi.exists() || toEntities.exists()) {
                LOGGER.debug("{} exists, not overwriting", (Object)this.getRegionDirectories().getLocationAsFileName());
                this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                return true;
            }
            RegionDirectories to = new RegionDirectories(this.getRegionDirectories().getLocation(), toRegion, toPoi, toEntities);
            if (this.chunksToBeExported == null) {
                try {
                    Files.copy(this.getRegionDirectories().getRegion().toPath(), to.getRegion().toPath(), StandardCopyOption.REPLACE_EXISTING);
                    LOGGER.debug("copied file {}", (Object)this.getRegionDirectories().getRegion());
                }
                catch (Exception ex) {
                    LOGGER.warn("failed to copy file {}", (Object)this.getRegionDirectories().getRegion(), (Object)ex);
                }
                try {
                    Files.copy(this.getRegionDirectories().getPoi().toPath(), to.getPoi().toPath(), StandardCopyOption.REPLACE_EXISTING);
                    LOGGER.debug("copied file {}", (Object)this.getRegionDirectories().getPoi());
                }
                catch (Exception ex) {
                    LOGGER.warn("failed to copy file {}", (Object)this.getRegionDirectories().getPoi(), (Object)ex);
                }
                try {
                    Files.copy(this.getRegionDirectories().getEntities().toPath(), to.getEntities().toPath(), StandardCopyOption.REPLACE_EXISTING);
                    LOGGER.debug("copied file {}", (Object)this.getRegionDirectories().getEntities());
                }
                catch (Exception ex) {
                    LOGGER.warn("failed to copy file {}", (Object)this.getRegionDirectories().getEntities(), (Object)ex);
                }
                this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                return true;
            }
            try {
                Region region = Region.loadRegionHeaders(this.getRegionDirectories());
                region.deleteChunks(this.chunksToBeExported.flip());
                MCADeleteSelectionSaveJob job = new MCADeleteSelectionSaveJob(this.getRegionDirectories(), region, to, this.progressChannel);
                job.errorHandler = this.errorHandler;
                JobHandler.executeSaveData(job);
                return false;
            }
            catch (Exception ex) {
                LOGGER.warn("error deleting chunk indices in {}", (Object)this.getRegionDirectories().getLocationAsFileName(), (Object)ex);
                this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                return true;
            }
        }
    }

    private static class MCADeleteSelectionSaveJob
    extends SaveDataJob<Region> {
        private final Progress progressChannel;
        private final RegionDirectories destinations;

        private MCADeleteSelectionSaveJob(RegionDirectories dirs, Region region, RegionDirectories destinations, Progress progressChannel) {
            super(dirs, region);
            this.destinations = destinations;
            this.progressChannel = progressChannel;
        }

        @Override
        public void execute() {
            try {
                ((Region)this.getData()).deFragment(this.destinations);
            }
            catch (Exception ex) {
                LOGGER.warn("failed to export filtered chunks from {}", (Object)this.getRegionDirectories().getLocationAsFileName(), (Object)ex);
            }
            this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
        }
    }
}

