/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.job;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javax.imageio.ImageIO;
import net.querz.mcaselector.config.Config;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.config.WorldConfig;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.io.job.ProcessDataJob;
import net.querz.mcaselector.io.job.SaveDataJob;
import net.querz.mcaselector.io.mca.RegionMCAFile;
import net.querz.mcaselector.tile.Tile;
import net.querz.mcaselector.tile.TileImage;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.progress.Progress;
import net.querz.mcaselector.util.progress.Timer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RegionImageGenerator {
    private static final Logger LOGGER = LogManager.getLogger(RegionImageGenerator.class);
    private static final Set<Point2i> loading = ConcurrentHashMap.newKeySet();
    private static final LinkedHashMap<Point2i, RegionMCAFile> cachedMCAFiles = new LinkedHashMap();
    private static Function<Point2i, Boolean> cacheEligibilityChecker = null;
    private static final Object cacheLock = new Object();

    private RegionImageGenerator() {
    }

    public static void generate(Tile tile, BiConsumer<Image, UniqueID> callback, Integer zoomLevel, Progress progressChannel, boolean canSkipSaving, Supplier<Integer> prioritySupplier) {
        LOGGER.debug("adding job {}, tile:{}, scale:{}, loading:{}, image:{}, loaded:{}", (Object)MCAImageProcessJob.class.getSimpleName(), (Object)tile.getLocation(), (Object)zoomLevel, (Object)RegionImageGenerator.isLoading(tile), tile.getImage() == null ? "null" : tile.getImage().getHeight() + "x" + tile.getImage().getWidth(), (Object)tile.isLoaded());
        JobHandler.addJob(new MCAImageProcessJob(tile, new UniqueID(), callback, zoomLevel, progressChannel, canSkipSaving, prioritySupplier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionMCAFile getCachedRegionMCAFile(Point2i region) {
        Object object = cacheLock;
        synchronized (object) {
            return cachedMCAFiles.get(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheRegionMCAFile(RegionMCAFile regionMCAFile, UniqueID uniqueID) {
        Object object = cacheLock;
        synchronized (object) {
            if (!uniqueID.matchesCurrentConfig()) {
                return;
            }
            if (cacheEligibilityChecker != null && cacheEligibilityChecker.apply(regionMCAFile.getLocation()).booleanValue() && !cachedMCAFiles.containsKey(regionMCAFile.getLocation())) {
                if (cachedMCAFiles.size() >= ConfigProvider.GLOBAL.getMaxLoadedFiles()) {
                    cachedMCAFiles.remove(cachedMCAFiles.keySet().iterator().next());
                }
                cachedMCAFiles.put(regionMCAFile.getLocation(), regionMCAFile.minimizeForRendering());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncacheRegionMCAFile(Point2i region) {
        Object object = cacheLock;
        synchronized (object) {
            cachedMCAFiles.remove(region);
        }
    }

    public static void setCacheEligibilityChecker(Function<Point2i, Boolean> checker) {
        cacheEligibilityChecker = checker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateCachedMCAFiles() {
        Object object = cacheLock;
        synchronized (object) {
            cachedMCAFiles.clear();
        }
    }

    public static boolean isLoading(Tile tile) {
        return loading.contains(tile.getLocation());
    }

    public static void setLoading(Tile tile, boolean loading) {
        LOGGER.debug("set loading from mca for {} to {}, image:{}, loaded:{}", (Object)tile.getLocation(), (Object)loading, tile.getImage() == null ? "null" : tile.getImage().getHeight() + "x" + tile.getImage().getWidth(), (Object)tile.isLoaded());
        if (loading) {
            RegionImageGenerator.loading.add(tile.getLocation());
        } else {
            RegionImageGenerator.loading.remove(tile.getLocation());
        }
    }

    public static class MCAImageProcessJob
    extends ProcessDataJob {
        private final Tile tile;
        private final UniqueID uniqueID;
        private final BiConsumer<Image, UniqueID> callback;
        private final Integer zoomLevel;
        private final Progress progressChannel;
        private final boolean canSkipSaving;
        private final Supplier<Integer> prioritySupplier;

        private MCAImageProcessJob(Tile tile, UniqueID uniqueID, BiConsumer<Image, UniqueID> callback, Integer zoomLevel, Progress progressChannel, boolean canSkipSaving, Supplier<Integer> prioritySupplier) {
            super(new RegionDirectories(tile.getLocation(), null, null, null), 20000000);
            this.tile = tile;
            this.uniqueID = uniqueID;
            this.callback = callback;
            this.zoomLevel = zoomLevel;
            this.progressChannel = progressChannel;
            this.canSkipSaving = canSkipSaving;
            this.prioritySupplier = prioritySupplier;
            if (progressChannel != null) {
                this.errorHandler = t -> progressChannel.incrementProgress("error");
            }
        }

        @Override
        public boolean execute() {
            Timer t;
            RegionMCAFile cachedRegion = RegionImageGenerator.getCachedRegionMCAFile(this.tile.getLocation());
            LOGGER.debug("generating image for {}", (Object)this.tile.getMCAFile().getAbsolutePath());
            File file = this.tile.getMCAFile();
            boolean isCached = false;
            if (cachedRegion == null) {
                cachedRegion = new RegionMCAFile(file);
                try {
                    t = new Timer();
                    cachedRegion.load(true);
                    LOGGER.debug("took {} to read mca file {}", (Object)t, (Object)cachedRegion.getFile().getName());
                }
                catch (IOException ex) {
                    LOGGER.warn("failed to load mca file {}", (Object)cachedRegion.getFile().getName());
                    this.callback.accept(null, this.uniqueID);
                    if (this.progressChannel != null) {
                        this.progressChannel.incrementProgress(FileHelper.createMCAFileName(this.tile.getLocation()));
                    }
                    return true;
                }
            } else {
                isCached = true;
            }
            if (this.zoomLevel == null) {
                for (int z = Config.MIN_ZOOM_LEVEL; z <= Config.MAX_ZOOM_LEVEL; z *= 2) {
                    Timer t2 = new Timer();
                    Image image = TileImage.generateImage(cachedRegion, z);
                    LOGGER.debug("took {} to generate image for region {}", (Object)t2, (Object)this.tile.getLocation());
                    this.callback.accept(image, this.uniqueID);
                    new MCAImageSaveCacheJob(image, this.tile, z, null, this.canSkipSaving).execute();
                }
                if (this.progressChannel != null) {
                    this.progressChannel.incrementProgress(FileHelper.createMCAFileName(this.tile.getLocation()));
                }
                return true;
            }
            t = new Timer();
            Image image = TileImage.generateImage(cachedRegion, this.zoomLevel);
            LOGGER.debug("took {} to generate image for region {}", (Object)t, (Object)this.tile.getLocation());
            this.callback.accept(image, this.uniqueID);
            RegionImageGenerator.cacheRegionMCAFile(cachedRegion, this.uniqueID);
            if (image != null && !isCached) {
                MCAImageSaveCacheJob job = new MCAImageSaveCacheJob(image, this.tile, this.zoomLevel, this.progressChannel, this.canSkipSaving);
                job.errorHandler = this.errorHandler;
                JobHandler.executeSaveData(job);
                return false;
            }
            if (this.progressChannel != null) {
                this.progressChannel.incrementProgress(FileHelper.createMCAFileName(this.tile.getLocation()));
            }
            return true;
        }

        @Override
        public void cancel() {
            LOGGER.debug("cancelling job {}, tile:{}, scale:{}, loading:{}, image:{}, loaded:{}", (Object)MCAImageProcessJob.class.getSimpleName(), (Object)this.tile.getLocation(), (Object)this.zoomLevel, (Object)RegionImageGenerator.isLoading(this.tile), this.tile.getImage() == null ? "null" : this.tile.getImage().getHeight() + "x" + this.tile.getImage().getWidth(), (Object)this.tile.isLoaded());
            RegionImageGenerator.setLoading(this.tile, false);
            if (this.progressChannel != null) {
                this.progressChannel.incrementProgress(FileHelper.createMCAFileName(this.tile.getLocation()));
            }
        }

        public Tile getTile() {
            return this.tile;
        }

        @Override
        public int getPriority() {
            if (this.prioritySupplier == null) {
                return super.getPriority();
            }
            return super.getBasePriority() + this.prioritySupplier.get();
        }
    }

    public static class UniqueID {
        private final UUID world;
        private final int height;
        private final boolean layerOnly;
        private final boolean shade;
        private final boolean shadeWater;
        private final boolean caves;

        private UniqueID() {
            WorldConfig worldConfig = ConfigProvider.WORLD;
            this.world = worldConfig.getWorldUUID();
            this.height = worldConfig.getRenderHeight();
            this.layerOnly = worldConfig.getRenderLayerOnly();
            this.shade = worldConfig.getShade();
            this.shadeWater = worldConfig.getShadeWater();
            this.caves = worldConfig.getRenderCaves();
        }

        public boolean matchesCurrentConfig() {
            WorldConfig worldConfig = ConfigProvider.WORLD;
            return this.world.equals(worldConfig.getWorldUUID()) && this.height == worldConfig.getRenderHeight() && this.layerOnly == worldConfig.getRenderLayerOnly() && this.shade == worldConfig.getShade() && this.shadeWater == worldConfig.getShadeWater() && this.caves == worldConfig.getRenderCaves();
        }
    }

    private static class MCAImageSaveCacheJob
    extends SaveDataJob<Image> {
        private final Tile tile;
        private final int zoomLevel;
        private final Progress progressChannel;
        private final boolean canSkip;

        private MCAImageSaveCacheJob(Image data, Tile tile, int zoomLevel, Progress progressChannel, boolean canSkip) {
            super(new RegionDirectories(tile.getLocation(), null, null, null), data);
            this.tile = tile;
            this.zoomLevel = zoomLevel;
            this.progressChannel = progressChannel;
            this.canSkip = canSkip;
        }

        @Override
        public void execute() {
            Timer t = new Timer();
            try {
                BufferedImage img = SwingFXUtils.fromFXImage((Image)((Image)this.getData()), null);
                File cacheFile = FileHelper.createPNGFilePath(ConfigProvider.WORLD.getCacheDir(this.zoomLevel), this.tile.getLocation());
                if (!cacheFile.getParentFile().exists() && !cacheFile.getParentFile().mkdirs()) {
                    LOGGER.warn("failed to create cache directory for {}", (Object)cacheFile.getAbsolutePath());
                }
                LOGGER.debug("writing cache file {}", (Object)cacheFile.getAbsolutePath());
                ImageIO.write((RenderedImage)img, "png", cacheFile);
            }
            catch (IOException ex) {
                LOGGER.warn("failed to save images to cache for {}", (Object)this.tile.getLocation(), (Object)ex);
            }
            if (this.progressChannel != null) {
                this.progressChannel.incrementProgress(FileHelper.createMCAFileName(this.tile.getLocation()));
            }
            LOGGER.debug("took {} to cache image of {} to {}", (Object)t, (Object)this.tile.getMCAFile().getName(), (Object)FileHelper.createPNGFileName(this.tile.getLocation()));
            this.done();
        }

        @Override
        public void cancel() {
            if (this.progressChannel != null) {
                this.progressChannel.incrementProgress(FileHelper.createMCAFileName(this.tile.getLocation()));
            }
        }

        @Override
        public boolean canSkip() {
            return this.canSkip;
        }
    }
}

