/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.job;

import java.io.File;
import java.util.function.Consumer;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.filter.filters.GroupFilter;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.io.WorldDirectories;
import net.querz.mcaselector.io.job.ProcessDataJob;
import net.querz.mcaselector.io.job.SaveDataJob;
import net.querz.mcaselector.io.mca.Region;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.progress.Progress;
import net.querz.mcaselector.util.progress.Timer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ChunkFilterExporter {
    private static final Logger LOGGER = LogManager.getLogger(ChunkFilterExporter.class);

    private ChunkFilterExporter() {
    }

    public static void exportFilter(GroupFilter filter, Selection selection, WorldDirectories destination, Progress progressChannel, boolean headless) {
        WorldDirectories wd = ConfigProvider.WORLD.getWorldDirs();
        RegionDirectories[] rd = wd.listRegions(selection);
        if (rd == null || rd.length == 0) {
            if (headless) {
                progressChannel.done("no files");
            } else {
                progressChannel.done(Translation.DIALOG_PROGRESS_NO_FILES.toString());
            }
            return;
        }
        JobHandler.clearQueues();
        progressChannel.setMax(rd.length);
        progressChannel.updateProgress(rd[0].getLocationAsFileName(), 0);
        Consumer<Throwable> errorHandler = t -> progressChannel.incrementProgress("error");
        for (RegionDirectories r : rd) {
            MCAExportFilterProcessJob job = new MCAExportFilterProcessJob(r, filter, selection, destination, progressChannel);
            job.errorHandler = errorHandler;
            JobHandler.addJob(job);
        }
    }

    private static class MCAExportFilterProcessJob
    extends ProcessDataJob {
        private final Progress progressChannel;
        private final GroupFilter filter;
        private final Selection selection;
        private final WorldDirectories destination;

        private MCAExportFilterProcessJob(RegionDirectories dirs, GroupFilter filter, Selection selection, WorldDirectories destination, Progress progressChannel) {
            super(dirs, 20000000);
            this.filter = filter;
            this.selection = selection;
            this.destination = destination;
            this.progressChannel = progressChannel;
        }

        @Override
        public boolean execute() {
            Point2i location = this.getRegionDirectories().getLocation();
            if (!this.filter.appliesToRegion(location) || this.selection != null && !this.selection.isAnyChunkInRegionSelected(location)) {
                LOGGER.debug("filter does not apply to region {}", (Object)this.getRegionDirectories().getLocation());
                this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                return true;
            }
            File toRegion = new File(this.destination.getRegion(), this.getRegionDirectories().getLocationAsFileName());
            File toPoi = new File(this.destination.getPoi(), this.getRegionDirectories().getLocationAsFileName());
            File toEntities = new File(this.destination.getEntities(), this.getRegionDirectories().getLocationAsFileName());
            if (toRegion.exists() || toPoi.exists() || toEntities.exists()) {
                LOGGER.debug("{} exists, not overwriting", (Object)this.getRegionDirectories().getLocationAsFileName());
                this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                return true;
            }
            RegionDirectories to = new RegionDirectories(this.getRegionDirectories().getLocation(), toRegion, toPoi, toEntities);
            try {
                Region region = Region.loadRegion(this.getRegionDirectories());
                region.keepChunks(this.filter, this.selection);
                MCAExportFilterSaveJob job = new MCAExportFilterSaveJob(this.getRegionDirectories(), region, to, this.progressChannel);
                job.errorHandler = this.errorHandler;
                JobHandler.executeSaveData(job);
                return false;
            }
            catch (Exception ex) {
                this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                LOGGER.warn("error deleting chunk indices in {}", (Object)this.getRegionDirectories().getLocationAsFileName());
                return true;
            }
        }
    }

    private static class MCAExportFilterSaveJob
    extends SaveDataJob<Region> {
        private final RegionDirectories to;
        private final Progress progressChannel;

        private MCAExportFilterSaveJob(RegionDirectories src, Region region, RegionDirectories to, Progress progressChannel) {
            super(src, region);
            this.to = to;
            this.progressChannel = progressChannel;
        }

        @Override
        public void execute() {
            Timer t = new Timer();
            try {
                ((Region)this.getData()).deFragment(this.to);
            }
            catch (Exception ex) {
                LOGGER.warn("failed to save exported filtered chunks in {}", (Object)this.getRegionDirectories().getLocationAsFileName(), (Object)ex);
            }
            this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
            LOGGER.debug("took {} to save data for {}", (Object)t, (Object)this.getRegionDirectories().getLocationAsFileName());
        }
    }
}

