/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.job;

import java.util.function.Consumer;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.filter.filters.GroupFilter;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.io.WorldDirectories;
import net.querz.mcaselector.io.job.ProcessDataJob;
import net.querz.mcaselector.io.job.SaveDataJob;
import net.querz.mcaselector.io.mca.Region;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.progress.Progress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ChunkFilterDeleter {
    private static final Logger LOGGER = LogManager.getLogger(ChunkFilterDeleter.class);

    private ChunkFilterDeleter() {
    }

    public static void deleteFilter(GroupFilter filter, Selection selection, Progress progressChannel, boolean headless) {
        WorldDirectories wd = ConfigProvider.WORLD.getWorldDirs();
        RegionDirectories[] rd = wd.listRegions(selection);
        if (rd == null || rd.length == 0) {
            if (headless) {
                progressChannel.done("no files");
            } else {
                progressChannel.done(Translation.DIALOG_PROGRESS_NO_FILES.toString());
            }
            return;
        }
        JobHandler.clearQueues();
        progressChannel.setMax(rd.length);
        progressChannel.updateProgress(rd[0].getLocationAsFileName(), 0);
        Consumer<Throwable> errorHandler = t -> progressChannel.incrementProgress("error");
        for (RegionDirectories r : rd) {
            MCADeleteFilterProcessJob job = new MCADeleteFilterProcessJob(r, filter, selection, progressChannel);
            job.errorHandler = errorHandler;
            JobHandler.addJob(job);
        }
    }

    private static class MCADeleteFilterProcessJob
    extends ProcessDataJob {
        private final Progress progressChannel;
        private final GroupFilter filter;
        private final Selection selection;

        private MCADeleteFilterProcessJob(RegionDirectories dirs, GroupFilter filter, Selection selection, Progress progressChannel) {
            super(dirs, 20000000);
            this.filter = filter;
            this.selection = selection;
            this.progressChannel = progressChannel;
        }

        @Override
        public boolean execute() {
            Point2i location = this.getRegionDirectories().getLocation();
            if (!this.filter.appliesToRegion(location) || this.selection != null && !this.selection.isAnyChunkInRegionSelected(location)) {
                LOGGER.debug("filter does not apply to region {}", (Object)this.getRegionDirectories().getLocation());
                this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                return true;
            }
            try {
                Region region = Region.loadRegion(this.getRegionDirectories());
                if (region.deleteChunks(this.filter, this.selection)) {
                    MCADeleteFilterSaveJob job = new MCADeleteFilterSaveJob(this.getRegionDirectories(), region, this.progressChannel);
                    job.errorHandler = this.errorHandler;
                    JobHandler.executeSaveData(job);
                    return false;
                }
                this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                LOGGER.debug("nothing to delete in {}, not saving", (Object)this.getRegionDirectories().getLocationAsFileName());
            }
            catch (Exception ex) {
                this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                LOGGER.warn("error deleting chunk indices in {}", (Object)this.getRegionDirectories().getLocationAsFileName());
            }
            return true;
        }
    }

    private static class MCADeleteFilterSaveJob
    extends SaveDataJob<Region> {
        private final Progress progressChannel;

        private MCADeleteFilterSaveJob(RegionDirectories dirs, Region region, Progress progressChannel) {
            super(dirs, region);
            this.progressChannel = progressChannel;
        }

        @Override
        public void execute() {
            try {
                ((Region)this.getData()).deFragment();
            }
            catch (Exception ex) {
                LOGGER.warn("failed to delete filtered chunks from {}", (Object)this.getRegionDirectories().getLocationAsFileName(), (Object)ex);
            }
            this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
        }
    }
}

