/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.util.point.Point2i;

public class WorldDirectories
implements Serializable,
Cloneable {
    private File region;
    private File poi;
    private File entities;

    public WorldDirectories() {
    }

    public WorldDirectories(File region, File poi, File entities) {
        this.region = region;
        this.poi = poi;
        this.entities = entities;
    }

    public void setRegion(File region) {
        this.region = region;
    }

    public void setPoi(File poi) {
        this.poi = poi;
    }

    public void setEntities(File entities) {
        this.entities = entities;
    }

    public File getRegion() {
        return this.region;
    }

    public File getPoi() {
        return this.poi;
    }

    public File getEntities() {
        return this.entities;
    }

    public RegionDirectories makeRegionDirectories(Point2i region) {
        RegionDirectories rd = new RegionDirectories();
        rd.setRegion(new File(this.region, FileHelper.createMCAFileName(region)));
        rd.setPoi(new File(this.poi, FileHelper.createMCAFileName(region)));
        rd.setEntities(new File(this.entities, FileHelper.createMCAFileName(region)));
        return rd;
    }

    public RegionDirectories[] listRegions(Selection selection) {
        File[] e;
        Point2i l;
        File[] p;
        HashMap<Point2i, RegionDirectories> regionDirectories = new HashMap<Point2i, RegionDirectories>();
        File[] r = this.region.listFiles((d, n) -> FileHelper.MCA_FILE_PATTERN.matcher(n).matches());
        if (r != null) {
            for (File f : r) {
                Point2i l2 = FileHelper.parseMCAFileName(f);
                if (selection != null && !selection.isAnyChunkInRegionSelected(l2.asLong())) continue;
                regionDirectories.put(l2, new RegionDirectories(l2, f, null, null));
            }
        }
        if (this.entities != null && (p = this.entities.listFiles((d, n) -> FileHelper.MCA_FILE_PATTERN.matcher(n).matches())) != null) {
            for (File f : p) {
                l = FileHelper.parseMCAFileName(f);
                if (selection != null && !selection.isAnyChunkInRegionSelected(l.asLong())) continue;
                if (regionDirectories.containsKey(l)) {
                    ((RegionDirectories)regionDirectories.get(l)).setEntities(f);
                    continue;
                }
                regionDirectories.put(l, new RegionDirectories(l, null, null, f));
            }
        }
        if (this.poi != null && (e = this.poi.listFiles((d, n) -> FileHelper.MCA_FILE_PATTERN.matcher(n).matches())) != null) {
            for (File f : e) {
                l = FileHelper.parseMCAFileName(f);
                if (selection != null && !selection.isAnyChunkInRegionSelected(l.asLong())) continue;
                if (regionDirectories.containsKey(l)) {
                    ((RegionDirectories)regionDirectories.get(l)).setPoi(f);
                    continue;
                }
                regionDirectories.put(l, new RegionDirectories(l, null, f, null));
            }
        }
        return regionDirectories.values().toArray(new RegionDirectories[0]);
    }

    public WorldDirectories clone() {
        try {
            return (WorldDirectories)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "<region=" + String.valueOf(this.region) + ", poi=" + String.valueOf(this.poi) + ", entities=" + String.valueOf(this.entities) + ">";
    }

    public boolean sharesDirectories(WorldDirectories other) {
        return this.region != null && this.region.equals(other.region) || this.poi != null && this.poi.equals(other.poi) || this.entities != null && this.entities.equals(other.entities);
    }
}

