/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io;

import java.util.function.Function;
import net.querz.mcaselector.util.exception.ParseException;

public class StringPointer {
    private final String value;
    private int index;

    public StringPointer(String value) {
        this.value = value;
    }

    public String parseSimpleString() {
        int oldIndex = this.index;
        while (this.hasNext() && !Character.isWhitespace(this.currentChar())) {
            ++this.index;
        }
        return this.value.substring(oldIndex, this.index);
    }

    public String parseSimpleString(Function<Character, Boolean> valid) {
        int oldIndex = this.index;
        while (this.hasNext() && valid.apply(Character.valueOf(this.currentChar())).booleanValue()) {
            ++this.index;
        }
        return this.value.substring(oldIndex, this.index);
    }

    public String parseQuotedString() throws ParseException {
        return this.parseQuotedString('\"');
    }

    public String parseQuotedString(char quote) throws ParseException {
        int oldIndex = ++this.index;
        StringBuilder sb = null;
        boolean escape = false;
        while (this.hasNext()) {
            char c = this.next();
            if (escape) {
                if (c != '\\' && c != quote) {
                    throw this.parseException("invalid escape of '" + c + "'");
                }
                escape = false;
            } else {
                if (c == '\\') {
                    escape = true;
                    if (sb != null) continue;
                    sb = new StringBuilder(this.value.substring(oldIndex, this.index - 1));
                    continue;
                }
                if (c == quote) {
                    return sb == null ? this.value.substring(oldIndex, this.index - 1) : sb.toString();
                }
            }
            if (sb == null) continue;
            sb.append(c);
        }
        throw this.parseException("missing end quote");
    }

    public boolean nextArrayElement() {
        this.skipWhitespace();
        if (this.hasNext() && this.currentChar() == ',') {
            ++this.index;
            this.skipWhitespace();
            return true;
        }
        return false;
    }

    public void expectChar(char c) throws ParseException {
        this.skipWhitespace();
        boolean hasNext = this.hasNext();
        if (hasNext && this.currentChar() == c) {
            ++this.index;
            return;
        }
        throw this.parseException("expected '" + c + "' but got " + (String)(hasNext ? "'" + this.currentChar() + "'" : "EOF"));
    }

    public void expectString(String s) throws ParseException {
        this.skipWhitespace();
        int index = 0;
        while (this.hasNext() && index < s.length() && this.currentChar() == s.charAt(index)) {
            ++index;
            ++this.index;
        }
        if (index != s.length()) {
            throw this.parseException("expected \"" + s + "\" but got " + (String)(this.hasNext() ? "\"" + this.value.substring(this.index - index, this.index) + "\"" : "EOF"));
        }
    }

    public void skipWhitespace() {
        while (this.hasNext() && Character.isWhitespace(this.currentChar())) {
            ++this.index;
        }
    }

    public boolean hasNext() {
        return this.index < this.value.length();
    }

    public boolean hasCharsLeft(int num) {
        return this.index + num < this.value.length();
    }

    public char currentChar() {
        return this.value.charAt(this.index);
    }

    public int index() {
        return this.index;
    }

    public int size() {
        return this.value.length();
    }

    public char next() {
        return this.value.charAt(this.index++);
    }

    public void skip(int offset) {
        this.index += offset;
    }

    public char lookAhead(int offset) {
        return this.value.charAt(this.index + offset);
    }

    public ParseException parseException(String msg) {
        return new ParseException(msg, this.value, this.index);
    }
}

