/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io;

import java.io.File;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.WorldDirectories;
import net.querz.mcaselector.util.point.Point2i;

public class RegionDirectories
implements Cloneable {
    private Point2i location;
    private File region;
    private File poi;
    private File entities;
    private String locationAsFileName;

    public RegionDirectories() {
    }

    public RegionDirectories(Point2i location, File region, File poi, File entities) {
        this.location = location;
        this.region = region;
        this.poi = poi;
        this.entities = entities;
    }

    public void setRegion(File region) {
        if (this.location == null) {
            this.location = FileHelper.parseMCAFileName(region);
        }
        this.region = region;
    }

    public void setPoi(File poi) {
        if (this.location == null) {
            this.location = FileHelper.parseMCAFileName(poi);
        }
        this.poi = poi;
    }

    public void setEntities(File entities) {
        if (this.location == null) {
            this.location = FileHelper.parseMCAFileName(entities);
        }
        this.entities = entities;
    }

    public File getRegion() {
        return this.region;
    }

    public File getPoi() {
        return this.poi;
    }

    public File getEntities() {
        return this.entities;
    }

    public Point2i getLocation() {
        return this.location;
    }

    public String getLocationAsFileName() {
        if (this.locationAsFileName == null) {
            this.locationAsFileName = FileHelper.createMCAFileName(this.location);
            return this.locationAsFileName;
        }
        return this.locationAsFileName;
    }

    public static RegionDirectories fromWorldDirectories(WorldDirectories wd, Point2i location) {
        String fileName = FileHelper.createMCAFileName(location);
        return new RegionDirectories(location, new File(wd.getRegion(), fileName), new File(wd.getPoi(), fileName), new File(wd.getEntities(), fileName));
    }

    public boolean exists() {
        return this.region.exists() || this.poi.exists() || this.entities.exists();
    }

    public String toString() {
        return "<region=" + String.valueOf(this.region) + ", poi=" + String.valueOf(this.poi) + ", entities=" + String.valueOf(this.entities) + ">";
    }

    public RegionDirectories clone() throws CloneNotSupportedException {
        RegionDirectories clone = (RegionDirectories)super.clone();
        clone.location = this.location.clone();
        return clone;
    }
}

