/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.DynamicPriorityBlockingQueue;
import net.querz.mcaselector.io.Job;
import net.querz.mcaselector.io.NamedThreadFactory;
import net.querz.mcaselector.io.PausableThreadPoolExecutor;
import net.querz.mcaselector.io.job.ParseDataJob;
import net.querz.mcaselector.io.job.ProcessDataJob;
import net.querz.mcaselector.io.job.SaveDataJob;
import net.querz.mcaselector.util.progress.Timer;
import net.querz.mcaselector.util.property.DataProperty;
import net.querz.mcaselector.util.validation.ShutdownHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JobHandler {
    private static final Logger LOGGER = LogManager.getLogger(JobHandler.class);
    private static PausableThreadPoolExecutor processExecutor;
    private static PausableThreadPoolExecutor saveExecutor;
    private static ThreadPoolExecutor parseExecutor;
    private static final AtomicInteger allTasks;
    private static final AtomicInteger runningTasks;
    private static boolean trimSaveData;
    private static final AtomicLong jobIDCounter;

    public static void setTrimSaveData(boolean trimSaveData) {
        LOGGER.debug("{} trimming save data", (Object)(trimSaveData ? "enabled" : "disabled"));
        JobHandler.trimSaveData = trimSaveData;
    }

    public static void init() {
        JobHandler.clearQueues();
        if (processExecutor != null) {
            processExecutor.shutdownNow();
        }
        if (saveExecutor != null) {
            saveExecutor.shutdownNow();
        }
        if (parseExecutor != null) {
            parseExecutor.shutdownNow();
        }
        processExecutor = new PausableThreadPoolExecutor(ConfigProvider.GLOBAL.getProcessThreads(), ConfigProvider.GLOBAL.getProcessThreads(), 0L, TimeUnit.MILLISECONDS, new DynamicPriorityBlockingQueue<Runnable>(), new NamedThreadFactory("processPool"), job -> {
            int i = runningTasks.incrementAndGet();
            if (i > ConfigProvider.GLOBAL.getProcessThreads() && !trimSaveData) {
                processExecutor.pause("pausing process");
            }
            LOGGER.debug("+ active jobs: {} ({} queued)", (Object)i, (Object)processExecutor.getQueue().size());
        }, job -> {
            if (job.isDone()) {
                int i = runningTasks.decrementAndGet();
                LOGGER.debug("- active jobs: {} ({} queued)", (Object)i, (Object)processExecutor.getQueue().size());
                processExecutor.resume("freed up a task after processing");
            }
        });
        LOGGER.debug("created data processor ThreadPoolExecutor with {} threads", (Object)ConfigProvider.GLOBAL.getProcessThreads());
        saveExecutor = new PausableThreadPoolExecutor(ConfigProvider.GLOBAL.getWriteThreads(), ConfigProvider.GLOBAL.getWriteThreads(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(), new NamedThreadFactory("savePool"), job -> {
            int i = runningTasks.decrementAndGet();
            LOGGER.debug("- active jobs: {} ({} queued)", (Object)i, (Object)processExecutor.getQueue().size());
            processExecutor.resume("freed up a task after saving");
        }, job -> {});
        LOGGER.debug("created data save ThreadPoolExecutor with {} threads", (Object)ConfigProvider.GLOBAL.getWriteThreads());
        parseExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new DynamicPriorityBlockingQueue<Runnable>(), new NamedThreadFactory("parsePool"));
        LOGGER.debug("created data parser ThreadPoolExecutor with {} threads", (Object)1);
    }

    public static void addJob(ProcessDataJob job) {
        LOGGER.debug("adding job {} for {} to executor queue", (Object)job.getClass().getSimpleName(), (Object)job.getRegionDirectories().getLocation());
        processExecutor.execute(new WrapperJob(job));
    }

    public static void executeSaveData(SaveDataJob<?> job) {
        if (runningTasks.get() <= ConfigProvider.GLOBAL.getProcessThreads() + 1) {
            saveExecutor.execute(new WrapperJob(job));
        } else if (!trimSaveData) {
            processExecutor.pause("waiting for save data");
            saveExecutor.execute(new WrapperJob(job));
        } else {
            int i = runningTasks.decrementAndGet();
            if (i <= ConfigProvider.GLOBAL.getProcessThreads() + 1) {
                job.cancel();
                processExecutor.resume("skipping save data");
                LOGGER.debug("too many tasks: skipping save data");
            }
            LOGGER.debug("- active jobs: {} ({} queued)", (Object)i, (Object)processExecutor.getQueue().size());
        }
    }

    public static void executeParseData(ParseDataJob job) {
        parseExecutor.execute(new WrapperJob(job));
    }

    public static void validateJobs(Predicate<ProcessDataJob> p) {
        processExecutor.getQueue().removeIf(r -> {
            if (p.test((ProcessDataJob)((WrapperJob)r).job)) {
                ((WrapperJob)r).cancel();
                return true;
            }
            return false;
        });
        parseExecutor.getQueue().removeIf(r -> {
            if (p.test((ProcessDataJob)((WrapperJob)r).job)) {
                ((WrapperJob)r).cancel();
                return true;
            }
            return false;
        });
    }

    public static void clearQueues() {
        int cancelledProcessJobs = JobHandler.cancelExecutorQueue(processExecutor);
        int cancelledSaveJobs = JobHandler.cancelExecutorQueue(saveExecutor);
        int cancelledParseJobs = JobHandler.cancelExecutorQueue(parseExecutor);
        LOGGER.debug("cancelled {} jobs in process queue", (Object)cancelledProcessJobs);
        LOGGER.debug("cancelled {} jobs in save queue", (Object)cancelledSaveJobs);
        LOGGER.debug("cancelled {} jobs in parser queue", (Object)cancelledParseJobs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelParserQueue() {
        if (parseExecutor != null) {
            BlockingQueue<Runnable> blockingQueue = parseExecutor.getQueue();
            synchronized (blockingQueue) {
                parseExecutor.getQueue().removeIf(j -> {
                    ((WrapperJob)j).cancel();
                    return true;
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int cancelExecutorQueue(ThreadPoolExecutor executor) {
        DataProperty<Integer> cancelled = new DataProperty<Integer>(0);
        if (executor != null) {
            BlockingQueue<Runnable> blockingQueue = executor.getQueue();
            synchronized (blockingQueue) {
                executor.getQueue().removeIf(j -> {
                    ((WrapperJob)j).cancel();
                    cancelled.set((Integer)cancelled.get() + 1);
                    return true;
                });
            }
        }
        return cancelled.get();
    }

    public static void cancelAllJobsAndFlushAsync(Runnable callback) {
        Thread thread = new Thread(() -> {
            JobHandler.cancelAllJobsAndFlush();
            callback.run();
        });
        thread.start();
    }

    public static void cancelAllJobsAndFlush() {
        Timer t = new Timer();
        JobHandler.clearQueues();
        JobHandler.flushExecutor();
        JobHandler.clearQueues();
        JobHandler.flushExecutor();
        LOGGER.debug("took {} to cancel and flush all executors", (Object)t);
    }

    private static void flushExecutor() {
        while (allTasks.get() > 0) {
            Thread.onSpinWait();
        }
    }

    public static int getActiveJobs() {
        return allTasks.get();
    }

    static {
        allTasks = new AtomicInteger(0);
        runningTasks = new AtomicInteger(0);
        trimSaveData = true;
        JobHandler.init();
        ShutdownHooks.addShutdownHook(() -> processExecutor.shutdownNow());
        ShutdownHooks.addShutdownHook(() -> saveExecutor.shutdownNow());
        ShutdownHooks.addShutdownHook(() -> parseExecutor.shutdownNow());
        jobIDCounter = new AtomicLong(0L);
    }

    static class WrapperJob
    implements Runnable,
    Comparable<WrapperJob> {
        Job job;
        long jobID = jobIDCounter.incrementAndGet();
        boolean done = false;
        static final Object lock = new Object();

        WrapperJob(Job job) {
            allTasks.incrementAndGet();
            this.job = job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.job.run();
            }
            finally {
                Object object = lock;
                synchronized (object) {
                    if (!this.done) {
                        allTasks.decrementAndGet();
                    }
                    this.done = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            try {
                this.job.cancel();
            }
            finally {
                Object object = lock;
                synchronized (object) {
                    if (!this.done) {
                        allTasks.decrementAndGet();
                    }
                    this.done = true;
                }
            }
        }

        @Override
        public int compareTo(WrapperJob o) {
            int b;
            int a = this.job.getPriority();
            if (a == (b = o.job.getPriority())) {
                return Long.compare(this.jobID, o.jobID);
            }
            return Integer.compare(a, b);
        }

        public String toString() {
            return this.jobID + "#" + this.job.toString();
        }
    }
}

