/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javax.imageio.ImageIO;
import net.querz.mcaselector.tile.Tile;
import net.querz.mcaselector.util.progress.Progress;
import net.querz.mcaselector.util.progress.Timer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ImageHelper {
    private static final Logger LOGGER = LogManager.getLogger(ImageHelper.class);
    private static Image empty;

    private ImageHelper() {
    }

    public static BufferedImage scaleImage(BufferedImage before, double newSize, boolean smooth) {
        double w = before.getWidth();
        double h = before.getHeight();
        BufferedImage after = new BufferedImage((int)newSize, (int)newSize, 2);
        AffineTransform at = new AffineTransform();
        at.scale(newSize / w, newSize / h);
        AffineTransformOp scaleOp = new AffineTransformOp(at, smooth ? 2 : 1);
        return scaleOp.filter(before, after);
    }

    public static Image scaleDownFXImage(Image before, int newSize) {
        WritableImage after = new WritableImage(newSize, newSize);
        PixelReader reader = before.getPixelReader();
        PixelWriter writer = after.getPixelWriter();
        int scaleFactor = (int)(before.getWidth() / after.getWidth());
        for (int y = 0; y < newSize; ++y) {
            for (int x = 0; x < newSize; ++x) {
                int argb = reader.getArgb(x * scaleFactor, y * scaleFactor);
                writer.setArgb(x, y, argb);
            }
        }
        return after;
    }

    public static Image renderGradient(int width, float min, float max, float low, float high, boolean inverted) {
        WritableImage image = new WritableImage(width, 1);
        PixelWriter pixelWriter = image.getPixelWriter();
        for (int i = 0; i < width; ++i) {
            float hue = (max - min) * ((float)i / (float)width) + min;
            float saturation = 1.0f;
            float brightness = 1.0f;
            if (hue < low || hue > high) {
                saturation = 0.3f;
                brightness = 0.6f;
            }
            if (inverted) {
                hue = max - hue + min;
            }
            pixelWriter.setArgb(i, 0, Color.HSBtoRGB(hue, saturation, brightness));
        }
        return image;
    }

    public static float getHue(int color) {
        return ImageHelper.getHue(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    public static float getHue(float r, float g, float b) {
        float max;
        float min = Math.min(Math.min(r, g), b);
        if (min == (max = Math.max(Math.max(r, g), b))) {
            return 0.0f;
        }
        float hue = r == max ? (g - b) / (max - min) : (g == max ? 2.0f + (b - r) / (max - min) : 4.0f + (r - g) / (max - min));
        if ((hue *= 60.0f) < 0.0f) {
            hue += 360.0f;
        }
        return hue / 360.0f;
    }

    public static void reloadEmpty() {
        WritableImage wImage = new WritableImage(512, 512);
        PixelWriter pWriter = wImage.getPixelWriter();
        for (int x = 0; x < 512; ++x) {
            for (int y = 0; y < 512; ++y) {
                pWriter.setColor(x, y, Tile.EMPTY_COLOR.makeJavaFXColor());
            }
        }
        empty = wImage;
    }

    public static Image getEmptyTileImage() {
        return empty;
    }

    public static void saveImageData(int[] data, int width, int height, File file, Progress progressChannel) throws IOException {
        progressChannel.setMax(height + 1);
        progressChannel.updateProgress("", 0);
        Timer t = new Timer();
        BufferedImage img = new BufferedImage(width, height, 2);
        for (int y = 0; y < height && !progressChannel.taskCancelled(); ++y) {
            int start = y * width;
            for (int x = 0; x < width; ++x) {
                img.setRGB(x, y, data[start + x]);
            }
            progressChannel.incrementProgress("");
        }
        ImageIO.write((RenderedImage)img, "png", file);
        progressChannel.incrementProgress("");
        progressChannel.done("done");
        LOGGER.debug("took {} to save image {}", (Object)t, (Object)file);
    }
}

