/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.io.WorldDirectories;
import net.querz.mcaselector.ui.dialog.SelectWorldDialog;
import net.querz.mcaselector.util.exception.ThrowingFunction;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.property.DataProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FileHelper {
    private static final Logger LOGGER = LogManager.getLogger(FileHelper.class);
    public static final int HEADER_SIZE = 8192;
    public static final Pattern MCA_FILE_PATTERN = Pattern.compile("^r\\.-?\\d+\\.-?\\d+\\.mca$");
    public static final Pattern REGION_GROUP_PATTERN = Pattern.compile("^r\\.(?<regionX>-?\\d+)\\.(?<regionZ>-?\\d+)\\.mca$");
    public static final Pattern DAT_REGION_GROUP_PATTERN = Pattern.compile("^r\\.(?<regionX>-?\\d+)\\.(?<regionZ>-?\\d+)\\.dat$");
    public static final Pattern CACHE_REGION_GROUP_PATTERN = Pattern.compile("^r\\.(?<regionX>-?\\d+)\\.(?<regionZ>-?\\d+)\\.png$");
    private static final Map<String, String> lastOpenedDirectoryMap = new HashMap<String, String>();
    private static final int datapackDimensionsMaxDepth = 4;

    private FileHelper() {
    }

    public static Image getIconFromResources(String name) {
        return new Image(Objects.requireNonNull(FileHelper.class.getClassLoader().getResourceAsStream(name + ".png")));
    }

    private static String getMCDir() {
        String os = System.getProperty("os.name").toLowerCase();
        Object appdataDir = null;
        if (os.contains("win")) {
            String env = System.getenv("AppData");
            File file = new File(env == null ? "" : env, ".minecraft");
            if (file.exists()) {
                appdataDir = file.getAbsolutePath();
            }
        } else {
            appdataDir = FileHelper.getHomeDir();
            appdataDir = (String)appdataDir + "/Library/Application Support/minecraft";
        }
        return appdataDir;
    }

    private static String getHomeDir() {
        return System.getProperty("user.home");
    }

    public static Point2i parseMCAFileName(File file) {
        return FileHelper.parseMCAFileName(file.getName());
    }

    public static Point2i parseDATFileName(File file) {
        return FileHelper.parseMCAFileName(file.getName());
    }

    public static Point2i parseDATFileName(String name) {
        Matcher m = DAT_REGION_GROUP_PATTERN.matcher(name);
        if (m.find()) {
            int x = Integer.parseInt(m.group("regionX"));
            int z = Integer.parseInt(m.group("regionZ"));
            return new Point2i(x, z);
        }
        return null;
    }

    public static Point2i parseMCAFileName(String name) {
        Matcher m = REGION_GROUP_PATTERN.matcher(name);
        if (m.find()) {
            int x = Integer.parseInt(m.group("regionX"));
            int z = Integer.parseInt(m.group("regionZ"));
            return new Point2i(x, z);
        }
        return null;
    }

    public static Point2i parseCacheFileName(File file) {
        return FileHelper.parseCacheFileName(file.getName());
    }

    public static Point2i parseCacheFileName(String name) {
        Matcher m = CACHE_REGION_GROUP_PATTERN.matcher(name);
        if (m.find()) {
            int x = Integer.parseInt(m.group("regionX"));
            int z = Integer.parseInt(m.group("regionZ"));
            return new Point2i(x, z);
        }
        return null;
    }

    public static String getMCSavesDir() {
        File saves;
        String appData = FileHelper.getMCDir();
        if (appData == null || !(saves = new File(appData, "saves")).exists()) {
            return FileHelper.getHomeDir();
        }
        return saves.getAbsolutePath();
    }

    public static String getLastOpenedDirectory(String key, String def) {
        String value = lastOpenedDirectoryMap.getOrDefault(key, def);
        if (value != null && new File(value).exists()) {
            return value;
        }
        if (def != null && new File(def).exists()) {
            return def;
        }
        return System.getProperty("user.home");
    }

    public static void setLastOpenedDirectory(String key, String lastOpenedDirectory) {
        lastOpenedDirectoryMap.put(key, lastOpenedDirectory);
    }

    public static File createRegionMCAFilePath(Point2i r) {
        return new File(ConfigProvider.WORLD.getWorldDirs().getRegion(), FileHelper.createMCAFileName(r));
    }

    public static File createPoiMCAFilePath(Point2i r) {
        return new File(ConfigProvider.WORLD.getWorldDirs().getPoi(), FileHelper.createMCAFileName(r));
    }

    public static File createEntitiesMCAFilePath(Point2i r) {
        return new File(ConfigProvider.WORLD.getWorldDirs().getEntities(), FileHelper.createMCAFileName(r));
    }

    public static File createRegionMCCFilePath(Point2i c) {
        return new File(ConfigProvider.WORLD.getWorldDirs().getRegion(), FileHelper.createMCCFileName(c));
    }

    public static File createPoiMCCFilePath(Point2i c) {
        return new File(ConfigProvider.WORLD.getWorldDirs().getPoi(), FileHelper.createMCCFileName(c));
    }

    public static File createEntitiesMCCFilePath(Point2i c) {
        return new File(ConfigProvider.WORLD.getWorldDirs().getEntities(), FileHelper.createMCCFileName(c));
    }

    public static WorldDirectories validateWorldDirectories(File dir) {
        File region = new File(dir, "region");
        File poi = new File(dir, "poi");
        File entities = new File(dir, "entities");
        if (!region.exists()) {
            return null;
        }
        return new WorldDirectories(region, poi.exists() ? poi : null, entities.exists() ? entities : null);
    }

    public static RegionDirectories createRegionDirectories(Point2i r) {
        File region = FileHelper.createRegionMCAFilePath(r);
        File poi = FileHelper.createPoiMCAFilePath(r);
        File entities = FileHelper.createEntitiesMCAFilePath(r);
        return new RegionDirectories(r, region, poi, entities);
    }

    public static File createMCAFilePath(Point2i r) {
        return new File(ConfigProvider.WORLD.getRegionDir(), FileHelper.createMCAFileName(r));
    }

    public static File createMCCFilePath(Point2i c) {
        return new File(ConfigProvider.WORLD.getRegionDir(), FileHelper.createMCCFileName(c));
    }

    public static File createPNGFilePath(File cacheDir, Point2i r) {
        return new File(cacheDir, FileHelper.createPNGFileName(r));
    }

    public static File createPNGFilePath(File cacheDir, int zoomLevel, Point2i r) {
        return new File(cacheDir, zoomLevel + "/" + FileHelper.createPNGFileName(r));
    }

    public static String createMCAFileName(Point2i r) {
        return String.format("r.%d.%d.mca", r.getX(), r.getZ());
    }

    public static String createMCCFileName(Point2i c) {
        return String.format("c.%d.%d.mcc", c.getX(), c.getZ());
    }

    public static String createPNGFileName(Point2i r) {
        return String.format("r.%d.%d.png", r.getX(), r.getZ());
    }

    public static Attributes getManifestAttributes() throws IOException {
        URL url;
        String className = FileHelper.class.getSimpleName() + ".class";
        String classPath = Objects.requireNonNull(FileHelper.class.getResource(className)).toString();
        if (!classPath.startsWith("jar")) {
            throw new IOException("application not running in jar file");
        }
        try {
            url = new URI(classPath).toURL();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
        Manifest manifest = jarConnection.getManifest();
        return manifest.getMainAttributes();
    }

    public static void clearFolder(File dir) throws IOException {
        Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.deleteIfExists(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException ex) throws IOException {
                if (ex == null) {
                    Files.deleteIfExists(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw ex;
            }
        });
    }

    public static LongOpenHashSet parseAllMCAFileNames(File directory) {
        if (directory == null) {
            return LongOpenHashSet.of();
        }
        File[] files = directory.listFiles((dir, name) -> MCA_FILE_PATTERN.matcher(name).matches());
        if (files == null) {
            return LongOpenHashSet.of();
        }
        LongOpenHashSet regions = new LongOpenHashSet(files.length);
        Arrays.stream(files).forEach(f -> regions.add(FileHelper.parseMCAFileName(f).asLong()));
        return regions;
    }

    public static WorldDirectories createWorldDirectories(File file) {
        try {
            FileHelper.createDirectoryOrThrowException(file, "region");
            FileHelper.createDirectoryOrThrowException(file, "poi");
            FileHelper.createDirectoryOrThrowException(file, "entities");
            return new WorldDirectories(new File(file, "region"), new File(file, "poi"), new File(file, "entities"));
        }
        catch (IOException ex) {
            LOGGER.warn("failed to create directories", (Throwable)ex);
            return null;
        }
    }

    private static void createDirectoryOrThrowException(File dir, String folder) throws IOException {
        File d = new File(dir, folder);
        if (!d.exists() && !d.mkdirs()) {
            throw new IOException("failed to create directory " + String.valueOf(d));
        }
    }

    public static boolean deleteDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                FileHelper.deleteDirectory(file);
            }
        }
        return dir.delete();
    }

    public static List<File> detectDimensionDirectories(File dir) {
        File[] customDimensions;
        File end;
        File nether;
        ArrayList<File> result = new ArrayList<File>();
        if (FileHelper.isValidDimension(dir)) {
            result.add(dir);
        }
        if (FileHelper.isValidDimension(nether = new File(dir, "DIM-1"))) {
            result.add(nether);
        }
        if (FileHelper.isValidDimension(end = new File(dir, "DIM1"))) {
            result.add(end);
        }
        if ((customDimensions = dir.listFiles((d, name) -> !name.equals("DIM-1") && !name.equals("DIM1") && name.matches("^DIM-?\\d+$") && FileHelper.isValidDimension(d))) != null) {
            result.addAll(Arrays.asList(customDimensions));
        }
        File dimensions = new File(dir, "dimensions");
        ArrayList<File> datapackDimensions = new ArrayList<File>();
        FileHelper.detectDatapackDimensions(dimensions, 0, datapackDimensions);
        result.addAll(datapackDimensions);
        return result;
    }

    private static void detectDatapackDimensions(File dir, int depth, List<File> detected) {
        if (depth >= 4) {
            return;
        }
        File[] subDirs = dir.listFiles((d, name) -> d.isDirectory());
        if (subDirs == null) {
            return;
        }
        for (File subDir : subDirs) {
            if (FileHelper.isValidDimension(subDir)) {
                detected.add(subDir);
                continue;
            }
            FileHelper.detectDatapackDimensions(subDir, depth + 1, detected);
        }
    }

    public static boolean isValidDimension(File dir) {
        File region = new File(dir, "region");
        return region.exists() && FileHelper.hasMCAFiles(region);
    }

    public static boolean hasMCAFiles(File dir) {
        File[] files = dir.listFiles((d, name) -> MCA_FILE_PATTERN.matcher(name).matches());
        return files != null && files.length > 0;
    }

    public static WorldDirectories detectWorldDirectories(File dir) {
        File region = new File(dir, "region");
        File poi = new File(dir, "poi");
        File entities = new File(dir, "entities");
        WorldDirectories worldDirectories = new WorldDirectories();
        if (region.exists() && FileHelper.hasMCAFiles(region)) {
            worldDirectories.setRegion(region);
        }
        if (poi.exists()) {
            worldDirectories.setPoi(poi);
        }
        if (entities.exists()) {
            worldDirectories.setEntities(entities);
        }
        return worldDirectories;
    }

    public static File testFilesInSameDirectory(List<File> files) {
        File dir = null;
        for (File file : files) {
            if (file.isDirectory()) {
                if (dir == null) {
                    dir = file;
                    continue;
                }
                if (file.equals(dir)) continue;
                return null;
            }
            if (dir == null) {
                dir = file.getParentFile();
                continue;
            }
            if (file.getParentFile().equals(dir)) continue;
            return null;
        }
        return dir;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static WorldDirectories testWorldDirectoriesValid(List<File> files, Stage primaryStage) {
        List<File> dimensionDirs;
        if (files.isEmpty()) {
            return null;
        }
        File dir = FileHelper.testFilesInSameDirectory(files);
        if (dir != null && FileHelper.hasMCAFiles(dir)) {
            return new WorldDirectories(dir, null, null);
        }
        WorldDirectories wd = new WorldDirectories();
        block10: for (File file : files) {
            if (!file.isDirectory()) {
                wd = null;
                break;
            }
            switch (file.getName()) {
                case "region": {
                    if (wd.getRegion() != null) {
                        wd = null;
                        break block10;
                    }
                    wd.setRegion(file);
                    break;
                }
                case "poi": {
                    if (wd.getPoi() != null) {
                        wd = null;
                        break block10;
                    }
                    wd.setPoi(file);
                    break;
                }
                case "entities": {
                    if (wd.getEntities() != null) {
                        wd = null;
                        break block10;
                    }
                    wd.setEntities(file);
                }
            }
        }
        if (wd != null && wd.getRegion() != null) {
            return wd;
        }
        if (files.size() != 1) {
            return null;
        }
        File file = files.getFirst();
        if (file.isFile()) {
            file = file.getParentFile();
        }
        if ((dimensionDirs = FileHelper.detectDimensionDirectories(file)).size() == 1) {
            return FileHelper.detectWorldDirectories(dimensionDirs.getFirst());
        }
        if (dimensionDirs.size() > 1) {
            if (primaryStage == null) {
                return new WorldDirectories();
            }
            Optional result = new SelectWorldDialog(dimensionDirs, primaryStage).showAndWait();
            DataProperty dimensionProperty = new DataProperty();
            result.ifPresent(dim -> dimensionProperty.set(FileHelper.detectWorldDirectories(dim)));
            if (dimensionProperty.get() != null) {
                return (WorldDirectories)dimensionProperty.get();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T loadFromResource(String resourceName, ThrowingFunction<BufferedReader, T, Throwable> loadFunc) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(FileHelper.class.getClassLoader().getResourceAsStream(resourceName))));){
            BufferedReader t = loadFunc.apply(reader);
            return (T)t;
        }
        catch (Throwable e) {
            LOGGER.fatal("Failed to load resource {}", (Object)resourceName, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

