/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter.filters;

import java.io.File;
import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.Filter;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.filter.RegionMatcher;
import net.querz.mcaselector.filter.TextFilter;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.property.DataProperty;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.nbt.IntTag;

public class SelectionFilter
extends TextFilter<File>
implements RegionMatcher {
    private Selection selection = new Selection();
    private final Object lock;
    private DataProperty<Boolean> loaded = new DataProperty<Boolean>(false);
    private static final Comparator[] comparators = new Comparator[]{Comparator.EQUAL, Comparator.NOT_EQUAL};

    public SelectionFilter() {
        this(FilterType.SELECTION, Operator.AND, Comparator.EQUAL, null, new Object());
    }

    protected SelectionFilter(FilterType type, Operator operator, Comparator comparator, File value, Object lock) {
        super(type, operator, comparator, value);
        this.lock = lock;
        this.setRawValue(value == null ? "" : value.toString());
    }

    @Override
    public Comparator[] getComparators() {
        return comparators;
    }

    @Override
    public void setFilterValue(String raw) {
        File file = new File(raw.trim());
        if (file.exists() && file.isFile() && raw.endsWith(".csv")) {
            this.setValid(true);
            this.setValue(file);
            this.setRawValue(raw);
        } else {
            this.setValid(false);
            this.setValue(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(File value, ChunkData data) {
        if (data.region() == null || data.region().getData() == null) {
            return false;
        }
        if (!this.loaded.get().booleanValue()) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.loaded.get().booleanValue()) {
                    this.loadSelection(value);
                }
            }
        }
        ChunkFilter.Pos pos = VersionHandler.getImpl(data, ChunkFilter.Pos.class);
        IntTag xPos = pos.getXPos(data);
        IntTag zPos = pos.getZPos(data);
        if (xPos == null || zPos == null) {
            return false;
        }
        return this.selection.isChunkSelected(xPos.asInt(), zPos.asInt());
    }

    @Override
    public boolean matches(ChunkData data) {
        return switch (this.getComparator()) {
            case Comparator.EQUAL -> this.contains((File)this.value, data);
            case Comparator.NOT_EQUAL -> this.containsNot((File)this.value, data);
            default -> false;
        };
    }

    @Override
    public boolean containsNot(File value, ChunkData data) {
        return !this.contains(value, data);
    }

    @Override
    public boolean intersects(File value, ChunkData data) {
        throw new UnsupportedOperationException("\"intersects\" not allowed in selection filter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean matchesRegion(Point2i region) {
        if (!this.loaded.get().booleanValue()) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.loaded.get().booleanValue()) {
                    this.loadSelection((File)this.value);
                }
            }
        }
        return switch (this.getComparator()) {
            case Comparator.EQUAL -> this.selection.isAnyChunkInRegionSelected(region);
            case Comparator.NOT_EQUAL -> {
                if (!this.selection.isAnyChunkInRegionSelected(region)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public String getFormatText() {
        return "<.csv selection file>";
    }

    protected void loadSelection(File value) {
        this.selection.clear();
        try {
            Selection loaded = Selection.readFromFile(value);
            this.selection.setSelection(loaded);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.loaded.set(true);
    }

    @Override
    public Filter<File> clone() {
        SelectionFilter clone = new SelectionFilter(this.getType(), this.getOperator(), this.getComparator(), (File)this.getFilterValue(), this.lock);
        clone.selection = this.selection;
        clone.loaded = this.loaded;
        return clone;
    }

    public String toString() {
        return "Selection " + this.getComparator().getQueryString() + " \"" + this.getRawValue().replace("\\", "\\\\") + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetTempData() {
        Object object = this.lock;
        synchronized (object) {
            this.selection.clear();
            this.loaded.set(false);
        }
    }
}

