/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter.filters;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.File;
import java.io.Serializable;
import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.filter.RegionMatcher;
import net.querz.mcaselector.filter.TextFilter;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.property.DataProperty;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.IntTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.NBTUtil;
import net.querz.nbt.StringTag;
import net.querz.nbt.Tag;

public class PlayerLocationFilter
extends TextFilter<PlayerLocationFilterDefinition>
implements RegionMatcher {
    protected LongOpenHashSet playerChunks = new LongOpenHashSet();
    protected LongOpenHashSet playerRegions = new LongOpenHashSet();
    protected final Object lock;
    protected DataProperty<Boolean> loaded = new DataProperty<Boolean>(false);
    private static final Comparator[] comparators = new Comparator[]{Comparator.CONTAINS, Comparator.CONTAINS_NOT};

    public PlayerLocationFilter() {
        this(Operator.AND, Comparator.CONTAINS, null);
    }

    private PlayerLocationFilter(Operator operator, Comparator comparator, PlayerLocationFilterDefinition value) {
        this(FilterType.PLAYER_DATA, operator, comparator, value, new Object());
    }

    protected PlayerLocationFilter(FilterType type, Operator operator, Comparator comparator, PlayerLocationFilterDefinition value, Object lock) {
        super(type, operator, comparator, value);
        this.lock = lock;
        this.setRawValue(value == null ? "" : value.toString());
    }

    @Override
    public Comparator[] getComparators() {
        return comparators;
    }

    @Override
    public void setFilterValue(String raw) {
        Object dimension;
        String[] separated = raw.split(File.pathSeparator, 2);
        if (separated.length != 2) {
            this.setValid(false);
            this.setValue(null);
            return;
        }
        File file = new File(separated[0]);
        if (!file.exists() || !file.isDirectory()) {
            this.setValid(false);
            this.setValue(null);
            return;
        }
        if (separated[1].matches("^-?[0-9]+$")) {
            try {
                dimension = Integer.parseInt(separated[1]);
            }
            catch (NumberFormatException ex) {
                this.setValid(false);
                this.setValue(null);
                return;
            }
        } else {
            dimension = separated[1];
        }
        this.setValid(true);
        this.setValue(new PlayerLocationFilterDefinition(file, dimension));
        this.setRawValue(raw);
    }

    @Override
    public PlayerLocationFilter clone() {
        PlayerLocationFilter clone = new PlayerLocationFilter(this.getType(), this.getOperator(), this.getComparator(), this.getFilterValue() == null ? null : ((PlayerLocationFilterDefinition)this.getFilterValue()).clone(), this.lock);
        clone.playerChunks = this.playerChunks;
        clone.playerRegions = this.playerRegions;
        clone.loaded = this.loaded;
        return clone;
    }

    @Override
    public String getFormatText() {
        return "<directory>" + File.pathSeparator + "<dimension>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(PlayerLocationFilterDefinition value, ChunkData data) {
        if (data.region() == null || data.region().getData() == null) {
            return false;
        }
        if (!this.loaded.get().booleanValue()) {
            Object object = this.lock;
            synchronized (object) {
                if (this.playerChunks.isEmpty()) {
                    this.loadPlayerData(value);
                }
            }
        }
        ChunkFilter.Pos pos = VersionHandler.getImpl(data, ChunkFilter.Pos.class);
        IntTag xPos = pos.getXPos(data);
        IntTag zPos = pos.getZPos(data);
        if (xPos == null || zPos == null) {
            return false;
        }
        return this.playerChunks.contains(new Point2i(xPos.asInt(), zPos.asInt()).asLong());
    }

    @Override
    public boolean containsNot(PlayerLocationFilterDefinition value, ChunkData data) {
        return !this.contains(value, data);
    }

    @Override
    public boolean intersects(PlayerLocationFilterDefinition value, ChunkData data) {
        throw new UnsupportedOperationException("\"intersects\" not allowed in player filter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean matchesRegion(Point2i region) {
        if (!this.loaded.get().booleanValue()) {
            Object object = this.lock;
            synchronized (object) {
                if (this.playerRegions.isEmpty()) {
                    this.loadPlayerData((PlayerLocationFilterDefinition)this.value);
                }
            }
        }
        return switch (this.getComparator()) {
            case Comparator.CONTAINS -> this.playerRegions.contains(region.asLong());
            case Comparator.CONTAINS_NOT -> {
                if (!this.playerRegions.contains(region.asLong())) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    protected void loadPlayerData(PlayerLocationFilterDefinition value) {
        this.playerChunks.clear();
        this.playerRegions.clear();
        File[] playerFiles = value.directory.listFiles((d, f) -> f.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}\\.dat$"));
        if (playerFiles == null || playerFiles.length == 0) {
            return;
        }
        for (File playerFile : playerFiles) {
            try {
                CompoundTag root = (CompoundTag)NBTUtil.read(playerFile);
                ListTag pos = root.getListTag("Pos");
                if (pos.size() != 3) continue;
                Tag dimTag = root.get("Dimension");
                Object dim = null;
                if (dimTag instanceof IntTag) {
                    dim = root.getInt("Dimension");
                } else if (dimTag instanceof StringTag) {
                    dim = root.getString("Dimension");
                }
                if (!value.dimension.equals(dim)) continue;
                Point2i playerLocation = new Point2i(pos.getInt(0), pos.getInt(2));
                this.playerChunks.add(playerLocation.blockToChunk().asLong());
                this.playerRegions.add(playerLocation.blockToRegion().asLong());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.loaded.set(true);
    }

    public String toString() {
        return "PlayerLocation " + this.getComparator().getQueryString() + " \"" + this.getRawValue().replace("\\", "\\\\") + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetTempData() {
        Object object = this.lock;
        synchronized (object) {
            this.playerChunks.clear();
            this.playerRegions.clear();
            this.loaded.set(false);
        }
    }

    public static class PlayerLocationFilterDefinition
    implements Serializable {
        File directory;
        Object dimension;

        public PlayerLocationFilterDefinition(File directory, Object dimension) {
            this.directory = directory;
            this.dimension = dimension;
        }

        public String toString() {
            return String.valueOf(this.directory) + File.pathSeparator + String.valueOf(this.dimension);
        }

        public PlayerLocationFilterDefinition clone() {
            return new PlayerLocationFilterDefinition(this.directory, this.dimension);
        }
    }
}

