/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.filter.TextFilter;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.mcaselector.version.mapping.registry.BlockRegistry;

public class PaletteFilter
extends TextFilter<List<String>> {
    private static final Comparator[] comparators = new Comparator[]{Comparator.CONTAINS, Comparator.CONTAINS_NOT, Comparator.INTERSECTS, Comparator.EQUAL, Comparator.NOT_EQUAL};

    public PaletteFilter() {
        this(Operator.AND, Comparator.CONTAINS, null);
    }

    private PaletteFilter(Operator operator, Comparator comparator, List<String> value) {
        super(FilterType.PALETTE, operator, comparator, value);
        this.setRawValue(String.join((CharSequence)",", value == null ? new ArrayList(0) : value));
    }

    @Override
    public Comparator[] getComparators() {
        return comparators;
    }

    @Override
    public boolean matches(ChunkData data) {
        return switch (this.getComparator()) {
            case Comparator.CONTAINS -> this.contains((List)this.value, data);
            case Comparator.CONTAINS_NOT -> this.containsNot((List)this.value, data);
            case Comparator.INTERSECTS -> this.intersects((List)this.value, data);
            case Comparator.EQUAL -> this.equals((List)this.value, data);
            case Comparator.NOT_EQUAL -> this.notEquals((List)this.value, data);
            default -> false;
        };
    }

    @Override
    public boolean contains(List<String> value, ChunkData data) {
        return VersionHandler.getImpl(data, ChunkFilter.Blocks.class).matchBlockNames(data, value);
    }

    @Override
    public boolean containsNot(List<String> value, ChunkData data) {
        return !this.contains(value, data);
    }

    @Override
    public boolean intersects(List<String> value, ChunkData data) {
        return VersionHandler.getImpl(data, ChunkFilter.Blocks.class).matchAnyBlockName(data, value);
    }

    public boolean equals(List<String> value, ChunkData data) {
        return VersionHandler.getImpl(data, ChunkFilter.Palette.class).paletteEquals(data, value);
    }

    public boolean notEquals(List<String> values, ChunkData data) {
        return !this.equals(values, data);
    }

    @Override
    public void setFilterValue(String raw) {
        String[] blockNames = BlockRegistry.parseBlockNames(raw);
        if (blockNames == null) {
            this.setValid(false);
            this.setValue(null);
        } else {
            this.setValid(true);
            this.setValue(Arrays.asList(blockNames));
            this.setRawValue(raw);
        }
    }

    @Override
    public String getFormatText() {
        return "<block>[,<block>,...]";
    }

    public String toString() {
        return "Palette " + this.getComparator().getQueryString() + " \"" + this.getRawValue() + "\"";
    }

    @Override
    public PaletteFilter clone() {
        return new PaletteFilter(this.getOperator(), this.getComparator(), new ArrayList<String>((Collection)this.value));
    }
}

