/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.filter.TextFilter;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.mcaselector.version.mapping.registry.EntityRegistry;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.Tag;

public class EntityFilter
extends TextFilter<List<String>> {
    private static final Pattern entityNamePattern = Pattern.compile("^(?<space>[a-z_]*):?(?<id>[a-z_]*)$");

    public EntityFilter() {
        this(Operator.AND, Comparator.CONTAINS, null);
    }

    private EntityFilter(Operator operator, Comparator comparator, List<String> value) {
        super(FilterType.ENTITIES, operator, comparator, value);
        this.setRawValue(String.join((CharSequence)",", value == null ? new ArrayList(0) : value));
    }

    @Override
    public boolean contains(List<String> value, ChunkData data) {
        ListTag entities = VersionHandler.getImpl(data, ChunkFilter.Entities.class).getEntities(data);
        if (entities == null || entities.getType() == Tag.Type.LONG_ARRAY) {
            return false;
        }
        block0: for (String name : (List)this.getFilterValue()) {
            for (CompoundTag entity : entities.iterateType(CompoundTag.class)) {
                String id = entity.getString("id");
                if (!name.equals(id)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean intersects(List<String> value, ChunkData data) {
        ListTag entities = VersionHandler.getImpl(data, ChunkFilter.Entities.class).getEntities(data);
        if (entities == null || entities.getType() == Tag.Type.LONG_ARRAY) {
            return false;
        }
        for (String name : (List)this.getFilterValue()) {
            for (CompoundTag entity : entities.iterateType(CompoundTag.class)) {
                String id = entity.getString("id");
                if (!name.equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsNot(List<String> value, ChunkData data) {
        return !this.contains(value, data);
    }

    @Override
    public void setFilterValue(String raw) {
        String[] rawEntityNames = raw.replace(" ", "").split(",");
        if (raw.isEmpty() || rawEntityNames.length == 0) {
            this.setValid(false);
            this.setValue(null);
        } else {
            for (int i = 0; i < rawEntityNames.length; ++i) {
                Object name = rawEntityNames[i];
                Matcher m = entityNamePattern.matcher((CharSequence)name);
                if (m.matches() && m.group("id").isEmpty()) {
                    rawEntityNames[i] = name = "minecraft:" + m.group("space");
                }
                if (((String)name).startsWith("'") && ((String)name).endsWith("'") && ((String)name).length() >= 2 && !((String)name).contains("\"")) {
                    rawEntityNames[i] = ((String)name).substring(1, ((String)name).length() - 1);
                    continue;
                }
                if (EntityRegistry.isValidName((String)name)) continue;
                this.setValue(null);
                this.setValid(false);
                return;
            }
            this.setValid(true);
            this.setValue(Arrays.asList(rawEntityNames));
            this.setRawValue(raw);
        }
    }

    @Override
    public String getFormatText() {
        return "<entity>[,<entity>,...]";
    }

    public String toString() {
        return "Entities " + this.getComparator().getQueryString() + " \"" + this.getRawValue() + "\"";
    }

    @Override
    public EntityFilter clone() {
        return new EntityFilter(this.getOperator(), this.getComparator(), new ArrayList<String>((Collection)this.value));
    }
}

