/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter.filters;

import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.Filter;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.filter.TextFilter;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.io.mca.CompressionType;

public class CompressionFilter
extends TextFilter<CompressionType> {
    private static final Comparator[] comparators = new Comparator[]{Comparator.EQUAL, Comparator.NOT_EQUAL};

    public CompressionFilter() {
        this(Operator.AND, Comparator.EQUAL, null, null);
    }

    private CompressionFilter(Operator operator, Comparator comparator, String rawValue, CompressionType value) {
        super(FilterType.COMPRESSION, operator, comparator, value);
        this.setRawValue(rawValue);
    }

    @Override
    public Comparator[] getComparators() {
        return comparators;
    }

    @Override
    public String getFormatText() {
        return "TYPE";
    }

    @Override
    public boolean matches(ChunkData data) {
        return switch (this.getComparator()) {
            case Comparator.EQUAL -> this.isEqual((CompressionType)((Object)this.value), data);
            case Comparator.NOT_EQUAL -> {
                if (!this.isEqual((CompressionType)((Object)this.value), data)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public boolean isEqual(CompressionType value, ChunkData data) {
        return !(data.region() == null && data.entities() == null && data.poi() == null || data.region() != null && data.region().getCompressionType() != value || data.entities() != null && data.entities().getCompressionType() != value || data.poi() != null && data.poi().getCompressionType() != value);
    }

    @Override
    public boolean contains(CompressionType value, ChunkData data) {
        throw new UnsupportedOperationException("\"contains\" not allowed in CompressionFilter");
    }

    @Override
    public boolean containsNot(CompressionType value, ChunkData data) {
        throw new UnsupportedOperationException("\"!contains\" not allowed in CompressionFilter");
    }

    @Override
    public boolean intersects(CompressionType value, ChunkData data) {
        throw new UnsupportedOperationException("\"intersects\" not allowed in CompressionFilter");
    }

    @Override
    public void setFilterValue(String raw) {
        for (CompressionType t : CompressionType.values()) {
            if (!t.toString().equalsIgnoreCase(raw)) continue;
            this.setValue(t);
            this.setRawValue(raw);
            this.setValid(true);
            return;
        }
        this.setValue(null);
        this.setValid(false);
    }

    public String toString() {
        return "Compression " + this.getComparator().getQueryString() + " " + ((CompressionType)((Object)this.getFilterValue())).toString();
    }

    @Override
    public Filter<CompressionType> clone() {
        return new CompressionFilter(this.getOperator(), this.getComparator(), this.getRawValue(), (CompressionType)((Object)this.value));
    }
}

