/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter.filters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.Filter;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.filter.RegionMatcher;
import net.querz.mcaselector.filter.TextFilter;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.text.TextHelper;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.nbt.IntTag;

public class CircleFilter
extends TextFilter<List<CircleFilterDefinition>>
implements RegionMatcher {
    private static final Comparator[] comparators = new Comparator[]{Comparator.CONTAINS, Comparator.CONTAINS_NOT};

    public CircleFilter() {
        this(Operator.AND, Comparator.CONTAINS, null);
    }

    CircleFilter(Operator operator, Comparator comparator, List<CircleFilterDefinition> value) {
        super(FilterType.CIRCLE, operator, comparator, value);
        this.setRawValue(value == null ? "" : value.stream().map(CircleFilterDefinition::toString).collect(Collectors.joining(",")));
    }

    @Override
    public Comparator[] getComparators() {
        return comparators;
    }

    @Override
    public void setFilterValue(String raw) {
        String[] split;
        if (raw == null) {
            this.setValid(false);
            this.setValue(null);
            return;
        }
        ArrayList<CircleFilterDefinition> centers = new ArrayList<CircleFilterDefinition>();
        for (String c : split = raw.split(",")) {
            String[] rawCoordinate = c.split(";");
            if (rawCoordinate.length != 3) {
                this.setValid(false);
                this.setValue(null);
                return;
            }
            Integer x = TextHelper.parseInt(rawCoordinate[0], 10);
            Integer z = TextHelper.parseInt(rawCoordinate[1], 10);
            Integer r = TextHelper.parseInt(rawCoordinate[2], 10);
            if (x == null || z == null || r == null || r < 0) {
                this.setValid(false);
                this.setValue(null);
                return;
            }
            centers.add(new CircleFilterDefinition(new Point2i(x, z), r));
        }
        this.setValid(true);
        this.setValue(centers);
        this.setRawValue(raw);
    }

    @Override
    public Filter<List<CircleFilterDefinition>> clone() {
        return new CircleFilter(this.getOperator(), this.getComparator(), new ArrayList<CircleFilterDefinition>((Collection)this.value));
    }

    @Override
    public String getFormatText() {
        return "<x>;<z>;<r>[,<x>;<z>;<r>...]";
    }

    @Override
    public boolean contains(List<CircleFilterDefinition> value, ChunkData data) {
        if (data.region() == null || data.region().getData() == null) {
            return false;
        }
        ChunkFilter.Pos pos = VersionHandler.getImpl(data, ChunkFilter.Pos.class);
        IntTag xPos = pos.getXPos(data);
        IntTag zPos = pos.getZPos(data);
        if (xPos == null || zPos == null) {
            return false;
        }
        Point2i chunk = new Point2i(xPos.asInt(), zPos.asInt());
        for (CircleFilterDefinition circle : value) {
            if (!circle.matches(chunk)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsNot(List<CircleFilterDefinition> value, ChunkData data) {
        return !this.contains(value, data);
    }

    @Override
    public boolean intersects(List<CircleFilterDefinition> value, ChunkData data) {
        throw new UnsupportedOperationException("\"intersects\" not allowed in circle filter");
    }

    @Override
    public boolean matchesRegion(Point2i region) {
        Point2i topLeft = region.regionToChunk();
        Point2i bottomLeft = topLeft.add(0, 31);
        Point2i bottomRight = topLeft.add(31, 31);
        Point2i topRight = topLeft.add(31, 0);
        switch (this.getComparator()) {
            case CONTAINS: {
                for (CircleFilterDefinition circle : (List)this.value) {
                    if (circle.center.chunkToRegion().equals(region)) {
                        return true;
                    }
                    if (circle.matches(topLeft) || circle.matches(bottomLeft) || circle.matches(bottomRight) || circle.matches(topRight)) {
                        return true;
                    }
                    Point2i topMost = circle.center.sub(0, circle.radius);
                    Point2i rightMost = circle.center.add(circle.radius, 0);
                    Point2i bottomMost = circle.center.add(0, circle.radius);
                    Point2i leftMost = circle.center.sub(circle.radius, 0);
                    if (circle.center.chunkToRegion().getX() == region.getX()) {
                        if (circle.center.getZ() > bottomLeft.getZ() && topMost.getZ() <= bottomLeft.getZ()) {
                            return true;
                        }
                        if (circle.center.getZ() >= topRight.getZ() || bottomMost.getZ() < topRight.getZ()) continue;
                        return true;
                    }
                    if (circle.center.chunkToRegion().getZ() != region.getZ()) continue;
                    if (circle.center.getX() < bottomLeft.getX() && rightMost.getX() >= bottomLeft.getX()) {
                        return true;
                    }
                    if (circle.center.getX() <= topRight.getX() || leftMost.getX() > topRight.getX()) continue;
                    return true;
                }
                return false;
            }
            case CONTAINS_NOT: {
                for (CircleFilterDefinition circle : (List)this.value) {
                    if (!circle.matches(topLeft) || !circle.matches(bottomLeft) || !circle.matches(bottomRight) || !circle.matches(topRight)) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }

    public String toString() {
        return "Circle " + this.getComparator().getQueryString() + " \"" + this.getRawValue() + "\"";
    }

    public static class CircleFilterDefinition
    implements Serializable {
        Point2i center;
        int radius;

        public CircleFilterDefinition(Point2i center, int radius) {
            this.center = center;
            this.radius = radius;
        }

        public String toString() {
            return this.center.getX() + ";" + this.center.getZ() + ";" + this.radius;
        }

        public CircleFilterDefinition clone() {
            return new CircleFilterDefinition(this.center.clone(), this.radius);
        }

        public boolean matches(Point2i p) {
            if (p.equals(this.center)) {
                return true;
            }
            double distSquared = Math.pow(p.getX() - this.center.getX(), 2.0) + Math.pow(p.getZ() - this.center.getZ(), 2.0);
            return distSquared <= ((double)this.radius + 0.3) * ((double)this.radius + 0.3);
        }
    }
}

