/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.Filter;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.filter.TextFilter;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.mcaselector.version.mapping.registry.BiomeRegistry;

public class BiomeFilter
extends TextFilter<List<BiomeRegistry.BiomeIdentifier>> {
    public BiomeFilter() {
        this(Operator.AND, Comparator.CONTAINS, null);
    }

    private BiomeFilter(Operator operator, Comparator comparator, List<BiomeRegistry.BiomeIdentifier> value) {
        super(FilterType.BIOME, operator, comparator, value);
        if (value == null) {
            this.setRawValue("");
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < value.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(value.get(i));
            }
            this.setRawValue(sb.toString());
        }
    }

    @Override
    public String getFormatText() {
        return "<biome>[,<biome>,...]";
    }

    @Override
    public boolean contains(List<BiomeRegistry.BiomeIdentifier> value, ChunkData data) {
        return VersionHandler.getImpl(data, ChunkFilter.Biomes.class).matchBiomes(data, value);
    }

    @Override
    public boolean containsNot(List<BiomeRegistry.BiomeIdentifier> value, ChunkData data) {
        return !this.contains(value, data);
    }

    @Override
    public boolean intersects(List<BiomeRegistry.BiomeIdentifier> value, ChunkData data) {
        return VersionHandler.getImpl(data, ChunkFilter.Biomes.class).matchAnyBiome(data, value);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setFilterValue(String raw) {
        String[] rawBiomeNames = raw.replace(" ", "").split(",");
        if (raw.isEmpty() || rawBiomeNames.length == 0) {
            this.setValid(false);
            this.setValue(null);
        } else {
            ArrayList<BiomeRegistry.BiomeIdentifier> nameList = new ArrayList<BiomeRegistry.BiomeIdentifier>();
            for (String string : rawBiomeNames) {
                void var7_7;
                boolean quoted = false;
                if (string.startsWith("'") && string.endsWith("'") && string.length() > 2) {
                    String string2 = string.substring(1, string.length() - 1);
                    quoted = true;
                } else if (!string.matches("^[0-9]+$") && !string.startsWith("minecraft:")) {
                    String string3 = "minecraft:" + string;
                }
                if (var7_7.matches("^[0-9]+$")) {
                    try {
                        int id = Integer.parseInt((String)var7_7);
                        if (!quoted && !BiomeRegistry.isValidID(id)) {
                            this.setValid(false);
                            this.setValue(null);
                            return;
                        }
                        nameList.add(new BiomeRegistry.BiomeIdentifier(id));
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        this.setValid(false);
                        this.setValue(null);
                        return;
                    }
                }
                if (quoted || BiomeRegistry.isValidName((String)var7_7)) {
                    nameList.add(new BiomeRegistry.BiomeIdentifier((String)var7_7));
                    continue;
                }
                this.setValid(false);
                this.setValue(null);
                return;
            }
            this.setValid(true);
            this.setValue(nameList);
            this.setRawValue(raw);
        }
    }

    public String toString() {
        return "Biome " + this.getComparator().getQueryString() + " \"" + this.getRawValue() + "\"";
    }

    @Override
    public Filter<List<BiomeRegistry.BiomeIdentifier>> clone() {
        return new BiomeFilter(this.getOperator(), this.getComparator(), new ArrayList<BiomeRegistry.BiomeIdentifier>((Collection)this.value));
    }
}

