/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter;

import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.Filter;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.io.mca.ChunkData;

public abstract class NumberFilter<T extends Number>
extends Filter<T> {
    private static final Comparator[] comparators = new Comparator[]{Comparator.EQUAL, Comparator.NOT_EQUAL, Comparator.LARGER, Comparator.SMALLER, Comparator.LARGER_EQUAL, Comparator.SMALLER_EQUAL};
    private Comparator comparator;

    public NumberFilter(FilterType type, Operator operator, Comparator comparator) {
        super(type, operator);
        this.comparator = comparator;
    }

    @Override
    public T getFilterValue() {
        return this.getFilterNumber();
    }

    @Override
    public Comparator[] getComparators() {
        return comparators;
    }

    @Override
    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public boolean matches(T value, T data, Comparator comparator) {
        return switch (comparator) {
            case Comparator.EQUAL -> this.isEqual(data, value);
            case Comparator.NOT_EQUAL -> this.isNotEqual(data, value);
            case Comparator.LARGER -> this.isLargerThan(data, value);
            case Comparator.SMALLER -> this.isSmallerThan(data, value);
            case Comparator.LARGER_EQUAL -> this.isLargerEqual(data, value);
            case Comparator.SMALLER_EQUAL -> this.isSmallerEqual(data, value);
            default -> false;
        };
    }

    @Override
    public boolean matches(ChunkData data) {
        return this.matches(this.getFilterNumber(), this.getNumber(data), this.comparator);
    }

    public String toString() {
        return String.valueOf((Object)this.getType()) + " " + this.comparator.getQueryString() + " " + String.valueOf(this.getFilterValue());
    }

    public abstract String getFormatText();

    protected abstract T getFilterNumber();

    protected abstract void setFilterNumber(T var1);

    protected abstract T getNumber(ChunkData var1);

    protected abstract boolean isEqual(T var1, T var2);

    protected abstract boolean isNotEqual(T var1, T var2);

    protected abstract boolean isLargerThan(T var1, T var2);

    protected abstract boolean isSmallerThan(T var1, T var2);

    protected abstract boolean isLargerEqual(T var1, T var2);

    protected abstract boolean isSmallerEqual(T var1, T var2);
}

