/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter;

import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.NumberFilter;
import net.querz.mcaselector.filter.Operator;

public abstract class LongFilter
extends NumberFilter<Long> {
    protected long value;

    public LongFilter(FilterType type, Operator operator, Comparator comparator, long value) {
        super(type, operator, comparator);
        this.value = value;
        this.setRawValue("" + value);
    }

    @Override
    protected Long getFilterNumber() {
        return this.value;
    }

    @Override
    protected void setFilterNumber(Long value) {
        this.value = value;
    }

    @Override
    public void setFilterValue(String raw) {
        if (raw == null) {
            this.setFilterNumber(0L);
            this.setValid(false);
        } else {
            try {
                this.setFilterNumber(Long.parseLong(raw.replace(" ", "")));
                this.setValid(true);
                this.setRawValue(raw);
            }
            catch (NumberFormatException ex) {
                this.setFilterNumber(0L);
                this.setValid(false);
            }
        }
    }

    @Override
    protected boolean isEqual(Long a, Long b) {
        return a.longValue() == b.longValue();
    }

    @Override
    protected boolean isNotEqual(Long a, Long b) {
        return a.longValue() != b.longValue();
    }

    @Override
    protected boolean isLargerThan(Long a, Long b) {
        return a > b;
    }

    @Override
    protected boolean isSmallerThan(Long a, Long b) {
        return a < b;
    }

    @Override
    protected boolean isLargerEqual(Long a, Long b) {
        return a >= b;
    }

    @Override
    protected boolean isSmallerEqual(Long a, Long b) {
        return a <= b;
    }

    @Override
    public String getFormatText() {
        return "\u00b1long";
    }
}

